#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stdlib/string.hpp"

namespace acl {

class mime_code;
class ostream;

/**
 * ׫дʼʱڴʼصĹ
 */
class ACL_CPP_API mail_attach
{
public:
	/**
	 * һͨļʼʱĹ캯
	 * @param filepath {const char*} ļ洢·ļ
	 * @param content_type {const char*} ļ
	 * @param charset {const char*} Ϊļ˲ıַ
	 */
	mail_attach(const char* filepath, const char* content_type,
		const char* charset);
	~mail_attach();

	/**
	 * øļڲԶļ rfc2047 ʽб
	 * @param name {const char*} ǿַ
	 * @param charset {const char*} òַָ NULL ʱ
	 *  Զʹ rfc2047 ʽļб룬ڲֱӴ洢
	 * @return {mail_attach&}
	 */
	mail_attach& set_filename(const char* name, const char* charset = NULL);

	/**
	 * ʼеΪ multipart/relative ʱô˺е
	 * html  cid ʶ
	 * @param id {const char*} cid ʶ
	 * @return {mail_attach&}
	 */
	mail_attach& set_content_id(const char* id);

	/**
	 * ù캯ĸļ·
	 * @return {const char*}
	 */
	const char* get_filepath() const
	{
		return filepath_.c_str();
	}

	/**
	 * øļ־ rfc2047 
	 * @return {const char*}
	 */
	const char* get_filename() const
	{
		return filename_.c_str();
	}

	/**
	 * ù캯ļ
	 * @return {const char*}
	 */
	const char* get_content_type() const
	{
		return ctype_.c_str();
	}

	/**
	 *  set_content_id õĸø cid ʶ
	 * @return {const char*}
	 */
	const char* get_content_id() const
	{
		return cid_.c_str();
	}

	/**
	 * ݲôıбڴ滺
	 * @param coder {mime_code*} base64/qpȣ
	 * @param out {string&} 洢 append ʽ
	 * @return {bool} Ƿɹ
	 */
	bool save_to(mime_code* coder, string& out);

	/**
	 * ݲôıб
	 * @param coder {mime_code*} base64/qpȣ
	 * @param out {out&} 洢
	 * @return {bool} Ƿɹ
	 */
	bool save_to(mime_code* coder, ostream& out);

	/**
	 * ø MIME ʼеļͷϢ
	 * @param transfer_encoding {const char*} 뷽ʽ
	 * @param out {string&} 洢 append ʽ
	 */
	void build_header(const char* transfer_encoding, string& out);

private:
	string filepath_;
	string filename_;
	string ctype_;
	string cid_;
	string charset_;

	bool rfc2047_encode(const char* name, const char* charset, string& out);
};

} // namespace acl
