#ifndef	ACL_CACHE2_INCLUDE_H
#define	ACL_CACHE2_INCLUDE_H

#ifdef	__cplusplus
extern "C" {
#endif
#include "acl_define.h"
#include <time.h>

/**
 * д洢Ļ
 */
typedef struct ACL_CACHE2_INFO {
	char *key;		/**< ֵ */
	void *value;		/**< û̬ */
	int   nrefer;		/**< ü */
	time_t when_timeout;	/**< ʱ */
} ACL_CACHE2_INFO;

/**
 * 
 */
typedef struct ACL_CACHE2 { 
	int   max_size;		/**< Сֵ */
	int   size;		/**< ǰеĻ */

	/**< ͷû̬ͷŻص */
	void  (*free_fn)(const ACL_CACHE2_INFO*, void *);

	/* for acl_iterator */

	/* ȡͷ */
	void *(*iter_head)(ACL_ITER*, struct ACL_CACHE2*);
	/* ȡһ */
	void *(*iter_next)(ACL_ITER*, struct ACL_CACHE2*);
	/* ȡβ */
	void *(*iter_tail)(ACL_ITER*, struct ACL_CACHE2*);
	/* ȡһ */
	void *(*iter_prev)(ACL_ITER*, struct ACL_CACHE2*);
	/* ȡĵǰԱṹ */
	ACL_CACHE2_INFO *(*iter_info)(ACL_ITER*, struct ACL_CACHE2*);
} ACL_CACHE2;

/**
 * һأÿ󻺴ʱûصĿռ
 * @param max_size {int} ûص
 * @param free_fn {void (*)(void*)} ûͷŻĺ
 * @return {ACL_CACHE2*} ض
 */
ACL_API ACL_CACHE2 *acl_cache2_create(int max_size,
	void (*free_fn)(const ACL_CACHE2_INFO*, void*));

/**
 * ͷһ
 * @param cache2 {ACL_CACHE2*} ض
 */
ACL_API void acl_cache2_free(ACL_CACHE2 *cache2);

/**
 * 򻺴ӱĶ
 * @param cache2 {ACL_CACHE2*} ض
 * @param key {const char*} Ľֵ
 * @param value {void*} ̬
 * @param timeout {int} ÿĻʱ
 * @return {ACL_CACHE2_INFO*} Ľṹе value ûĶͬ,
 *    NULL ʾʧܣʧԭΪֵ̫ͬĶ
 *   ü0; ط NULL ʾӳɹͬһֵظӣ
 *   µ滻ɵݣҾݵͷźͷ
 */
ACL_API ACL_CACHE2_INFO *acl_cache2_enter(ACL_CACHE2 *cache2,
	const char *key, void *value, int timeout);

/**
 * ӻвĳĶ
 * @param cache2 {ACL_CACHE2*} ض
 * @param key {const char*} ѯ
 * @return {void*} ûĵַΪNULLʱʾδҵ
 */
ACL_API void *acl_cache2_find(ACL_CACHE2 *cache2, const char *key);

/**
 * ӻвĳĶĻϢ
 * @param cache2 {ACL_CACHE2*} ض
 * @param key {const char*} ѯ
 * @return {ACL_CACHE2_INFO*} ϢַΪNULLʱʾδҵ
 */
ACL_API ACL_CACHE2_INFO *acl_cache2_locate(ACL_CACHE2 *cache2, const char *key);

/**
 * ӻɾĳ
 * @param cache2 {ACL_CACHE2*} ض
 * @param info {ACL_CACHE2_INFO*} ûĻϢ
 * @return {int} 0: ʾɾɹ; -1: ʾöü0ö󲻴
 */
ACL_API int acl_cache2_delete(ACL_CACHE2 *cache2, ACL_CACHE2_INFO *info);

/**
 * ӻɾĳ
 * @param cache2 {ACL_CACHE2*} ض
 * @param key {const char*} ֵ
 * @return {int} 0: ʾɾɹ; -1: ʾöü0ö󲻴
 */
ACL_API int acl_cache2_delete2(ACL_CACHE2 *cache2, const char *key);

/**
 * ʹеĹڶԶɾ
 * @param cache2 {ACL_CACHE2*} ض
 * @return {int} >= 0: ԶɾĻĸ
 */
ACL_API int acl_cache2_timeout(ACL_CACHE2 *cache2);

/**
 * ʹĳĻʱӳ
 * @param cache2 {ACL_CACHE2*} ض
 * @param info {ACL_CACHE2_INFO*} 
 * @param timeout {int} ʱ()
 */
ACL_API void acl_cache2_update2(ACL_CACHE2 *cache2, ACL_CACHE2_INFO *info, int timeout);

/**
 * ʹĳĻʱӳ
 * @param cache2 {ACL_CACHE2*} ض
 * @param key {const char*} ֵ
 * @param timeout {int} ʱ()
 */
ACL_API void acl_cache2_update(ACL_CACHE2 *cache2, const char *key, int timeout);

/**
 * ĳüֹǰɾ
 * @param info {ACL_CACHE2_INFO*} ûĻϢ
 */
ACL_API void acl_cache2_refer(ACL_CACHE2_INFO *info);

/**
 * ĳüֹǰɾ
 * @param cache2 {ACL_CACHE2*} ض
 * @param key {const char*}
 */
ACL_API void acl_cache2_refer2(ACL_CACHE2 *cache2, const char *key);

/**
 * ĳü
 * @param info {ACL_CACHE2_INFO*} ûĻϢ
 */
ACL_API void acl_cache2_unrefer(ACL_CACHE2_INFO *info);

/**
 * ĳü
 * @param cache2 {ACL_CACHE2*} ض
 * @param key {const char*}
 */
ACL_API void acl_cache2_unrefer2(ACL_CACHE2 *cache2, const char *key);

/**
 * ضڶ߳ʱ
 * @param cache2 {ACL_CACHE2*} ض
 */
ACL_API void acl_cache2_lock(ACL_CACHE2 *cache2);

/**
 * ضڶ߳ʱ
 * @param cache2 {ACL_CACHE2*} ض
 */
ACL_API void acl_cache2_unlock(ACL_CACHE2 *cache2);

/**
 * еж
 * @param cache2 {ACL_CACHE2*} ض
 * @param walk_fn {void (*)(ACL_CACHE2_INFO*, void*)} ص
 * @param arg {void *} walk_fn()/2 еĵڶ
 */
ACL_API void acl_cache2_walk(ACL_CACHE2 *cache2,
	void (*walk_fn)(ACL_CACHE2_INFO *, void *), void *arg);

/**
 * ջеĻĳȻڱҷǿɾ򽫲ᱻ
 * @param cache2 {ACL_CACHE2*} ض
 * @param force {int} 0ʹĳü0Ҳᱻɾ
 * @return {int} Ļ
 */
ACL_API int acl_cache2_clean(ACL_CACHE2 *cache2, int force);

/**
 * ǰлĸ
 * @param cache2 {ACL_CACHE2*} ض
 * @return {int} Ķ
 */
ACL_API int acl_cache2_size(ACL_CACHE2 *cache2);

#ifdef	__cplusplus
}
#endif

#endif
