#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>

namespace acl
{

class ACL_CPP_API redis_slot
{
public:
	/**
	 * 캯
	 * constructor
	 * @param slot_min {size_t} Сϣֵ
	 *  the min hash-slot
	 * @param slot_max {size_t} ϣֵ
	 *  the max hash-slot
	 * @param ip {const char*} ǰ redis-server  IP ַ
	 *  the given redis-server's ip
	 * @param port {int} ǰ redis-server ļ˿
	 *  the listening port of the given redis-server
	 * 
	 */
	redis_slot(size_t slot_min, size_t slot_max,
		const char* ip, int port);
	redis_slot(const redis_slot& node);

	~redis_slot(void);

	/**
	 * һ redis ϣ۴ӽǰ
	 * add a slave slot node to the current node
	 * @param node {redis_slot*} һ洢ϣ۵Ĵӽ
	 *  the slave slot node
	 */
	redis_slot& add_slave(redis_slot* node);

	/**
	 * õǰϣ۽дӽ
	 * get the slave nodes of the current node
	 * @return {const std::vector<redis_slot*>&}
	 */
	const std::vector<redis_slot*>& get_slaves() const
	{
		return slaves_;
	}

	/**
	 * õǰ IP ַ
	 * get the ip of the current node
	 * @return {const char*}
	 */
	const char* get_ip(void) const
	{
		return ip_;
	}

	/**
	 * õǰĶ˿ں
	 * get the port of the current node
	 * @return {int}
	 */
	int get_port(void) const
	{
		return port_;
	}

	/**
	 * õǰϣ۽Сֵ
	 * get the min hash slot of the current node
	 * @return {size_t}
	 */
	size_t get_slot_min(void) const
	{
		return slot_min_;
	}

	/**
	 * õǰϣ۽ֵ
	 * get the max hash slot of the current node
	 * @return {size_t}
	 */
	size_t get_slot_max(void) const
	{
		return slot_max_;
	}

private:
	size_t slot_min_;
	size_t slot_max_;
	char ip_[128];
	int port_;

	std::vector<redis_slot*> slaves_;
};

} // namespace acl
