#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/redis/redis_command.hpp"

namespace acl
{

class redis_client;

class ACL_CPP_API redis_set : virtual public redis_command
{
public:
	/**
	 * see redis_command::redis_command()
	 */
	redis_set(void);

	/**
	 * see redis_command::redis_command(redis_client*)
	 */
	redis_set(redis_client* conn);

	/**
	 * see redis_command::redis_command(redis_client_cluster*, size_t)
	 */
	redis_set(redis_client_cluster* cluster, size_t max_conns = 0);

	virtual ~redis_set(void);

	/////////////////////////////////////////////////////////////////////

	/**
	 * һ member Ԫؼ뵽 key УѾڼϵ member Ԫ
	 * ;
	 * 1)  key ڣ򴴽һֻ member ԪԱļ
	 * 2)  key Ǽʱһ
	 * add one or more members to a set stored at a key
	 * 1) if the key doesn't exist, a new set by the key will be created,
	 *    and add the members to the set
	 * 2) if the key exists and not a set's key, then error happened
	 * @param key {const char*} ϶ļ
	 *  the key of a set
	 * @param first_member {const char*} һ NULL ĳԱ
	 *  the first member of a variable args which isn't NULL, the last
	 *  arg of the args must be NULL indicating the end of args
	 * @return {int} ӵеԪصԵԪ
	 *  the number of elements that were added to the set, not including
	 *  all the elements already present into the set. -1 if error
	 *  happened or it isn't a set stored by the key.
	 */
	int sadd(const char* key, const char* first_member, ...);
	int sadd(const char* key, const std::vector<const char*>& memsbers);
	int sadd(const char* key, const std::vector<string>& members);
	int sadd(const char* key, const char* argv[], size_t argc);
	int sadd(const char* key, const char* argv[], const size_t lens[],
		size_t argc);

	/**
	 * Ӽ϶ƳĳԱ
	 * remove and get one member from the set
	 * @param key {const char*} ϶ļ
	 *  the key of the set
	 * @param buf {string&} 洢ƳĳԱ
	 *  store the member removed from the set
	 * @return {bool}  key ڻ key ǿռʱ false
	 *  true if one member has been removed and got, false if the key
	 *  doesn't exist or it isn't a set stored at the key.
	 */
	bool spop(const char* key, string& buf);

	/**
	 * ü϶гԱ
	 * get the number of members in a set stored at the key
	 * @param key {const char*} ϶ļ
	 *  the key of the set
	 * @return {int} ظü϶гԱ£
	 *  return int value as below:
	 *  -1Ǽ϶
	 *      error or it's not a set by the key
	 *   0ԱΪջ key 
	 *      the set is empty or the key doesn't exist
	 *  >0Աǿ
	 *      the number of members in the set
	 */
	int scard(const char* key);

	/**
	 * ؼ key егԱ
	 * get all the members in a set stored at a key
	 * @param key {const char*} ϶ļֵ
	 *  the key of the set
	 * @param members {std::vector<string>*} ǿʱ洢
	 *  if not NULL, it will store the members.
	 * @return {int}  -1 ʾһ key Ǽ϶
	 *  the number of elements got, -1 if error happened or it't not
	 *  a set by the key.
	 *
	 *  ɹͨһʽ
	 *  if successul, one of below ways can be used to get the result:
	 *  1ڵ÷дǿյĴ洢ĵַ
	 *     the most easily way is to set a non-NULL result parameter
	 *     for this function 
	 *  2෽ get_value ָ±Ԫ
	 *     call redis_command::result_value with the specified subscript
	 *  3෽ get_child ָ±Ԫض(redis_resultȻͨ
	 *     redis_result::argv_to_string Ԫ
	 *     get redis_result object with the given subscript, and get the
	 *     element by redis_result::argv_to_string
	 *  4෽ get_result ȡܽ redis_resultȻͨ
	 *     redis_result::get_child һԪضȻͨʽ 2 ָ
	 *     ķøԪص
	 *     get redis_result object by redis_command::get_result, and get
	 *     the first element by redis_result::get_child, then get the
	 *     element by the way same as the way 2 above
	 *  5෽ get_children ýԪͨ redis_result 
	 *     ķ argv_to_string ÿһԪضлԪ
	 *     get child array by redis_command::get_children, and get the
	 *     element from one of redis_result array by argv_to_string
	 */
	int smembers(const char* key, std::vector<string>* members);

	/**
	 *  member Ԫش src ƶ dst 
	 * move a member from one set to another
	 * @param src {const char*} Դ϶ļֵ
	 *  the source key of a set
	 * @param dst {const char*} Ŀ꼯϶ļֵ
	 *  the destination key of a set
	 * @param member {const char*} Դ϶ĳԱ
	 *  the member in the source set
	 * @return {int} ֵ£
	 *  return int value as below:
	 *  -1Դ/ĿһǼ϶
	 *      error happened, or one of source and destination isn't a set
	 *   0Դ󲻴ڻԱԴв
	 *     the source set or the member doesn't exist
	 *   1ɹԴнһԱƶĿ
	 *      move successfully the member from source set to
	 *      the destination set
	 */
	int smove(const char* src, const char* dst, const char* member);
	int smove(const char* src, const char* dst, const string& member);
	int smove(const char* src, const char* dst,
		const char* member, size_t len);

	/**
	 * һϵȫԱüи֮Ĳ
	 * return the members of the set resulting from the difference
	 * between the first set and all the successive sets.
	 * @param members {std::vector<string>*} ǿʱ洢
	 *  if not NULL, it will store the members.
	 * @param first_key {const char*} һǿյļ϶ key
	 *  the key of the first set in a variable sets list, the last one
	 *  must be NULL indicating the end of the sets list.
	 * @return {int}  -1 ʾһ key Ǽ϶
	 *  the number of elements got, -1 if error happened or it't not
	 *  a set by the key.
	 *  ɹͨһʽ
	 *  if successul, one of below ways can be used to get the result:
	 *  1ڵ÷дǿյĴ洢ĵַ
	 *     the most easily way is to set a non-NULL result parameter
	 *     for this function
	 *  2෽ get_value ָ±Ԫ
	 *     get the specified subscript's element by redis_command::get_value
	 *  3෽ get_child ָ±Ԫض(redis_resultȻͨ
	 *     redis_result::argv_to_string Ԫ
	 *     get redis_result object with the given subscript, and get the
	 *     element by redis_result::argv_to_string
	 *  4෽ get_result ȡܽ redis_resultȻͨ
	 *     redis_result::get_child һԪضȻͨʽ 2 ָ
	 *     ķøԪص
	 *     get redis_result object by redis_command::get_result, and get
	 *     the first element by redis_result::get_child, then get the
	 *     element by the way same as the way 2 above.
	 *  5෽ get_children ýԪͨ redis_result 
	 *     ķ argv_to_string ÿһԪضлԪ
	 *     get child array by redis_command::get_children, and get the
	 *     element from one of redis_result array by argv_to_string
	 */
	int sdiff(std::vector<string>* members, const char* first_key, ...);
	int sdiff(const std::vector<const char*>& keys,
		std::vector<string>* members);
	int sdiff(const std::vector<string>& keys,
		std::vector<string>* members);

	/**
	 * һϵȫԱüиϵĽ
	 * return the members of a set resulting from the intersection of
	 * all the give sets.
	 * @param members {std::vector<string>*} ǿʱ洢
	 *  if not NULL, it will store the result
	 * @param first_key {const char*} һ϶ keyNULL
	 *  the key of the first set in a variable set list, which isn't NULL,
	 *  the last one must be NULL in the set list.
	 * @return {int}  -1 ʾһ key Ǽ϶
	 *  return the number of the members, -1 if error happened or
	 *  it't not a set by the key.
	 */
	int sinter(std::vector<string>* members, const char* first_key, ...);
	int sinter(const std::vector<const char*>& keys,
		std::vector<string>* members);
	int sinter(const std::vector<string>& keys,
		std::vector<string>* members);

	/**
	 * һϵȫԱüиϵĲ
	 * return the members of a set resulting from the union of all the
	 * given sets.
	 * @param members {std::vector<string>*} ǿʱ洢
	 *  if not NULL, it will store the result
	 * @param first_key {const char*} һ϶ keyNULL
	 *  the key of the first set in a variable set list, which isn't NULL,
	 *  and the last arg must be NULL indicating the end of the set list.
	 * @return {int}  -1 ʾһ key Ǽ϶
	 *  return the number of members, -1 if error happened or it's not
	 *  a set by the key.
	 */
	int sunion(std::vector<string>* members, const char* first_key, ...);
	int sunion(const std::vector<const char*>& keys,
		std::vector<string>* members);
	int sunion(const std::vector<string>& keys,
		std::vector<string>* members);

	/**
	 * ú SDIFF ƣ浽 dst ϣǼ򵥵طؽ
	 * This command is equal to SDIFF, but instead of returning
	 * the resulting set, it is stored in destination.
	 * @param dst {const char*} Ŀ꼯϶ֵ
	 *  the key of the destination set
	 * @param first_key {const char*} һǿյļ϶ֵ
	 *  the key of the first set in a variable set list, which isn't NULL,
	 *  and the last arg must be NULL indicating the end of the set list. 
	 * @return {int} еĳԱ
	 *  return the number of members, -1 if error happened or it's not
	 *  a set by the key.
	 */
	int sdiffstore(const char* dst, const char* first_key, ...);
	int sdiffstore(const char* dst, const std::vector<const char*>& keys);
	int sdiffstore(const char* dst, const std::vector<string>& keys);

	/**
	 *  SINTER 浽 dst ϣǼ򵥵طؽ
	 * This command is equal to SINTER, but instead of returning
	 * the resulting set, it is stored in destination.
	 * @param dst {const char*} Ŀ꼯϶ֵ
	 *  the key of the destination set
	 * @param first_key {const char*} һǿյļ϶ֵ
	 *  the key of the first set in a variable set list, which isn't NULL,
	 *  and the last arg must be NULL indicating the end of the set list.
	 * @return {int} еĳԱ
	 *  return the number of members, -1 if error happened or it's not
	 *  a set by the key.
	 */
	int sinterstore(const char* dst, const char* first_key, ...);
	int sinterstore(const char* dst, const std::vector<const char*>& keys);
	int sinterstore(const char* dst, const std::vector<string>& keys);

	/**
	 *  SUNION 浽 dst ϣǼ򵥵طؽ
	 * This command is equal to SUNION, but instead of returning
	 * the resulting set, it is stored in destination.
	 * @param dst {const char*} Ŀ꼯϶ֵ
	 *  the key of the destination set
	 * @param first_key {const char*} һǿյļ϶ֵ
	 *  the key of the first set in a variable set list, which isn't NULL,
	 *  and the last arg must be NULL indicating the end of the set list.
	 * @return {int} еĳԱ
	 *  return the number of members, -1 if error happened or it's not
	 *  a set by the key.
	 */
	int sunionstore(const char* dst, const char* first_key, ...);
	int sunionstore(const char* dst, const std::vector<const char*>& keys);
	int sunionstore(const char* dst, const std::vector<string>& keys);

	/**
	 * ж member ԪǷ񼯺 key ĳԱ
	 * determine if a given value is a member of a set
	 * @param key {const char*} ϶ļֵ
	 *  the key of a set
	 * @param member {const char*} ֵ
	 *  the given value
	 * @return {bool}  true ʾǣΪǻ key 
	 *  Ǽ϶
	 *  true if the given is a member of the set, false if it's not a
	 *  member of the set, or error, or it's not a set by the key.
	 */
	bool sismember(const char* key, const char* member);
	bool sismember(const char* key, const char* member, size_t len);

	/**
	 * ִʱֻṩ key ôؼеһԪأͬʱָ
	 * Ԫظ᷵һøƵĽ
	 * get one or multiple memebers from a set
	 * @param key {const char*} ϶ļֵ
	 *  the key of a set
	 * @param out 洢
	 *  store the result
	 * @return {int} ĸΪ -1 ʾ0 ʾûгԱ
	 *  the number of members, 0 if the set by the key is empty,
	 *  -1 if error happened.
	 */
	int srandmember(const char* key, string& out);
	int srandmember(const char* key, size_t n, std::vector<string>& out);

	/**
	 * Ƴ key еһ member Ԫأڵ member Ԫػᱻ
	 * Remove the specified members from the set stored at key. if the
	 * member doesn't exist, it will be ignored.
	 * @param key {const char*} ϶ļֵ
	 *  the key of the set
	 * @param first_member {const char*} ҪƳĳԱбĵһ NULLԱ
	 *  ڱεҪһд NULL
	 *  the first non-NULL member to be removed in a variable member list,
	 *  and the last one must be NULL indicating the end of the list.
	 * @retur {int} ƳĳԱԪصĸǼ϶ʱ -1 key 
	 *  ڻԱʱ 0
	 *  the number of members be removed, 0 if the set is empty or the
	 *  key doesn't exist, -1 if error happened or it's not a set by key
	 */
	int srem(const char* key, const char* first_member, ...);
	int srem(const char* key, const std::vector<string>& members);
	int srem(const char* key, const std::vector<const char*>& members);
	int srem(const char* key, const char* members[],
		size_t lens[], size_t argc);

	/**
	 * ڵǰݿеݿ
	 * scan the members in a set stored at key
	 * @param key {const char*} ϣֵ
	 *  the key of a set
	 * @param cursor {int} αֵʼʱֵд 0
	 *  the cursor value, which is 0 at begin
	 * @param out {std::vector<string>&} 洢ڲ׷ӷʽα
	 *  ӽУΪֹܽ¸ûڵñ
	 *  ǰ
	 *  store result in appending mode.
	 * @param pattern {const char*} ƥģʽglob 񣬷ǿʱЧ
	 *  match pattern, effective only on no-NULL
	 * @param count {const size_t*} ޶ĽǿָʱЧ
	 *  the max count of one scan process, effective only on no-NULL
	 * @return {int} һαλã£
	 *  return the next cursor position, as below:
	 *   0
	 *     scan finish
	 *  -1: 
	 *     some error happened
	 *  >0: αһλãʹжٽҪ outΪпΪ
	 *     the next cursor postion to scan
	 */
	int sscan(const char* key, int cursor, std::vector<string>& out,
		const char* pattern = NULL, const size_t* count = NULL);
};

} // namespace acl
