#ifndef	ACL_ACCESS_INCLUDE_H
#define	ACL_ACCESS_INCLUDE_H

#ifdef	__cplusplus
extern "C" {
#endif

#include "stdlib/acl_stdlib.h"

/**
 * бһ ip ַ
 * @param data  IP ַַ. : 10.0.0.1:10.0.250.1, 192.168.0.1:192.168.0.255
 * @param sep1 ÿ IP ַ֮ķָ, е "," ָ
 * @param sep2 ÿ IP ַθߵַ͵ַ֮ķָ, е ":" ָ
 * @return ӡ. 0: ɹ; < 0: ʧ
 * ע: ú̲߳ȫ
 */
ACL_API int acl_access_add(const char *data, const char *sep1, const char *sep2);

/**
 * ļжȡ IP ַַ, Զ IP ַб
 * @param xcp ѾɹļĽ
 * @param name xcp  IP ַصı
 * @return Ƿӳɹ. 0: ɹ; < 0: ʧ.
 * ע: ú̲߳ȫ
 */
ACL_API int acl_access_cfg(ACL_XINETD_CFG_PARSER *xcp, const char *name);

/**
 * ûԼ־¼, ô˺, 򱾿Զʹ aclMsg.cеĿ.
 * @param log_fn ûԼ־¼.
 * ע: ú̲߳ȫ
 */
ACL_API void acl_access_setup_logfn(void (*log_fn)(const char *fmt, ...));

/**
 * ж IP ַǷķ IP ַб.
 * @param ip ʽ: 192.168.0.1
 * @return Ƿķб, != 0: ; == 0: .
 */
ACL_API int acl_access_permit(const char *ip);

/**
 * ʵַӡ.
 */
ACL_API void acl_access_debug(void);

#ifdef	__cplusplus
}
#endif

#endif
