#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/db/db_pool.hpp"

namespace acl {

class db_handle;
class mysql_conf;

class ACL_CPP_API mysql_pool : public db_pool
{
public:
	/**
	 *  mysql ݿʱĹ캯
	 * @param dbaddr {const char*} mysql ַʽIP:PORT
	 *   UNIX ƽ̨¿Ϊ UNIX ׽ӿ
	 * @param dbname {const char*} ݿ
	 * @param dbuser {const char*} ݿû
	 * @param dbpass {const char*} ݿû
	 * @param dblimit {int} ݿӳص
	 * @param dbflags {unsigned long} mysql λ
	 * @param auto_commit {bool} ǷԶύ
	 * @param conn_timeout {int} ݿⳬʱʱ()
	 * @param rw_timeout {int} ݿͨʱIOʱ()
	 * @param charset {const char*} ݿַ(utf8, gbk, ...)
	 */
	mysql_pool(const char* dbaddr, const char* dbname,
		const char* dbuser, const char* dbpass,
		int dblimit = 64, unsigned long dbflags = 0,
		bool auto_commit = true, int conn_timeout = 60,
		int rw_timeout = 60, const char* charset = "utf8");

	/**
	 * 캯
	 * @param conf {const mysql_conf&} mysql ݿö
	 */
	mysql_pool(const mysql_conf& conf);
	~mysql_pool();

protected:
	//  connect_pool 麯ݿӾ
	connect_client* create_connect();

	//@override
	void set_charset(const char* charset);

private:
	mysql_conf* conf_;
};

} // namespace acl
