#pragma once

struct acl_pthread_pool_t;
struct acl_pthread_pool_attr_t;

namespace acl
{

class thread_job;

/**
 * ̳߳ع࣬ڹ̳߳е߳ǰפ(߳̿һʱ
 * Զ˳)Ǵ麯thread_on_init(̳߳еĳ̵߳һ
 * ʱȵô˺)thread_on_exit(̳߳еĳ߳˳ʱô˺)
 */
class ACL_CPP_API thread_pool
{
public:
	thread_pool();
	virtual ~thread_pool();

	/**
	 * ̳߳أڴ̳߳ض󣬱ȵô˺̳߳
	 */
	void start();

	/**
	 * ֹ̳ͣ߳أͷ̳߳Դô˺ʹ߳˳
	 * ͷűʵʵǶ̬ûӦͷʵ
	 * ڵñ̳߳ع̣µ start 
	 */
	void stop();

	/**
	 * ȴ̳߳еִ̳߳
	 */
	void wait();

	/**
	 * һ񽻸̳߳еһ߳ȥִУ̳߳е
	 * ִ̻߳ие run 
	 * @param job {thread_job*} ߳
	 * @return {bool} Ƿɹ
	 */
	bool run(thread_job* job);

	/**
	 * һ񽻸̳߳еһ߳ȥִУ̳߳е
	 * ִ̻߳ие run ú run ȫֻͬΪ
	 * ʹ JAVA ԱΪϤṩ˴˽ӿ
	 * @param job {thread_job*} ߳
	 * @return {bool} Ƿɹ
	 */
	bool execute(thread_job* job);

	/**
	 * ڵ start ǰô˺̵߳ĶջС
	 * @param size {size_t} ̶߳ջСֵΪ 0 δ
	 *  ô˺̶߳ջСΪϵͳĬֵ
	 * @return {thread&}
	 */
	thread_pool& set_stacksize(size_t size);

	/**
	 * ̸̳߳߳
	 * @param max {size_t} ߳ô˺ڲȱʡֵΪ 100
	 * @return {thread_pool&}
	 */
	thread_pool& set_limit(size_t max);

	/**
	 * ̳߳п̵߳ĳʱ˳ʱ
	 * @param ttl {int} гʱʱ()ô˺ڲȱʡΪ 0
	 * @return {thread_pool&}
	 */
	thread_pool& set_idle(int ttl);

	/**
	 * õǰ̵̳߳߳
	 * @return {int} ̵̳߳߳δͨ start
	 *  ̳߳ع̣ú -1
	 */
	int threads_count() const;

	/**
	 * õǰ̳߳δ
	 * @return {int} ̳߳ػδ(δ start)Ѿ򷵻 -1
	 */
	int task_qlen() const;

protected:
	/**
	 * ̳߳е̵߳һαʱ麯ã
	 * ûԼʵһЩʼ
	 * @return {bool} ʼǷɹ
	 */
	virtual bool thread_on_init() { return true; }

	/**
	 * ̳߳е߳˳ʱ麯ãû
	 * Լʵ һЩԴͷŹ
	 */
	virtual void thread_on_exit() {}

private:
	size_t stack_size_;
	size_t threads_limit_;
	int    thread_idle_;

	acl_pthread_pool_t* thr_pool_;
	acl_pthread_pool_attr_t* thr_attr_;

	static void thread_run(void* arg);
	static int  thread_init(void* arg);
	static void thread_exit(void* arg);
};

} // namespace acl
