#ifndef __BINHASH_H_INCLUDED_H__
#define __BINHASH_H_INCLUDED_H__

#ifdef  __cplusplus
extern "C" {
#endif

#include "private.h"

typedef struct BINHASH BINHASH;

/**
 * Structure of one hash table entry.
 */
#ifdef  PACK_STRUCT
#pragma pack(4)
#endif
typedef struct BINHASH_INFO {
	union {
		char *key;
		const char *c_key;
	} key;                      /**< lookup key */
	int     key_len;            /**< key length */
	char   *value;              /**< associated value */
	struct BINHASH_INFO *next;  /**< colliding entry */
	struct BINHASH_INFO *prev;  /**< colliding entry */
} BINHASH_INFO;
#ifdef  PACK_STRUCT
#pragma pack(0)
#endif

/**
 * һϣ
 * @param size {int} ϣĳʼС
 * @param flag {unsigned int}  ACL_MDT_IDX е flag ͬ
 * @return {BINHASH*} ´Ĺϣָ
 */
BINHASH *binhash_create(int size, unsigned int flag, int use_slice);

/**
 * ϣӶ
 * @param table {BINHASH*} ϣָ
 * @param key {const char*} ϣ
 * @param key_len {int} key ĳ
 * @param value {char*} ֵ
 * @return {BINHASH_INFO*} ´ĹϣĿָ
 */
BINHASH_INFO *binhash_enter(BINHASH *table, const char *key, int key_len, char *value);

/**
 * ӹϣиݼȡöӦĹϣĿ
 * @param table {BINHASH*} ϣָ
 * @param key {const char*} ϣ
 * @param key_len {int} key ĳ
 * @return {BINHASH_INFO*} ϣĿָ
 */
BINHASH_INFO *binhash_locate(BINHASH *table, const char *key, int key_len);

/**
 * ѯĳϣļֵ
 * @param table {BINHASH*} ϣָ
 * @param key {const char*} ϣ
 * @param key_len {int} key ĳ
 * @return {char*} ϣֵ
 */
char *binhash_find(BINHASH *table, const char *key, int key_len);

/**
 * ɾĳϣ
 * @param table {BINHASH*} ϣָ
 * @param key {const char*} ϣ
 * @param key_len {int} key ĳ
 * @param free_fn {void (*)(char*)} ͷŹϣֵĺָ룬Ϊڲͷżֵ
 */
void binhash_delete(BINHASH *table, const char *key, int key_len, void (*free_fn) (char *));

/**
 * ͷŹϣ
 * @param table {BINHASH*} ϣָ
 * @param free_fn {void (*)(char*)} Ϊգô˺ͷŹϣڵмֵ
 */
void binhash_free(BINHASH *table, void (*free_fn) (char *));

/**
 * ϣûĻصϣеļֵ
 * @param table {BINHASH*} ϣָ
 * @param walk_fn {void (*)(BINHASH_INFO*, char*)} ڱϣеÿԪʱĻص
 * @param arg {char*} ûݵĲΪ walk_fn д
 */
void binhash_walk(BINHASH *table, void (*walk_fn) (BINHASH_INFO *, char *), char *arg);

/**
 * гǰϣеԪб
 * @param table {BINHASH*} ϣָ
 * @return {BINHASH_INFO*} ϣԪɵBINHASH_INFO, 
 *  еһָΪ NULL
 */
BINHASH_INFO **binhash_list(BINHASH *table);

#ifdef  __cplusplus
}
#endif

#endif

