#ifndef ACL_RES_INCLUDE_H
#define ACL_RES_INCLUDE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdlib/acl_define.h"
#include "acl_netdb.h"
#include <time.h>

/**
 * DNSؽĴ洢ṹ
 */
typedef struct ACL_RES {
	char dns_ip[64];                /**< DNSIPַ */
	unsigned short dns_port;        /**< DNSPort */
	unsigned short cur_qid;         /**< ڲݰıʶ */
	time_t tm_spent;                /**< ѯʱķ() */
	int   errnum;
#define ACL_RES_ERR_SEND	-100    /**< д */
#define ACL_RES_ERR_READ	-101    /**<  */
#define ACL_RES_ERR_RTMO	-102    /**< ʱ */
#define ACL_RES_ERR_NULL	-103    /**< ս */
#define ACL_RES_ERR_CONN	-104    /**< TCPʽʱʧ */

	int transfer;                   /**< TCP/UDP ģʽ */
#define ACL_RES_USE_UDP		0       /**< UDP ģʽ */
#define ACL_RES_USE_TCP		1       /**< TCP ģʽ */

	int   conn_timeout;             /**< TCP ʱӳʱʱ, ĬΪ10 */
	int   rw_timeout;               /**< TCP/UDP IOʱʱ, ĬΪ10 */
} ACL_RES;

/**
 * һDNSѯ
 * @param dns_ip {const char*} DNSIPַ
 * @param dns_port {unsigned short} DNSPort
 * @return {ACL_RES*} ´Ĳѯ
 */
ACL_API ACL_RES *acl_res_new(const char *dns_ip, unsigned short dns_port);

/**
 * ͷһDNSѯ
 * @param res {ACL_RES*} DNSѯ
 */
ACL_API void acl_res_free(ACL_RES *res);

/**
 * ѯĳIPַ
 * @param res {ACL_RES*} DNSѯ
 * @param domain {const char*} Ҫѯ
 * @return {ACL_DNS_DB*} ѯĽ
 */
ACL_API ACL_DNS_DB *acl_res_lookup(ACL_RES *res, const char *domain);

/**
 * ݴŻòѯʧܵԭ
 * @param errnum {int} 
 * @return {const char*} Ϣ
 */
ACL_API const char *acl_res_strerror(int errnum);

/**
 * õǰѯĴϢ
 * @param res {ACL_RES*} DNSѯ
 * @return {const char*} Ϣ
 */
ACL_API const char *acl_res_errmsg(const ACL_RES *res);

#ifdef __cplusplus
}
#endif

#endif

