#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stream/socket_stream.hpp"
#include <vector>

struct SMTP_CLIENT;

namespace acl {

class istream;
class polarssl_conf;
class mail_message;

/**
 * SMTP ʼͿͻ࣬ʹôʼ֧֤ȹ
 */
class ACL_CPP_API smtp_client
{
public:
	/**
	 * 캯
	 * @param addr {const char*} SMTP ʼַʽIP:PORT
	 *   domain:port
	 * @param conn_timeout {int} ӷĳʱʱ(룩
	 * @param rw_timeout {int}  IO ʱʱ()
	 */
	smtp_client(const char* addr, int conn_timeout = 60,
		int rw_timeout = 60);
	~smtp_client();

	/**
	 * ñʼʼˣúȵ send_envelop
	 * ŷ⣬ email  message.get_email() ǿʱ÷ʼ
	 * ̣򣨼 email  message.get_email() Ϊ NULLֻ
	 * ŷ
	 * @param message {const mail_messsage&} ʼϢǰ
	 * @param email {const char*} ǿʱʹôļΪʼݷ
	 * @return {bool} Ƿɹ
	 *  ע email Ϊ NULL ͬʱ messsage.get_email() ҲΪ NULL
	 *      SMTP ŷⲿ֣ûҪã
	 *     data_begin-->write|format|vformat|send_file-->data_end
	 *     ʼ
	 */
	bool send(const mail_message& message, const char* email = NULL);

	/**
	 *  SMTP Ự׶νʼŷⲿݣӦõô˺ɹ
	 * Ҫ:
	 * 1data_beginʼʼָ
	 * 2write/format/vformat/send_fileʼ
	 * 3data_endʾʼ
	 * @param message {const mail_message&} ʼʼϢ
	 * @return {bool} Ƿɹ
	 *  ע open/auth_login/mail_from/rcpt_to ŷ̵
	 */
	bool send_envelope(const mail_message& message);

	/**
	 *  SSL ݴģʽ
	 * @param ssl_conf {polarssl_conf*} ǿʱָ SSL ģʽ
	 * @return {smtp_client&}
	 */
	smtp_client& set_ssl(polarssl_conf* ssl_conf);

	/**
	 * ϴ SMTP ̷˷ص״̬
	 * @return {int}
	 */
	int get_code() const;

	/**
	 * ϴ SMTP ̷˷ص״̬Ϣ
	 * @return {const char*}
	 */
	const char* get_status() const;

	/////////////////////////////////////////////////////////////////////

	/**
	 * ʼݣѭñݱϸʼʽ
	 * @param data {const char*} ʼ
	 * @param len {size_t} data ʼݳ
	 * @return {bool} Ƿɹ
	 *  עڵһεñǰ뱣֤ SMTP ŷѾɹ
	 */
	bool write(const char* data, size_t len);

	/**
	 * ʼݣѭñݱϸʼʽ
	 * @param fmt {const char*} θʽ
	 * @return {bool} Ƿɹ
	 *  עڵһεñǰ뱣֤ SMTP ŷѾɹ
	 */
	bool format(const char* fmt, ...);

	/**
	 * ʼݣѭñݱϸʼʽ
	 * @param fmt {const char*} θʽ
	 * @param ap {va_list}
	 * @return {bool} Ƿɹ
	 *  עڵһεñǰ뱣֤ SMTP ŷѾɹ
	 */
	bool vformat(const char* fmt, va_list ap);

	/////////////////////////////////////////////////////////////////////

	/**
	 * Զ SMTP 
	 * @return {bool} Ƿɹʹ SSL ʽҪ
	 *  ʼ set_ssl  SSL ͨŷʽ
	 */
	bool open();

	/**
	 * ر SMTP ˵
	 */
	void close();

	/**
	 * һӳɹҪñ SMTP ˵ĻӭϢ
	 * @return {bool} Ƿɹ
	 */
	bool get_banner();

	/**
	 *  get_banner ɹñ SMTP ˷ HELO/HELO 
	 * @return {bool} Ƿɹ
	 */
	bool greet();

	/**
	 *  gree ɹñ SMTP ˷֤
	 * @param user {const char*} û˺ţǿַ
	 * @param pass {const char*} û˺룬ǿַ
	 * @return {bool} Ƿɹ
	 */
	bool auth_login(const char* user, const char* pass);

	/**
	 *  auth_login ɹ֤ greet ɹ
	 * ñ SMTP  MAIL FROM 
	 * @param from {const char*} ˵ַ
	 * @return {bool} Ƿɹ
	 */
	bool mail_from(const char* from);

	/**
	 *  mail_from ɹñ SMTP ˷ RCPT TO 
	 * ָһռˣԶαʼռ
	 * @param to {const char*} ռַ
	 * @return {bool} Ƿɹ
	 */
	bool rcpt_to(const char* to);

	/**
	 *  rcpt_to  send_envelope ɹñ SMTP 
	 * DATA ʼʼ
	 * @return {bool} Ƿɹ
	 *  עڵñǰ뱣֤ SMTP ŷѾɹ
	 */
	bool data_begin();

	/**
	 *  data_begin ɹñ SMTP ˷һʼ
	 * Ҫʼ洢ڴϵ·
	 * @param filepath {const char*} ʼļ·
	 * @return {bool} Ƿɹ
	 *  עڵñǰ뱣֤ SMTP ŷѾɹ
	 */
	bool send_email(const char* filepath);

	/**
	 * ʼϣãsend_emailñ SMTP
	 * ʼݽ
	 * @return {bool} Ƿɹ
	 */
	bool data_end();

	/**
	 * Ͽʼ
	 * @return {bool} Ƿɹ
	 */
	bool quit();

	/**
	 * NOOP 
	 * @return {bool} Ƿɹ
	 */
	bool noop();

	/**
	 * ʼ״̬
	 * @return {bool} Ƿɹ
	 */
	bool reset();

	/**
	 *  SMTP ֮󣬸úֻе open ɹſɵ
	 * @return {socket_stream&}
	 */
	socket_stream& get_stream(void)
	{
		return stream_;
	}

private:
	polarssl_conf* ssl_conf_;
	char* addr_;
	int   conn_timeout_;
	int   rw_timeout_;
	SMTP_CLIENT* client_;
	socket_stream stream_;
	bool  ehlo_;
	bool  reuse_;

	bool to_recipients(const std::vector<rfc822_addr*>& recipients);
};

} // namespace acl
