#pragma once
#include "acl_cpp/acl_cpp_define.hpp"

namespace acl {

class socket_stream;

/**
 * ˼׽ӿ࣬տͻӣͻӶ
 */
class ACL_CPP_API server_socket
{
public:
	/**
	 * 캯
	 * @param backlog {int} ׽ӿڶг
	 * @param block {bool} ģʽǷģʽ
	 */
	server_socket(int backlog = 128, bool block = true);
	~server_socket();

	/**
	 * ʼ˵ַ
	 * @param addr {const char*} ַʽΪ
	 *  ip:port unix £׽ӿڣʽΪ
	 *   /path/xxx
	 * @return {bool} Ƿɹ
	 */
	bool open(const char* addr);

	/**
	 * رѾ򿪵ļ׽ӿ
	 * @return {bool} Ƿر
	 */
	bool close();

	/**
	 * տͻӲͻ
	 * @param timeout {int} ģʽ£ֵ > 0 ʱóʱ
	 *  ʽտͻӣָʱδÿͻӣ򷵻 NULL
	 * @return {socket_stream*} ؿձʾʧ
	 */
	socket_stream* accept(int timeout = 0);

	/**
	 * üĵַ
	 * @return {const char*} ֵǿָ
	 */
	const char* get_addr() const
	{
		return addr_;
	}

	/**
	 * ַñԻü׽ӿ
	 * @return {int}
	 */
#if defined(_WIN32) || defined(_WIN64)
	SOCKET sock_handle() const
#else
	int sock_handle() const
#endif
	{
		return fd_;
	}

	/**
	 * ü׽ֵӳٽչܣͻʱŽӷ
	 * ӦãĿǰù֧ܽ Linux
	 * @param timeout {int} ͻڹ涨ʱδݣ
	 *  ҲӷظӦ
	 */
	void set_tcp_defer_accept(int timeout);

private:
	int   backlog_;
	bool  block_;
	bool  unix_sock_;
	char  addr_[64];

#if defined(_WIN32) || defined(_WIN64)
	SOCKET fd_;
#else
	int   fd_;
#endif
};

} // namespace acl
