
#ifndef _DEBUG_HTABLE_H_INCLUDED_
#define _DEBUG_HTABLE_H_INCLUDED_

#ifdef  __cplusplus
extern "C" {
#endif

#include "stdlib/acl_define.h"

/*--------------------------------------------------------------------------*/

/* Structure of one hash table entry. */

/**
 * ϣͶ
 * @param buffer Ҫϣַ
 * @param len s ĳ
 */
typedef unsigned (*DEBUG_HASH_FN)(const void *buffer, size_t len);

/**
 * ϣṹ, Ͷ htable.c Ϊ˱ڲԱ
 */
typedef struct DEBUG_HTABLE	DEBUG_HTABLE;

/* ϣÿһϣĴ洢Ϣ */
typedef struct DEBUG_HTABLE_INFO {
	char   *key;			/* lookup key */
	char   *value;			/* associated value */
	struct DEBUG_HTABLE_INFO *next;	/* colliding entry */
	struct DEBUG_HTABLE_INFO *prev;	/* colliding entry */
} DEBUG_HTABLE_INFO;

/**
 * ϣ
 * @param size ϣ
 * @return ϣͷָΪ(ʱʾصĴ, Ҫڴ)
 */
DEBUG_HTABLE *debug_htable_create(int size);

/**
 * ϣµ
 * @param table ϣָ
 * @param key , ںڲḴƴ key 
 * @param value ûԼض(Ӳת, Ǵ벻ܶջ)
 * @return Ĺϣָ, == NULL: ʾڲַڴ, ΪصĴ
 */
DEBUG_HTABLE_INFO *debug_htable_enter(DEBUG_HTABLE *table, const char *key, char *value);

/**
 *  key Ѱĳһضϣ
 * @param table ϣָ
 * @param key 
 * @return Ϊָ: ʾ鵽˶Ӧ key Ĺϣ
 *         Ϊ: ʾδ鵽Ӧ key Ĺϣ
 */
DEBUG_HTABLE_INFO *debug_htable_locate(DEBUG_HTABLE *table, const char *key);

/**
 *  key Ѱû
 * @param table ϣָ
 * @param key 
 * @return Ϊ: ʾ鵽˶Ӧ key , ûԸûԼͽת
 *         Ϊ: ʾδ鵽Ӧ key 
 */
char *debug_htable_find(DEBUG_HTABLE *table, const char *key);

/**
 * :		 key ɾĳһϣ
 * @param table ϣָ
 * @param key 
 * @param free_fn úָ벻Ϊղҵ˶Ӧ key , ȵû
 *        ṩһЩβ, ȻͷŸùϣ
 * @return 0: ɹ;  -1: δҵ key 
 */
int debug_htable_delete(DEBUG_HTABLE *table, const char *key, void (*free_fn) (char *));

/**
 * ͷϣ
 * @param table ϣָ
 * @param free_fn ָ벻ΪԹϣеÿһϣøúβ, Ȼͷ
 */
void debug_htable_free(DEBUG_HTABLE *table, void (*free_fn) (char *));

/**
 * ùϣ, úͷŹϣе, ³ʼ
 * @param table ϣָ
 * @param free_fn ָ벻ΪԹϣеÿһϣøúβ, Ȼͷ
 * @return Ƿóɹ. 0: OK; < 0: error.
 */
int debug_htable_reset(DEBUG_HTABLE *table, void (*free_fn) (char *));

/**
 * Թϣеÿһϣд
 * @param table ϣָ
 * @param walk_fn ÿһϣĺָ, Ϊ
 * @param arg ûԼ͵
 */
void debug_htable_walk(DEBUG_HTABLE *table, void (*walk_fn) (DEBUG_HTABLE_INFO *, char *), char *arg);

/**
 * ϣϳһ
 * @param table ϣ
 * @return Ϊ: ָ; Ϊ: ʾùϣûйϣ
 */
DEBUG_HTABLE_INFO **debug_htable_list(const DEBUG_HTABLE *table);

#ifdef  __cplusplus
}
#endif

#endif

