#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <map>
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/connpool/connect_manager.hpp"

namespace acl {

class mysql_conf;

class ACL_CPP_API mysql_manager : public connect_manager
{
public:
	mysql_manager(time_t idle_ttl = 120);
	~mysql_manager();

	/**
	 * һݿʵһ
	 * @param dbaddr {const char*} mysql ַʽIP:PORT
	 *   UNIX ƽ̨¿Ϊ UNIX ׽ӿ
	 * @param dbname {const char*} ݿ
	 * @param dbuser {const char*} ݿû
	 * @param dbpass {const char*} ݿû
	 * @param dblimit {size_t} ݿӳص
	 * @param dbflags {unsigned long} mysql λ
	 * @param auto_commit {bool} ǷԶύ
	 * @param conn_timeout {int} ݿⳬʱʱ()
	 * @param rw_timeout {int} ݿͨʱIOʱ()
	 * @param charset {const char*} ݿʱַ
	 * @return {mysql_manager&}
	 */
	mysql_manager& add(const char* dbaddr, const char* dbname,
		const char* dbuser, const char* dbpass,
		size_t dblimit = 64, unsigned long dbflags = 0,
		bool auto_commit = true, int conn_timeout = 60,
		int rw_timeout = 60, const char* charset = "utf8");

	/**
	 * һݿʵ
	 * @param conf {const mysql_conf&}
	 * @return {mysql_manager&}
	 */
	mysql_manager& add(const mysql_conf& conf);

protected:
	/**
	 *  connect_manager 麯ʵ
	 * @param addr {const char*} ַʽip:port
	 * @param count {size_t} ӳصĴСƣֵΪ 0 ʱû
	 * @param idx {size_t} ӳضڼе±λ( 0 ʼ)
	 * @return {connect_pool*} شӳض
	 */
	connect_pool* create_pool(const char* addr, size_t count, size_t idx);

private:
	time_t idle_ttl_;       // ݿӵĿйʱ
	std::map<string, mysql_conf*> dbs_;
};

} // namespace acl
