#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/master/master_conf.hpp"

struct ACL_EVENT;

namespace acl
{

class event_timer;

class ACL_CPP_API master_base
{
public:
	/**
	 *  bool ͵
	 * @param table {master_bool_tbl*}
	 */
	void set_cfg_bool(master_bool_tbl* table);

	/**
	 *  int ͵
	 * @param table {master_int_tbl*}
	 */
	void set_cfg_int(master_int_tbl* table);

	/**
	 *  int64 ͵
	 * @param table {master_int64_tbl*}
	 */
	void set_cfg_int64(master_int64_tbl* table);

	/**
	 *  ַ ͵
	 * @param table {master_str_tbl*}
	 */
	void set_cfg_str(master_str_tbl* table);

	/**
	 * жǷ acl_master Ƶ daemon ģʽ
	 * @return {bool}
	 */
	bool daemon_mode(void) const;

	/////////////////////////////////////////////////////////////////////
	
	/**
	 * ý̼Ķʱú̵ֻ߳пռ (ں
	 * proc_on_init) бãöʱִϺԶ
	 * (ڲԶ master_timer::destroy )
	 * @param timer {event_timer*} ʱ
	 * @return {bool} öʱǷɹ
	 */
	bool proc_set_timer(event_timer* timer);

	/**
	 * ɾ̼ʱ
	 * @param timer {event_timer*}  proc_set_timer õĶʱ
	 */
	void proc_del_timer(event_timer* timer);

protected:
	bool daemon_mode_;
	bool proc_inited_;

	master_base();
	virtual ~master_base();

	/**
	 * лûǰõĻصڴ˺һЩ
	 * ûΪ root Ȩ޲
	 */
	virtual void proc_pre_jail() {}

	/**
	 * лûݺõĻص˺ʱ
	 * ȨΪͨ޼
	 */
	virtual void proc_on_init() {}

	/**
	 * ˳ǰõĻص
	 */
	virtual void proc_on_exit() {}

	// ö
	master_conf conf_;

protected:
	// ñ¼
	void set_event(ACL_EVENT* event);

	/**
	 * ¼湻
	 * @return {ACL_EVENT*}
	 */
	ACL_EVENT* get_event(void) const
	{
		return event_;
	}

private:
	ACL_EVENT* event_;
};

}  // namespace acl
