#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>
#include "acl_cpp/http/http_header.hpp"
#include "acl_cpp/connpool/connect_client.hpp"

namespace acl {

class http_client;
class http_pipe;
class socket_stream;
class charset_conv;
class polarssl_conf;
class xml;
class json;

/**
 * HTTP ͻֳ֧࣬ӣͬʱӶʱԶ
 */
class ACL_CPP_API http_request : public connect_client
{
public:
	/**
	 * 캯ͨù캯 socket_stream 
	 * ᱻرգҪԼر
	 * @param client {socket_stream*} ǿգ
	 *  ڱʱ󲢲ᱻ٣ûͷ
	 * @param conn_timeout {int} رգڲ
	 *  ԶԣʱҪֵʾӷĳʱʱ()
	 *   IO дʱʱǴ м̳е
	 * @param unzip {bool} ǷԷӦԶнѹ
	 * עʵʹʱûӦÿεǰ
	 * request_header::http_header::reset()
	 */
	http_request(socket_stream* client, int conn_timeout = 60,
		bool unzip = true);

	/**
	 * 캯ù캯ڲ socket_stream йر
	 * @param addr {const char*} WEB ַ
	 * @param conn_timeout {int} Զӷʱʱ()
	 * @param rw_timeout {int} IO дʱʱ()
	 * @param unzip {bool} ǷԷӦԶнѹ
	 */
	http_request(const char* addr, int conn_timeout = 60,
		int rw_timeout = 60, bool unzip = true);

	virtual ~http_request(void);

	/**
	 * ڶȡӦʱǷѹݽнѹ
	 * @param on {bool}
	 * @return {http_request&}
	 */
	http_request& set_unzip(bool on);

	/**
	 * ÿͻ SSL ͨŷʽڲȱʡΪ SSL ͨŷʽ
	 * @param conf {polarssl_conf*} ͻ SSL ö
	 * @return {http_request&}
	 */
	http_request& set_ssl(polarssl_conf* conf);

	/**
	 *  HTTP ͷȻڷص HTTP ͷ
	 * Լͷֶλ http_header::reset()ͷ״̬
	 * οhttp_header 
	 * @return {http_header&}
	 */
	http_header& request_header(void);

	/**
	 * ñַַǿʱ߽ݱַ߽ת
	 * @param local_charset {const char*} ַ
	 * @return {http_header&}
	 */
	http_request& set_local_charset(const char* local_charset);

	/**
	 *  HTTP  HTTP ͷ HTTP 壬ͬʱ
	 * HTTP ȡ HTTP Ӧͷڳӣжʱ
	 * һΣڵļ get_body ǰ
	 * ñ( write_head/write_body)
	 * £úڷݺ HTTP Ӧͷ
	 * ûڱ true Եãget_body() 
	 * http_request::get_clinet()->read_body(char*, size_t)
	 *  HTTP Ӧ
	 * @param data {const void*} ͵ַǿʱԶ
	 *  POST ͣ GET 
	 * @param len {size_} data ǿʱָ data ݳ
	 * @return {bool} ݼ HTTP ӦͷǷɹ
	 */
	bool request(const void* data, size_t len);

	/**
	 * ʽдʱҪȵñ HTTP ͷ
	 * @return {bool} ǷɹɹſԼ write_body
	 */
	bool write_head();

	/**
	 * ʽдʱڵ write_head 󣬿ѭñ
	 *  HTTP ݣΪֵʱʾдꣻ
	 * ݺ󣬸úڲԶȡ HTTP Ӧͷݣû
	 *  get_body/read_body ȡ HTTP Ӧ
	 * @param data {const void*} ݵַָ룬ֵΪָʱʾ
	 *  ݷ
	 * @param len {size_t} data ǿָʱʾݳ
	 * @return {bool} Ƿɹ
	 *  עӦ÷ݺ󣬱ٵһαͬʱ
	 */
	bool write_body(const void* data, size_t len);

	/////////////////////////////////////////////////////////////////////

	/**
	 * ݺڲԶö HTTP Ӧͷ̣ͨ˺÷
	 * Ӧ HTTP ״̬(2xx, 3xx, 4xx, 5xx)
	 * ʵúڲֻǵ http_client::response_status 
	 * @return {int}
	 */
	int http_status() const;

	/**
	 *  HTTP Ӧ峤
	 * @return {int64) ֵΪ -1  HTTP ͷڻûгֶ
	 */
#if defined(_WIN32) || defined(_WIN64)
	__int64 body_length(void) const;
#else
	long long int body_length(void) const;
#endif
	/**
	 * HTTP (ӦǷֳ)
	 * @return {bool}
	 */
	bool keep_alive(void) const;

	/**
	 *  HTTP Ӧͷĳֵֶֶ
	 * @param name {const char*} ֶ
	 * @return {const char*} ֵֶΪʱʾ
	 */
	const char* header_value(const char* name) const;

	/**
	 * Ƿ
	 * @return {bool}
	 */
	bool body_finish() const;

	/**
	 *  request ɹñȡӦ
	 * 洢ڹ涨 xml 
	 * @param out {xml&} HTTP Ӧݴ洢ڸ xml 
	 * @param to_charset {const char*} ǿգڲԶ
	 *  תɸַ洢 xml 
	 * @return {bool} Ƿɹ
	 * עӦرʱӦô˺ڴĹ
	 */
	bool get_body(xml& out, const char* to_charset = NULL);

	/**
	 *  request ɹñȡӦ
	 * 洢ڹ涨 json 
	 * @param out {json&} HTTP Ӧݴ洢ڸ json 
	 * @param to_charset {const char*} ǿգڲԶ
	 *  תɸַ洢 json 
	 * @return {bool} Ƿɹ
	 * עӦرʱӦô˺ڴĹ
	 */
	bool get_body(json& out, const char* to_charset = NULL);

	/*
	 *  request ɹñȡȫӦ
	 * 洢Ļ
	 * @param out {string&} 洢Ӧ
	 * @param to_charset {const char*} ǿգڲԶ
	 *  תɸַ洢 out 
	 * עӦرʱӦô˺ڴĹ
	 */
	bool get_body(string& out, const char* to_charset = NULL);

	/*
	 *  request ɹñȡӦݲ
	 * 洢ĻУѭñֱݶˣ
	 * @param buf {char*} 洢Ӧ
	 * @param size {size_t} buf С
	 * @return {int} ֵ == 0 ʾϣ< 0 ʾ
	 *  رӣ> 0 ʾѾݣûӦһֱֱ
	 *  ֵ <= 0 Ϊֹ
	 *  עúԭʼ HTTP ݣѹַ
	 *  룬ûԼҪд
	 */
	int read_body(char* buf, size_t size);

	/**
	 *  request ɹñ HTTP Ӧ壬ѭ
	 * ڲԶѹݽнѹڵñ֮ǰ
	 * set_charset ˱ַͬʱݽַת
	 * @param out {string&} 洢
	 * @param clean {bool} ÿεñʱǷҪԶ out
	 *  
	 * @param real_size {int*} ָǿʱ洢ѹǰ
	 *  ȣڹ캯ָ˷ԶѹģʽҶ > 0
	 *  ֵ洢ĳֵӦ뱾ֵͬδκʱ
	 *  ֵ洢ĳֵΪ 0
	 * @return {int} == 0 ʾϣӲδرգ>0 ʾζ
	 *  ݳ(ΪѹʱʾΪѹ֮ݳȣ
	 *  ʵݲͬʵݳӦͨ real_size 
	 *  ); < 0 ʾرգʱ real_size ǿգ real_size 
	 *  ֵӦΪ 0
	 *   0 ʱɵ body_finish жǷ
	 */
	int read_body(string& out, bool clean = false, int* real_size = NULL);

	/**
	 *  request ɹñ HTTP ˶һݣѭ
	 * ֱ false  body_finish()  true Ϊֹ
	 * ڲԶѹݽѹڵñ֮ǰ set_charset 
	 * ַͬʱݽַת
	 * @param out {string&} 洢
	 * @param nonl {bool} һǷԶȥβ "\r\n"  "\n"
	 * @param size {size_t*} ָǿʱŶݳ
	 * @return {bool} Ƿһݣ true ʱʾһݣ
	 *  ͨ body_finish() ǷΪ true жǷѾ
	 *  һ  nonl = true ʱ *size = 0 false ʱ
	 *  ʾδҶϣ
	 *  *size дŶݳ
	 */
	bool body_gets(string& out, bool nonl = true, size_t* size = NULL);

	/**
	 * ͨ http_request::request_header().set_range() 
	 * range ʱ˺صǷ֧ range
	 * @return {bool}
	 */
	bool support_range(void) const;

#if defined(_WIN32) || defined(_WIN64)
	/**
	 *  http_request::request_header().set_range() Ҷȡ
	 * صͷ󣬴˺ֶַ֧ιܵʼƫλ
	 * @return {acl_int64} ֧ range ʽ򷵻ֵ < 0
	 */
	__int64 get_range_from(void) const;

	/**
	 *  http_request::request_header().set_range() Ҷȡ
	 * صͷ󣬴˺ֶַ֧ιܽƫλ
	 * @return {acl_int64} ֧ range ʽ򷵻ֵ < 0
	 */
	__int64 get_range_to(void) const;

	/**
	 *  http_request::request_header().set_range() Ҷȡ
	 * صͷ󣬴˺ֶַ֧ιܵСֵ
	 *  HTTP ӦС
	 * @return {acl_int64} ֧ range ʽ򷵻ֵ < 0
	 */
	__int64 get_range_max(void) const;
#else
	long long int get_range_from(void) const;
	long long int get_range_to(void) const;
	long long int get_range_max(void) const;
#endif

	/**
	 * ÷ص Set-Cookie ļ
	 * @return {const std::vector<HttpCookie*>*} ؿձʾ
	 *  û cookie Ϊ
	 */
	const std::vector<HttpCookie*>* get_cookies(void) const;

	/**
	 * ÷ص Set-Cookie õĳ cookie 
	 * @param name {const char*} cookie 
	 * @param case_insensitive {bool} ǷִСдtrue ʾ
	 *  ִСд
	 * @return {const HttpCookie*}  NULL ʾ
	 */
	const HttpCookie* get_cookie(const char* name,
		bool case_insensitive = true) const;

	/////////////////////////////////////////////////////////////////////

	/**
	 *  http_client HTTP ͨصĶ
	 * Ӧͷݣοhttp_client 
	 * @return {http_client*} ؿʱʾ
	 */
	http_client* get_client(void) const;

	/**
	 * ״̬ͬһӵĶʱô˺
	 */
	void reset(void);

protected:
	/**
	 *  connect_client 麯ʽñ˵
	 * @return {bool} Ƿɹ
	 */
	virtual bool open();

private:
	char addr_[64];
	bool unzip_;
	polarssl_conf* ssl_conf_;
	char local_charset_[64];
	charset_conv* conv_;
        http_client* client_;
	http_header  header_;
	bool cookie_inited_;
	std::vector<HttpCookie*>* cookies_;
#if defined(_WIN32) || defined(_WIN64)
	__int64 range_from_;
	__int64 range_to_;
	__int64 range_max_;
#else
	long long int range_from_;
	long long int range_to_;
	long long int range_max_;
#endif
	// д HTTP ʱñ־λʶǷԹ
	bool need_retry_;

	bool send_request(const void* data, size_t len);
	bool try_open(bool* reuse_conn);
	void close(void);
	void create_cookies(void);
	http_pipe* get_pipe(const char* to_charset);
	void set_charset_conv();
	void check_range(void);
};

} // namespace acl
