#include <iostream>
#include <assert.h>
#include "lib_acl.h"
#include "acl_cpp/stdlib/util.hpp"
#include "acl_cpp/stdlib/snprintf.hpp"
#include "acl_cpp/acl_cpp_init.hpp"
#include "acl_cpp/stdlib/log.hpp"
#include "acl_cpp/stream/polarssl_conf.hpp"
#include "acl_cpp/stream/polarssl_io.hpp"
#include "acl_cpp/stream/aio_handle.hpp"
#include "acl_cpp/stream/aio_istream.hpp"
#include "acl_cpp/stream/aio_listen_stream.hpp"
#include "acl_cpp/stream/aio_socket_stream.hpp"

static int   __max = 0;
static int   __timeout = 0;
static int   __max_used = 0;
static int   __cur_used = 0;

// SSL ģʽµ SSL ö
static acl::polarssl_conf* __ssl_conf;

/**
 * 첽ͻĻص
 */
class io_callback : public acl::aio_callback
{
public:
	io_callback(acl::aio_socket_stream* client)
		: client_(client)
		, nread_cnt_(0)
		, nread_(0)
	{
	}

	~io_callback()
	{
		printf("delete io_callback now ...\r\n");
		__cur_used++;
	}

	/**
	 * ص麯ûص aio_istream ʵе
	 * gets/read Ŀɶ󱻵ã첽ڲ
	 * ݶֱӴݸû
	 * @param data {char*} ݵַָ
	 * @param len {int} ݳ(> 0)
	 * @return {bool} ú false ֪ͨ첽رո첽
	 */
	bool read_wakeup()
	{
		acl::polarssl_io* hook = (acl::polarssl_io*) client_->get_hook();
		if (hook == NULL)
		{
			//  SSL ģʽ첽ȡ
			//client_->read(__timeout);
			client_->gets(__timeout, false);
			return true;
		}

		// Խ SSL 
		if (hook->handshake() == false)
		{
			printf("ssl handshake failed\r\n");
			return false;
		}

		//  SSL Ѿɹʼж
		if (hook->handshake_ok())
		{
			//  reactor ģʽתΪ proactor ģʽӶȡ
			// read_wakeup ص
			client_->disable_read();

			// 첽ȡݣص read_callback
			//client_->read(__timeout);
			client_->gets(__timeout, false);
			return true;
		}

		// SSL ֻδɣȴٴα
		return true;
	}

	/**
	 * ʵָе麯ͻĶɹص
	 * @param data {char*} ݵַ
	 * @param len {int} ݳ
	 * @return {bool}  true ʾϣرո첽
	 */
	bool read_callback(char* data, int len)
	{
		nread_cnt_++;
		nread_ += len;

		if (nread_cnt_ <= 100 || nread_cnt_ % 1000 == 0)
		{
			char  buf[256];
			acl::safe_snprintf(buf, sizeof(buf),
				"read len: %d, total read: %d, nread_cnt: %d",
				len, nread_, nread_cnt_);
			acl::meter_time(__FILE__, __LINE__, buf);
		}

		// Զ̿ͻϣ˳ر֮
		if (strncasecmp(data, "quit", 4) == 0)
		{
			client_->format("Bye!\r\n");
			client_->close();
			return true;
		}

		// Զ̿ͻϣҲرգֹ첽¼
		if (strncasecmp(data, "stop", 4) == 0)
		{
			client_->format("Stop now!\r\n");
			client_->close();  // رԶ첽

			// ֪ͨ첽رѭ
			client_->get_handle().stop();
		}

		// Զ̿ͻ˻дյ

		client_->write(data, len);
		return true;
	}

	/**
	 * ʵָе麯ͻдɹص
	 * @return {bool}  true ʾϣرո첽
	 */
	bool write_callback()
	{
		return true;
	}

	/**
	 * ʵָе麯ͻĳʱص
	 */
	void close_callback()
	{
		// ڴ˴ɾö̬ĻصԷֹڴй¶
		delete this;
	}

	/**
	 * ʵָе麯ͻĳʱص
	 * @return {bool}  true ʾϣرո첽
	 */
	bool timeout_callback()
	{
		std::cout << "Timeout, delete it ..." << std::endl;
		return false;
	}

private:
	acl::aio_socket_stream* client_;
	int   nread_cnt_;
	int   nread_;
};

/**
 * 첽Ļص
 */
class io_accept_callback : public acl::aio_accept_callback
{
public:
	io_accept_callback() {}
	~io_accept_callback()
	{
		printf(">>io_accept_callback over!\n");
	}

	/**
	 * 麯ӵô˻ص
	 * @param client {aio_socket_stream*} 첽ͻ
	 * @return {bool}  true ֪ͨ
	 */
	bool accept_callback(acl::aio_socket_stream* client)
	{
		//acl_non_blocking(client->sock_handle(), ACL_BLOCKING);

		// 첽ͻĻص첽а
		io_callback* callback = new io_callback(client);

		// ע첽Ķص
		client->add_read_callback(callback);

		// ע첽дص
		client->add_write_callback(callback);

		// ע첽Ĺرջص
		client->add_close_callback(callback);

		// ע첽ĳʱص
		client->add_timeout_callback(callback);

		// ޶󳤶ʱ
		if (__max > 0)
			client->set_buf_max(__max);

		// SSL ģʽ£ȴͻ˷Ϣ
		if (__ssl_conf != NULL)
		{
			// ע SSL IO ̵Ĺ
			acl::polarssl_io* ssl = new
				acl::polarssl_io(*__ssl_conf, true, true);

			if (client->setup_hook(ssl) == ssl)
			{
				std::cout << "setup_hook error" << std::endl;
				ssl->destroy();
				return false;
			}

			// ͻڶ״̬Դ read_wakeup ص̣
			// SSL ֹ̽ read_wakeup 
			client->read_wait(__timeout);
		}

		//  SSL ģʽ£첽һ
		else
		{
			//client->read(__timeout);
			client->gets(__timeout, false);
		}

		return true;
	}
};

static void usage(const char* procname)
{
	printf("usage: %s -h[help]\r\n"
		"	-l server_addr[ip:port, default: 127.0.0.1:9800]\r\n"
		"	-L line_max_length\r\n"
		"	-t timeout\r\n"
		"	-n conn_used_limit\r\n"
		"	-k[use kernel event: epoll/iocp/kqueue/devpool]\r\n"
		"	-M delay_ms\r\n"
		"	-I check_fds_inter\r\n"
		"	-K ssl_key_file -C ssl_cert_file [in SSL mode]\r\n",
		procname);
}

int main(int argc, char* argv[])
{
	// ¼ǷںеĸЧģʽ
	bool use_kernel = false;
	acl::string key_file, cert_file;
	acl::string addr("127.0.0.1:9800");
	int  ch, delay_ms = 100, check_fds_inter = 10;

	while ((ch = getopt(argc, argv, "l:hkL:t:K:C:n:M:I:")) > 0)
	{
		switch (ch)
		{
		case 'h':
			usage(argv[0]);
			return 0;
		case 'l':
			addr = optarg;
			break;
		case 'k':
			use_kernel = true;
			break;
		case 'L':
			__max = atoi(optarg);
			break;
		case 't':
			__timeout = atoi(optarg);
			break;
		case 'K':
			key_file = optarg;
			break;
		case 'C':
			cert_file = optarg;
			break;
		case 'n':
			__max_used = atoi(optarg);
			break;
		case 'M':
			delay_ms = atoi(optarg);
			break;
		case 'I':
			check_fds_inter = atoi(optarg);
			break;
		default:
			break;
		}
	}

	acl::log::stdout_open(true);

	// ˽Կ֤鶼ʱŲ SSL ͨŷʽ
	if (!key_file.empty() && !cert_file.empty())
	{
		__ssl_conf = new acl::polarssl_conf();

		// ˵ SSL Ự湦
		__ssl_conf->enable_cache(true);

		// ӱط֤
		if (__ssl_conf->add_cert(cert_file.c_str()) == false)
		{
			delete __ssl_conf;
			__ssl_conf = NULL;
			std::cout << "add_cert error: " << cert_file.c_str()
				<< std::endl;
		}

		// ӱطԿ
		else if (__ssl_conf->set_key(key_file.c_str()) == false)
		{
			delete __ssl_conf;
			__ssl_conf = NULL;
			std::cout << "set_key error: " << key_file.c_str()
				<< std::endl;
		}
		else
			std::cout << "Load cert&key OK!" << std::endl;
	}

	// 첽
	acl::aio_handle handle(use_kernel ? acl::ENGINE_KERNEL : acl::ENGINE_SELECT);

	handle.set_check_inter(check_fds_inter);

	int delay_sec = delay_ms / 1000;
	int delay_usec = (delay_ms - delay_sec * 1000) * 1000;
	handle.set_delay_sec(delay_sec);
	handle.set_delay_usec(delay_usec);

	// 첽
	acl::aio_listen_stream* sstream = new acl::aio_listen_stream(&handle);

	// ʼACL(WIN32һҪô˺UNIXƽ̨¿ɲ)
	acl::acl_cpp_init();

	// ָĵַ
	if (sstream->open(addr.c_str()) == false)
	{
		std::cout << "open " << addr.c_str() << " error!" << std::endl;
		sstream->close();
		// XXX: Ϊ˱֤ܹرռӦڴ˴ check һ
		handle.check();

		getchar();
		return 1;
	}

	// ص󣬵ӵʱԶôĻص
	io_accept_callback callback;
	sstream->add_accept_callback(&callback);
	std::cout << "Listen: " << addr.c_str() << " ok!" << std::endl;

	while (true)
	{
		//  false ʾټҪ˳
		if (handle.check() == false)
		{
			std::cout << "aio_server stop now ..." << std::endl;
			break;
		}

		if (__max_used > 0 && __cur_used >= __max_used)
			break;
	}

	// رռͷ
	sstream->close();

	// XXX: Ϊ˱֤ܹرռӦڴ˴ check һ
	handle.check();

	// ɾ acl::polarssl_conf ̬
	delete __ssl_conf;

	return 0;
}
