#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <stdlib.h>
#include <map>
#include "acl_cpp/stdlib/string.hpp"

struct MIME_NODE;

namespace acl {

class pipe_manager;
class ostream;
class ifstream;

class ACL_CPP_API mime_node
{
public:
	/**
	 * 캯
	 * @param emailFile {const char*} 洢ʼݵԴļ
	 *  ΪգΪʱڵ save_body ʱָԴļ
	 * @param node {const MIME_NODE*} ʼеĳ
	 * @param enableDecode {bool} ʼΪ base64/qp ȱʽ
	 *  ʱǷҪԶн
	 * @param toCharset {const char*} ȱʡĿַĿ
	 *  ַԴַַͬת
	 * @param off {off_t} ʼеʼλиӵ
	 *  ƫԱûʼǰԼ˽
	 */
	mime_node(const char* emailFile, const MIME_NODE* node,
		bool enableDecode = true, const char* toCharset = "gb2312",
		off_t off = 0);
	virtual ~mime_node();

	/**
	 *  MIME  Content-Type ֵе name ֵֶ
	 * @return {const char*} Ϊʾûиֵֶ
	 */
	const char* get_name() const
	{
		if (m_name.empty())
			return (NULL);
		return (m_name.c_str());
	}

	/**
	 *  Content-Type еͣ: Content-Type: image/jpeg, 
	 *  MIME_CTYPE_IMAGE ( mime_define.hpp ж)
	 * @return {int}  mime_define.hpp ж MIME_CTYPE_XXX
	 */
	int get_ctype(void) const
	{
		return (m_ctype);
	}

	/**
	 *  Content-Type еĴͣ: Content-Type: image/jpeg, 
	 *  MIME_STYPE_JPEG ( mime_define.hpp ж)
	 * @return {int}  mime_define.hpp ж MIME_STYPE_XXX
	 */
	int get_stype() const
	{
		return (m_stype);
	}

	/**
	 *  Content-Type еַͣʽʾ
	 * @return {const char*}  "" ʾ
	 */
	const char* get_ctype_s(void) const;

	/**
	 *  Content-Type еĴַͣʽʾ
	 * @return {const char*}  "" ʾ
	 */
	const char* get_stype_s(void) const;

	/**
	 * ô (Ӧ Content-Transfer-Encoding)
	 * @return {int}  mime_define.hpp ж MIME_ENC_XXX
	 */
	int get_encoding() const
	{
		return (m_encoding);
	}

	/**
	 * ýַַ(Ӧ Content-Type е charset ֶ)
	 * @return {const char*} Ϊʾûиֶ
	 */
	const char* get_charset() const
	{
		return (m_charset);
	}

	/**
	 * Ŀַ, ûڹ캯д
	 * @return {const char*} Ϊʾûδ
	 */
	const char* get_toCharset() const
	{
		if (m_toCharset[0])
			return (m_toCharset);
		else
			return (NULL);
	}

	/**
	 * ñʼеʼƫ
	 * @return {off_t}
	 */
	off_t get_bodyBegin() const
	{
		return (m_bodyBegin);
	}

	/**
	 * ñʼеĽƫ
	 * @return {off_t}
	 */
	off_t get_bodyEnd() const
	{
		return (m_bodyEnd);
	}

	/**
	 * ñͷĳֶεֵ
	 * @param name {const char*} ֶ, : Content-Type
	 * @return {const char*} Ϊʾ
	 */
	const char* header_value(const char* name) const;

	/**
	 * ȡøýͷֶμ
	 * @return {const std::map<string, string>&}
	 */
	const std::map<string, string>& get_headers() const;

	/**
	 * תָĹܵ
	 * @param out {pipe_manager&}
	 * @return {bool} Ƿɹ
	 */
	bool save(pipe_manager& out) const;

	/**
	 * תָĹܵ
	 * @param out {pipe_manager&}
	 * @param src {const char*} ʼݵʼַΪָ룬
	 *  ӹ캯ṩ emailFile ļȡʼ
	 * @param len {int} ʼݵݳȣΪ0ӹ
	 *  ṩ emailFile ļȡʼ
	 * @return {bool} Ƿɹ
	 */
	bool save(pipe_manager& out, const char* src, int len) const;

	/**
	 * תָ
	 * @param out {ostream&} 
	 * @param src {const char*} ʼݵʼַΪָ룬
	 *  ӹ캯ṩ emailFile ļȡʼ
	 * @param len {int} ʼݵݳȣΪ0ӹ
	 *  ṩ emailFile ļȡʼ
	 * @return {bool} Ƿɹ
	 */
	bool save(ostream& out, const char* src = NULL, int len = 0) const;

	/**
	 * תָļ
	 * @param outFile {const char*} Ŀļ
	 * @param src {const char*} ʼݵʼַΪָ룬
	 *  ӹ캯ṩ emailFile ļȡʼ
	 * @param len {int} ʼݵݳȣΪ0ӹ
	 *  ṩ emailFile ļȡʼ
	 * @return {bool} Ƿɹ
	 */
	bool save(const char* outFile, const char* src = NULL, int len = 0) const;

	/**
	 * תڻ
	 * @param out {string&} 
	 * @param src {const char*} ʼݵʼַΪָ룬
	 *  ӹ캯ṩ emailFile ļȡʼ
	 * @param len {int} ʼݵݳȣΪ0ӹ
	 *  ṩ emailFile ļȡʼ
	 * @return {bool} Ƿɹ
	 */
	bool save(string& out, const char* src, int len) const;

	/**
	 * ñӦĸ
	 * @return {mime_node*} Ϊʾûи(˵
	 *  Ϊʼĸ); 򷵻صĸҪ
	 *  delete ͷӦڴ
	 */
	mime_node* get_parent() const;

	/**
	 * жϱǷи
	 * @return {bool} true ʾи, ʾû
	 */
	bool has_parent() const;

	/**
	 * ø (MIME_CTYPE_XXX), Ϊ MIME_CTYPE_OTHER
	 * ˵㲻ڻ򸸽δ֪
	 * @return {int} MIME_CTYPE_XXX
	 */
	int parent_ctype(void) const;
	const char* parent_ctype_s(void) const;

	/**
	 * øĴ (MIME_STYPE_XXX), Ϊ MIME_STYPE_OTHER
	 * ˵㲻ڻ򸸽Ĵδ֪
	 * @return {int} MIME_STYPE_XXX
	 */
	int parent_stype(void) const;
	const char* parent_stype_s(void) const;

	/**
	 * øı (MIME_ENC_XXX), ֵΪ MIME_ENC_OTHER
	 * ˵㲻ڻ򸸽ıδ֪
	 * @return {int} MIME_ENC_XXX
	 */
	int parent_encoding() const;

	/**
	 * øַ, ֵΪ˵㲻ڻ򸸽
	 * ûַ
	 * @return {const char*}
	 */
	char* parent_charset() const;

	/**
	 * øʼƫ
	 * @return {off_t} ֵΪ -1 ʾ㲻
	 */
	off_t parent_bodyBegin() const;

	/**
	 * øƫ
	 * @return {off_t} ֵΪ -1 ʾ㲻
	 */
	off_t parent_bodyEnd() const;

	/**
	 * øͷĳֶӦֵֶ, : Content-Type
	 * @param name {const char*} ֶ
	 * @return {const char*} ֵֶ, ؿ˵㲻
	 *  򸸽ͷвڸֶ
	 */
	const char* parent_header_value(const char* name) const;

protected:
	bool  m_enableDecode;
	string m_name;
	string m_emailFile;
	int   m_ctype;		// mime_define.hpp
	int   m_stype;		// mime_define.hpp
	int   m_encoding;	// mime_define.hpp
	char  m_charset[32];
	char  m_toCharset[32];
	off_t m_bodyBegin;
	off_t m_bodyEnd;
	std::map<string, string>* m_headers_;
	const MIME_NODE* m_pMimeNode;
	mime_node* m_pParent;
};

} // namespace acl
