#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <list>
#include <vector>
#include "acl_cpp/stdlib/dbuf_pool.hpp"
#include "acl_cpp/stdlib/pipe_stream.hpp"

struct ACL_JSON_NODE;
struct ACL_JSON;
struct ACL_ITER;

/**
 *  ACL  json ķװ C++ ûʹã̫עأ
 * ֱʹø࣬ڷִҷǳעܣֱʹ ACL 
 * json ΪҲǵ ACL е json ̣жο
 * ̣ܻ΢ӰһЩܣһӦӰ΢
 */

namespace acl {

class string;
class json;

/**
 * json ڵ㣬 json.create_node() ʽ
 */
class ACL_CPP_API json_node : public dbuf_obj
{
public:
	/**
	 * ȡñ json ڵıǩ
	 * @return {const char*}  json ڵǩؿգ˵
	 *  ҪжϷֵ
	 */
	const char* tag_name(void) const;

	/**
	 * ظ json ڵıǩֵֵΪͻֵʱ߿
	 * нת
	 * @return {const char*} ؿ˵ûıǩֵ
	 */
	const char* get_text(void) const;

	/**
	 *  json ڵӽڵʱر json ڵǩӦ json ӽڵ
	 * @param {const json_node*}  NULL ˵ӽڵ
	 *  עget_text  get_obj ͬʱط NULL
	 */
	json_node* get_obj(void) const;

	/**
	 *  json ڵΪַʱúַ
	 * @return {const char*}  NULL ʾýڵַ
	 */
	const char* get_string(void) const;

	/**
	 *  json ڵΪʱúسֵַָ
	 * @return {long long int*}  NULL ʱʾöǳ
	 */
#if defined(_WIN32) || defined(_WIN64)
	const __int64* get_int64(void) const;
#else
	const long long int* get_int64(void) const;
#endif

	/**
	 *  json ڵΪʱúزֵַָ
	 * @return {bool*}  NULL ʱʾöǲ
	 */
	const bool* get_bool(void) const;

	/**
	 * жϱڵǷΪַ
	 * @return {bool}
	 */
	bool is_string(void) const;

	/**
	 * жϱڵǷΪ
	 * @return {bool}
	 */
	bool is_number(void) const;

	/**
	 * жϱڵǷΪ
	 * @return {bool}
	 */
	bool is_bool(void) const;

	/**
	 * жϱڵǷΪ null 
	 * @return {bool}
	 */
	bool is_null(void) const;

	/**
	 * жϱڵǷΪ
	 * @return {bool}
	 */
	bool is_object(void) const;

	/**
	 * жϱڵǷΪ
	 * @return {bool}
	 */
	bool is_array(void) const;

	/**
	 * øýڵ͵
	 * @return {const char*}
	 */
	const char* get_type(void) const;

	/**
	 *  json ڵбǩʱµıǩֵǾɵıǩ
	 * @param name {const char*} µıǩֵΪǿַ
	 * @return {bool}  false ʾýڵûбǩմûн滻
	 */
	bool set_tag(const char* name);

	/**
	 *  json ڵΪҶڵʱ滻ڵıֵ
	 * @param text {const char*} µҶڵıֵΪǿַ
	 * @return {bool}  false ʾýڵҶڵǷ
	 */
	bool set_text(const char* text);

	/**
	 * ǰ json ڵת json ַ( json ڵ㼰ӽڵ)
	 * @return {const char*}
	 */
	const string& to_string(void);

	/////////////////////////////////////////////////////////////////////

	/**
	 *  json ڵ json_node ӽڵ
	 * @param child {json_node*} ӽڵ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱӽڵã
	 *  򷵻ر json ڵ
	 */
	json_node& add_child(json_node* child, bool return_child = false);

	/**
	 *  json ڵ json_node ӽڵ
	 * @param child {json_node&} ӽڵ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱӽڵã
	 *  򷵻ر json ڵ
	 */
	json_node& add_child(json_node& child, bool return_child = false);

	/**
	 * һ json ڵ󣬲֮Ϊ json ڵӽڵ
	 * @param as_array {bool} Ƿ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱ½ڵã
	 *  򷵻ر json ڵ
	 */
	json_node& add_array(bool return_child = false);
	json_node& add_child(bool as_array = false, bool return_child = false);

	/**
	 * һ json ڵ󣬲֮Ϊ json ڵӽڵ
	 * @param tag {const char*} ǩ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱ½ڵã
	 *  򷵻ر json ڵ
	 */
	json_node& add_child(const char* tag, bool return_child = false);

	/**
	 * һ json ڵ󣬲֮Ϊ json ڵӽڵ
	 * @param tag {const char*} ǩ
	 * @param node {json_node*} ǩֵָ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱ½ڵã
	 *  򷵻ر json ڵ
	 */
	json_node& add_child(const char* tag, json_node* node,
		bool return_child = false);

	/**
	 * һ json ڵ󣬲֮Ϊ json ڵӽڵ
	 * @param tag {const char*} ǩ
	 * @param node {json_node&} ǩֵ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱ½ڵã
	 *  򷵻ر json ڵ
	 */
	json_node& add_child(const char* tag, json_node& node,
		bool return_child = false);

	/**
	 * һַ͵ json ڵ󣬲֮Ϊ json ڵӽڵ
	 * @param tag {const char*} ǩ
	 * @param value {const char*} ǩֵ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱ½ڵã
	 *  򷵻ر json ڵ
	 * ע˴ add_text  add_child ͬĹ
	 */
	json_node& add_text(const char* tag, const char* value,
		bool return_child = false);

	/**
	 * һint64 ͵ json ڵ󣬲֮Ϊ json ڵӽڵ
	 * @param tag {const char*} ǩ
	 * @param value {int64} ǩֵ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱ½ڵã
	 *  򷵻ر json ڵ
	 */
#if defined(_WIN32) || defined(_WIN64)
	json_node& add_number(const char* tag, __int64 value,
		bool return_child = false);
#else
	json_node& add_number(const char* tag, long long int value,
		bool return_child = false);
#endif

	/**
	 * һ͵ json ڵ󣬲֮Ϊ json ڵӽڵ
	 * @param tag {const char*} ǩ
	 * @param value {bool} ǩֵ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱ½ڵã
	 *  򷵻ر json ڵ
	 */
	json_node& add_bool(const char* tag, bool value,
		bool return_child = false);

	/**
	 * һ json ַ󣬲֮Ϊ json ڵӽڵ
	 * @param text {const char*} ıַ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱ½ڵã
	 *  򷵻ر json ڵ
	 */
	json_node& add_array_text(const char* text,
		bool return_child = false);

	/**
	 * һ json ֶ󣬲֮Ϊ json ڵӽڵ
	 * @param value {acl_int64} ֵ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱ½ڵã
	 *  򷵻ر json ڵ
	 */
#if defined(_WIN32) || defined(_WIN64)
	json_node& add_array_number(__int64 value,
		bool return_child = false);
#else
	json_node& add_array_number(long long int value,
		bool return_child = false);
#endif

	/**
	 * һ json 󣬲֮Ϊ json ڵӽڵ
	 * @param value {bool} ֵ
	 * @param return_child {bool} ǷҪ´ӽڵ
	 * @return {json_node&} return_child Ϊ true ʱ½ڵã
	 *  򷵻ر json ڵ
	 */
	json_node& add_array_bool(bool value, bool return_child = false);

	/**
	 * @return {json_node&} رڵĸڵãڲüʽ json
	 *  ʱڷظڵ
	 */
	json_node& get_parent(void) const;

	/////////////////////////////////////////////////////////////////////

	/**
	 * ñڵĵһӽڵ㣬Ҫӽڵʱȵô˺
	 * @return {json_node*} ؿձʾûӽڵ㣬صķǿն
	 *  ⲿ deleteΪڲԶͷ
	 */
	json_node* first_child(void);

	/**
	 * ñڵһӽڵ
	 * @return {json_node*} ؿձʾ̽صķǿն
	 *  ⲿ deleteΪڲԶͷ
	 */
	json_node* next_child(void);

	const char* operator[] (const char* tag);

	/**
	 * ظ json ڵ json е
	 * @return {int}
	 */
	int   depth(void) const;

	/**
	 * ظ json ڵһӽڵĸ
	 * @return {int} Զ >= 0
	 */
	int   children_count(void) const;

	/**
	 * ڵ㼰ӽڵ json ɾڴ潫 json ͳһͷ
	 * @return {int} ͷŵĽڵ
	 */
	int detach(void);

	/**
	 * ڱ json ڵʱڲᶯ̬һЩʱ json_node 󣬵
	 * ˺Щһô˺ first_child,
	 * next_child ص json_node ڵ󽫲ٿãڴǷ
	 * 
	 */
	void clear(void);

	/**
	 *  json 
	 * @return {json&}
	 */
	json& get_json(void) const;

	/**
	 * ȡӦ ACL е json ڵ
	 * @return {ACL_JSON_NODE*} ؽڵעýڵûܵͷ
	 */
	ACL_JSON_NODE* get_json_node(void) const;

private:
	friend class json;
	/**
	 * 캯Ҫöֻ json 󴴽
	 * @param node {ACL_JSON_NODE*} ACL е ACL_JSON_NODE ṹ
	 */
	json_node(ACL_JSON_NODE* node, json* json_ptr);

	/**
	 * ҪöǶ̬
	 */
	~json_node(void);

	/**
	 *  json ڵ
	 * @param node {ACL_JSON_NODE*}
	 */
	void set_json_node(ACL_JSON_NODE* node);

private:
	ACL_JSON_NODE* node_me_;
	json* json_;
	json_node* parent_;
	json_node* parent_saved_;
	std::vector<json_node*>* children_;
	ACL_ITER* iter_;
	string* buf_;
	json_node* obj_;

	union
	{
#if defined(_WIN32) || defined(_WIN64)
		__int64 n;
#else
		long long int n;
#endif
		bool b;
	} node_val_;

	void prepare_iter(void);
};

class ACL_CPP_API json : public pipe_stream, public dbuf_obj
{
public:
	/**
	 * 캯ڽ json ַ json 
	 * @param data {const char*} json ʽַ
	 *  json ַҲǲֵ json ַҲǿָ룬
	 *  ΣûȻòֻ json ַ update
	 *  ڵ update н jsonʵ캯
	 *   data ǿʱҲ update
	 */
	json(const char* data = NULL);

	/**
	 * һ json еһ json ڵ㹹һµ json 
	 * @param node {const json_node&} Դ json еһ json ڵ
	 */
	json(const json_node& node);

	~json(void);

	/**
	 * ǷڽʱԶֵ
	 * @param on {bool}
	 * @return {json&}
	 */
	json& part_word(bool on);

	/**
	 * ʽʽѭñ json ݣҲһ
	 *  json ݣظʹø json  json
	 * Ӧڽһ json ǰ reset() 
	 * һεĽ
	 * @param data {const char*} json 
	 @return {const char*} 󣬸÷ֵʾʣݵַָ
	 */
	const char* update(const char* data);

	/**
	 * жǷ
	 * @return {bool}
	 */
	bool finish(void);

	/**
	 *  json ״̬ json Զ json 
	 * нڷʹñ json ǰҪñ
	 * ڲ json ״̬һεĽ
	 */
	void reset(void);

	/**
	 *  json ȡĳǩĵһڵ
	 * @param tag {const char*} ǩ(ִСд)
	 * @return {json_node*}  json ڵ󣬲򷵻 NULL
	 *  עص json_node ڵ޸ģɾڵ㣬ڲԶɾƣ
	 *  ÷ clear/getElementsByTagName/getElementsByTags 󣬽ڵ
	 *  ٱãΪڵڴ汻Զͷ
	 */
	json_node* getFirstElementByTagName(const char* tag) const;

	/**
	 * ֱӻöӦǩĵһڵ
	 * @param tag {const char*} ǩ(ִСд)
	 * @return {json_node*}  json ڵ󣬲򷵻 NULL
	 *  עص json_node ڵ޸ģɾڵ㣬ڲԶɾƣ
	 *  ÷ clear/getElementsByTagName/getElementsByTags 󣬽ڵ
	 *  ٱãΪڵڴ汻Զͷ
	 */
	json_node* operator[](const char* tag) const;

	/**
	 *  json ȡĳǩнڵ㼯
	 * @param tag {const char*} ǩ(ִСд)
	 * @return {const std::vector<json_node*>&} ؽĶã
	 *  ѯΪգüΪգempty() == true
	 *  עص json_node ڵ޸ģɾڵ㣬ڲԶɾƣ
	 *  ÷ clear/getElementsByTagName/getElementsByTags 󣬽ڵ
	 *  ٱãΪڵڴ汻Զͷ
	 */
	const std::vector<json_node*>&
		getElementsByTagName(const char* tag) const;

	/**
	 *  json ле༶ǩͬ json ڵļ
	 * @param tags {const char*} ༶ǩ '/' ָǩ
	 *   json ݣ
	 *  { 'root': [
	 *      'first': { 'second': { 'third': 'test1' } },
	 *      'first': { 'second': { 'third': 'test2' } },
	 *      'first': { 'second': { 'third': 'test3' } }
	 *    ]
	 *  }
	 *  ͨ༶ǩroot/first/second/third һԲз
	 *  Ľڵ
	 * @return {const std::vector<json_node*>&}  json ڵ㼯, 
	 *  ѯΪգüΪգempty() == true
	 *  עص json_node ڵ޸ģɾڵ㣬ڲԶɾƣ
	 *  ÷ clear/getElementsByTagName/getElementsByTags 󣬽ڵ
	 *  ٱãΪڵڴ汻Զͷ
	 */
	const std::vector<json_node*>&
		getElementsByTags(const char* tags) const;

	/**
	 *  json ле༶ǩͬ json ڵļ
	 * @param tags {const char*} ༶ǩ '/' ָǩ
	 *   json ݣ
	 *  { 'root': [
	 *      'first': { 'second': { 'third': 'test1' } },
	 *      'first': { 'second': { 'third': 'test2' } },
	 *      'first': { 'second': { 'third': 'test3' } }
	 *    ]
	 *  }
	 *  ͨ༶ǩroot/first/second/third һԲз
	 *  Ľڵ
	 * @return {json_node*}  NULL ʾ
	 */
	json_node* getFirstElementByTags(const char* tags) const;

	/**
	 * ȡ acl е ACL_JSON 
	 * @return {ACL_JSON*} ֵΪգעû޸ĸöֵ
	 *  ͷŸö
	 */
	ACL_JSON* get_json(void) const;

	/////////////////////////////////////////////////////////////////////

	/**
	 * һ json_node Ҷڵ󣬸ýڵĸʽΪ
	 * "tag_name": "tag_value"
	 * @param tag {const char*} ǩ
	 * @param value {const char*} ǩֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩڵԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node ڵ
	 */
	json_node& create_node(const char* tag, const char* value);

	/**
	 * һ json_node Ҷڵ󣬸ýڵĸʽΪ
	 * "tag_name": tag_value
	 * @param tag {const char*} ǩ
	 * @param value {int64} ǩֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩڵԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node ڵ
	 */
#if defined(_WIN32) || defined(_WIN64)
	json_node& create_node(const char* tag, __int64 value);
#else
	json_node& create_node(const char* tag, long long int value);
#endif

	/**
	 * һ json_node Ҷڵ󣬸ýڵĸʽΪ
	 * "tag_name": true|false
	 * @param tag {const char*} ǩ
	 * @param value {bool} ǩֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩڵԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node ڵ
	 */
	json_node& create_node(const char* tag, bool value);

	/**
	 * һ json_node Ҷڵַ󣬸ýڵĸʽΪ"string"
	 *  json 淶ýڵֻܼ
	 * @param text {const char*} ıַ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩڵԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node ڵ
	 */
	json_node& create_array_text(const char* text);

	/**
	 * һ json_node Ҷڵֵ
	 *  json 淶ýڵֻܼ
	 * @param value {acl_int64} ֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩڵԶͷţȻûҲ
	 * ʱ reset ͷЩ json_node ڵ
	 */
#if defined(_WIN32) || defined(_WIN64)
	json_node& create_array_number(__int64 value);
#else
	json_node& create_array_number(long long int value);
#endif

	/**
	 * һ json_node Ҷڵ㲼
	 *  json 淶ýڵֻܼ
	 * @param value {bool} ֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩڵԶͷţȻûҲ
	 * ʱ reset ͷЩ json_node ڵ
	 */
	json_node& create_array_bool(bool value);

	/**
	 * һ json_node ڵ󣬸öûбǩ,
	 * ýڵĸʽΪ"{}"  "[]"
	 * @param as_array {bool} Ƿ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩڵԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node ڵ
	 */
	json_node& create_node(bool as_array = false);
	json_node& create_array(void);

	/**
	 * һ json_node ڵ󣬸ýڵĸʽΪtag_name: {}
	 *  tag_name: []
	 * @param tag {const char*} ǩ
	 * @param node {json_node*} json ڵΪǩֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩڵԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node ڵ
	 */
	json_node& create_node(const char* tag, json_node* node);

	/**
	 * һ json_node ڵ󣬸ýڵĸʽΪtag_name: {}
	 *  tag_name: []
	 * @param tag {const char*} ǩ
	 * @param node {json_node&} json ڵΪǩֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩڵԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node ڵ
	 */
	json_node& create_node(const char* tag, json_node& node);

	/////////////////////////////////////////////////////////////////////

	/**
	 * һ json еһ json ڵ㸴һ json еһ
	 *  json ڵвظµ json ڵ
	 * @param node {json_node*} Դ json һ json ڵ
	 * @return {json_node&} ǰĿ json ´ json ڵ
	 */
	json_node& duplicate_node(const json_node* node);

	/**
	 * һ json еһ json ڵ㸴һ json еһ
	 *  json ڵвظµ json ڵ
	 * @param node {json_node&} Դ json һ json ڵ
	 * @return {json_node&} ǰĿ json ´ json ڵ
	 */
	json_node& duplicate_node(const json_node& node);

	/**
	 * øڵ
	 * @return {json_node&}
	 */
	json_node& get_root(void);

	/**
	 * ʼ json 󲢻õһڵ
	 * @return {json_node*} ؿձʾ json Ϊսڵ
	 *  עصĽڵûֹͷţΪö
	 *  ڲԶͷ
	 */
	json_node* first_node(void);

	/**
	 *  json һ json ڵ
	 * @return {json_node*} ؿձʾ
	 *  עصĽڵûֹͷţΪö
	 *  ڲԶͷ
	 */
	json_node* next_node(void);

	/**
	 *  json תַ
	 * @param out {string&} 洢תĻ
	 */
	void build_json(string& out) const;

	/**
	 *  json ת json ַ
	 * @return {const string&}
	 */
	const string& to_string(void);

	// pipe_stream 麯

	virtual int push_pop(const char* in, size_t len,
		string* out, size_t max = 0);
	virtual int pop_end(string* out, size_t max = 0);
	virtual void clear(void);

private:
	// Ӧ acl е ACL_JSON 
	ACL_JSON *json_;
	// json еĸڵ
	json_node* root_;
	// ʱ json ڵѯ
	std::vector<json_node*> nodes_query_;
	// ɸ json  json ڵ㼯
	std::list<json_node*> nodes_tmp_;
	// 
	string* buf_;
	ACL_ITER* iter_;
};

} // namespace acl
