#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <list>
#include <string>
#include "acl_cpp/mime/mime_head.hpp"

struct MIME_STATE;

namespace acl {

class string;
class mime_node;
class mime_attach;
class mime_body;
class mime_image;
class ifstream;
class fstream;

class ACL_CPP_API mime
{
public:
	mime();
	~mime();

	/////////////////////////////////////////////////////////////////////
	// ʼصĺ

	/**
	 * ͬһMIMEԶʼʱ, Ҫô˺֮ǰ
	 * вڴ, Ȼεøú޺, Ϊ˲Ӱ
	 * Ч, øýһʼǰøú
	 */
	mime& reset(void);

	/**
	 * ߿ֹô˺Դʼͷ
	 */
	void primary_head_finish(void);

	/**
	 * ʽʱô˺жʼͷǷ
	 * @return {bool} Ƿʼͷ
	 */
	bool primary_head_ok() const;

	/**
	 * ʼʽ, úڲԶ reset() ý
	 * ״̬
	 * @param path {const char*} ʼļ·, òΪ, 
	 *  ʼ, Ҳܵ save_xxx صĽӿ
	 */
	void update_begin(const char* path);

	/**
	 * ô˺ʽʽʼ, ʼͷ, ô
	 * ӿڽʼͷ update_end() ӿڼ, Ҫһ
	 * ʼ, Ҫϵصô˺ֱ true ʾ multipart ʽ
	 * ʼ;  multipart ʽʼ, ˺ܻط true,
	 * ҪжʼĽλ
	 * @param data {const char*} ʼ(ʼͷҲʼ, 
	 *  )
	 * @param len {size_t} data ݳ
	 * @return {bool}  multipart ʼ,  true ʾ÷ʼ;
	 *  ڷ multipart ʼ, ÷ֵԶΪ false, ûκ, Ҫ
	 *  ԼжʼĽλ
	 * ע: ˺һҪ update_end ֪ͨ
	 */
	bool update(const char* data, size_t len);

	/**
	 * ڲʽô˺
	 */
	void update_end(void);

	/**
	 * ô˺ϵһʼ
	 * @param file_path {const char*} ʼļ·
	 * @return {bool}  false ˵Դʼļ޷
	 */
	bool parse(const char* file_path);

	/**
	 * ʼΪһļ
	 * @param out {fstream&} Ŀ
	 * @return {bool} Ƿɹ
	 */
	bool save_as(fstream& out);

	/**
	 * ʼΪһļ
	 * @param file_path {const char*} Ŀļ
	 * @return {bool} Ƿɹ
	 */
	bool save_as(const char* file_path);

	/**
	 * ʼϺ󣬰ͻʾķʽڴ̣
	 * ûʹ򿪸 html ҳ
	 * @param path {const char*} ҳ汣·
	 * @param filename {const char*} Ŀļ
	 * @param enableDecode {bool} תʱǷԶн
	 * @param toCharset {const char*} Ŀַ
	 * @param off {off_t} ϣʼ㸽ӵƫ
	 * @return {bool} Ƿɹ
	 */
	bool save_mail(const char* path, const char* filename,
		bool enableDecode = true, const char* toCharset = "gb2312",
		off_t off = 0);

	/**
	 * ʼĽ
	 * @param htmlFirst {bool} ȻHTMLʽıȻ
	 *  ıֻHTMLıתΪı
	 * @param enableDecode {bool} תʱǷԭĽн
	 * @param toCharset {const char*} Ŀַ
	 * @param off {off_t} ϣʼ㸽ӵƫ
	 * @return {mime_body*} δҵ򷵻 NULL
	 */
	mime_body* get_body_node(bool htmlFirst, bool enableDecode = true,
                const char* toCharset = "gb2312", off_t off = 0);

	/**
	 * е mime б
	 * @param enableDecode {bool} תʱǷԶн
	 * @param toCharset {const char*} Ŀַ
	 * @param off {off_t} ϣʼ㸽ӵƫ
	 * @return {const std::list<mime_node*>&}
	 */
	const std::list<mime_node*>& get_mime_nodes(bool enableDecode = true,
		const char* toCharset = "gb2312", off_t off = 0);

	/**
	 * øб
	 * @param enableDecode {bool} תʱǷԶн
	 * @param toCharset {const char*} Ŀַ
	 * @param off {off_t} ϣʼ㸽ӵƫ
	 * @param all {bool} ȡа message/application/image ڵнڵ
	 * @return {const std::list<mime_attach*>&}
	 */
	const std::list<mime_attach*>& get_attachments(bool enableDecode = true,
		const char* toCharset = "gb2312", off_t off = 0, bool all = true);

	/**
	 * ͼƬб
	 * @param enableDecode {bool} תʱǷԶн
	 * @param toCharset {const char*} Ŀַ
	 * @param off {off_t} ϣʼ㸽ӵƫ
	 * @return {const std::list<mime_image*>&}
	 */
	const std::list<mime_image*>& get_images(bool enableDecode = true,
		const char* toCharset = "gb2312", off_t off = 0);
	mime_image* get_image(const char* cld, bool enableDecode = true,
		const char* toCharset = "gb2312", off_t off = 0);

	/**
	 * MIME
	 * @param save_path {const char*} 洢 MIME ·
	 * @param decode {bool} ǷԭĽн
	 */
	void mime_debug(const char* save_path, bool decode = true);

	/////////////////////////////////////////////////////////////////////
        // ʼͷصĺ

	/**
	 * ÷
	 * @param addr {const char*} ʼַ
	 * @return {mime&}
	 */
	mime& set_sender(const char* addr)
	{
		m_primaryHeader.set_returnpath(addr);
		return (*this);
	}

	/**
	 * ÷: From: zhengshuxin@51iker.com
	 * @param addr {const char*} ʼַ
	 * @return {mime&}
	 */
	mime& set_from(const char* addr)
	{
		m_primaryHeader.set_from(addr);
		return (*this);
	}

	/**
	 * ʼصַ: Reply-To: zhengshuxin@51iker.com
	 * @param addr {const char*} ʼַ
	 * @return {mime&}
	 */
	mime& set_replyto(const char* addr)
	{
		m_primaryHeader.set_replyto(addr);
		return (*this);
	}

	/**
	 * ʼַ Return-Path: <zhengshuxin@51iker.com>
	 * @param addr {const char*} ʼַ
	 * @return {mime&}
	 */
	mime& set_returnpath(const char* addr)
	{
		m_primaryHeader.set_returnpath(addr);
		return (*this);
	}

	/**
	 * ʼ: Subject: test
	 * @param s {const char*} ʼ
	 * @return {mime&}
	 */
	mime& set_subject(const char* s)
	{
		m_primaryHeader.set_subject(s);
		return (*this);
	}

	/**
	 * ʼ: To: <zhengshuxin@51iker.com>
	 * @param addr {const char*} ʼַ
	 * @return {mime&}
	 */
	mime& add_to(const char* addr)
	{
		m_primaryHeader.add_to(addr);
		return (*this);
	}

	/**
	 * ʼ: CC: <zhengshuxin@51iker.com>
	 * @param addr {const char* addr} ʼַ
	 * @return {mime&}
	 */
	mime& add_cc(const char* addr)
	{
		m_primaryHeader.add_cc(addr);
		return (*this);
	}

	/**
	 * ʼ: BCC: <zhengshuxin@51iker.com>
	 * @param addr {const char* addr} ʼַ
	 * @return {mime&}
	 */
	mime& add_bcc(const char* addr)
	{
		m_primaryHeader.add_bcc(addr);
		return (*this);
	}

	/**
	 * ʼ: CC: <zhengshuxin@51iker.com>
	 * @param addr {const char* addr} ʼַ
	 * @return {mime&}
	 */
	mime& add_rcpt(const char* addr)
	{
		m_primaryHeader.add_rcpt(addr);
		return (*this);
	}

	/**
	 * ʼͷֶ
	 * @param name {const char*} ֶ
	 * @param value {const char*} ֵֶ
	 * @return {mime&}
	 */
	mime& add_header(const char* name, const char* value)
	{
		m_primaryHeader.add_header(name, value);
		return (*this);
	}

	/**
	 * ʼͷ: Content-Type: text/plain
	 * @param ctype {const char*} 
	 * @param stype {const char*} 
	 * @return {mime&}
	 */
	mime& set_type(const char* ctype, const char* stype)
	{
		m_primaryHeader.set_type(ctype, stype);
		return (*this);
	}

	/**
	 * ʼͷķָ
	 * @param s {const char*} ָ
	 * @return {mime&}
	 */
	mime& set_boundary(const char* s)
	{
		m_primaryHeader.set_boundary(s);
		return (*this);
	}

	/**
	 * ÷
	 * @return {const string&} ضΪ
	 *  ( string::empty()) ʾûдֶ
	 */
	const string& sender(void) const
	{
		return (m_primaryHeader.sender());
	}

	/**
	 * ÷
	 * @return {const string&} ضΪ
	 *  ( string::empty()) ʾûдֶ
	 */
	const string& from(void) const
	{
		return (m_primaryHeader.from());
	}

	/**
	 * ûظʼַ
	 * @return {const string&} ضΪ
	 *  ( string::empty()) ʾûдֶ
	 */
	const string& replyto(void) const
	{
		return (m_primaryHeader.replyto());
	}

	/**
	 * ûظʼַ
	 * @return {const string&} ضΪ
	 *  ( string::empty()) ʾûдֶ
	 */
	const string& returnpath(void) const
	{
		return (m_primaryHeader.returnpath());
	}

	/**
	 * ʼ
	 * @return {const string&} ضΪ
	 *  ( string::empty()) ʾûдֶ
	 */
	const string& subject(void) const
	{
		return (m_primaryHeader.subject());
	}

	/**
	 * ռб: To: xxx@xxx.com
	 * @return {const std::list<char*>&) ضΪ
	 *  ( std::list<char*>::empty()) ʾûдֶ
	 */
	const std::list<char*>& to_list(void) const
	{
		return (m_primaryHeader.to_list());
	}

	/**
	 * óб: To: xxx@xxx.com
	 * @return {const std::list<char*>&) ضΪ
	 *  ( std::list<char*>::empty()) ʾûдֶ
	 */
	const std::list<char*>& cc_list(void) const
	{
		return (m_primaryHeader.cc_list());
	}

	/**
	 * ðб: To: xxx@xxx.com
	 * @return {const std::list<char*>&) ضΪ
	 *  ( std::list<char*>::empty()) ʾûдֶ
	 */
	const std::list<char*>& bcc_list(void) const
	{
		return (m_primaryHeader.bcc_list());
	}

	/**
	 * ռб:
	 * To: xxx@xxx.xxx, CC: xxx@xxx.xxx, BCC: xxx@xxx.xxx
	 * @return {const std::list<char*>&) ضΪ
	 *  ( std::list<char*>::empty()) ʾûдֶ
	 */
	const std::list<char*>& rcpt_list(void) const
	{
		return (m_primaryHeader.rcpt_list());
	}

	/**
	 * ʼͷĸֶб
	 * @return {const std::list<HEADER*>&)
	 */
	const std::list<HEADER*>& header_list(void) const
	{
		return (m_primaryHeader.header_list());
	}	

	/**
	 * ѯʼͷӦֵֶֶ
	 * @param name {const char*} ֶ
	 * @return {const char*} ֵֶ, Ϊʱʾ
	 */
	const char* header_value(const char* name) const
	{
		return (m_primaryHeader.header_value(name));
	}

	/**
	 * ѯʼͷӦֵֶֶ
	 * @param name {const char*} ֶ
	 * @param values {std::list<const char*>*} 洢ӦĽ
	 * @return {int} ֵֶϵĸ
	 */
	int header_values(const char* name, std::list<const char*>* values) const
	{
		return (m_primaryHeader.header_values(name, values));
	}

	/**
	 * ʼͷй Content-Type: text/html е text ֶ
	 * @return {const char*} Զطǿֵ
	 */
	const char* get_ctype() const
	{
		return m_primaryHeader.get_ctype();
	}

	/**
	 * ʼͷй Content-Type: text/html е html ֶ
	 * @return {const char*} Զطǿֵ
	 */
	const char* get_stype() const
	{
		return m_primaryHeader.get_stype();
	}

	/**
	 * ʼͷ
	 * @return {const mime_head&}
	 */
	const mime_head& primary_header(void) const
	{
		return (m_primaryHeader);
	}

private:
	mime_head m_primaryHeader;

	MIME_STATE* m_pMimeState;
	bool m_bPrimaryHeadFinish;
	char* m_pFilePath;
	mime_body* m_pBody;
	std::list<mime_node*>* m_pNodes;
	std::list<mime_attach*>* m_pAttaches;
	std::list<mime_image*>* m_pImages;
};

} // namespace acl
