#pragma once
#include <vector>

namespace acl_min
{

class connect_pool;
class locker;

/**
 * connect pool лȡӳصȹ
 */
class connect_manager
{
public:
	connect_manager();
	virtual ~connect_manager();

	/**
	 * ʼзӳأúڲ set ÿӳ
	 * @param default_addr {const char*} ȱʡķַǿգ
	 *  ڲѯʱʹô˷
	 * @param addr_list {const char*} збΪ
	 *  ʽIP:PORT:COUNT,IP:PORT:COUNT ...
	 *  磺127.0.0.1:7777:50, 192.168.1.1:7777:10, 127.0.0.1:7778
	 * @param default_count {int}  addr_list зָĳû
	 *  COUNT Ϣʱôֵ
	 *  עdefault_addr  addr_list ͬʱΪ
	 * @return {bool}  false ˵ûЧĵַ
	 */
	bool init(const char* default_addr, const char* addr_list,
		int default_count);

	/**
	* ӷĿͻӳأúڳй
	* ãΪڲԶ
	 * @param addr {const char*} ַ(ip:port)
	 * @param count {int} ӳ
	 * @return {connect_pool&} ӵӳض
	 */
	connect_pool& set(const char* addr, int count);

	/**
	 * ӳؼȺɾĳַӳأúڳй
	 * ãΪڲԶ
	 * @param addr {const char*} ַ(ip:port)
	 */
	void remove(const char* addr);

	/**
	 * ݷ˵ַø÷ӳ
	 * @param addr {const char*} redis ַ(ip:port)
	 * @param exclusive {bool} ǷҪӳ飬Ҫ̬
	 *  ӳؼȺʱֵӦΪ true
	 * @return {connect_pool*} ؿձʾûд˷
	 */
	connect_pool* get(const char* addr, bool exclusive = true);

	/**
	 * ӳؼȺлһӳأúѭʽӳؼлȡһ
	 * ˷ӳأӶ֤ȫľԣúڲԶӳع
	 * м
	 * ⣬úΪӿڣʵԼѭʽ
	 * @return {connect_pool*} һӳأָԶǿ
	 */
	virtual connect_pool* peek();

	/**
	 * ӳؼȺлһӳأúùϣλʽӼлȡһ
	 * ˷ӳأش麯ԼļȺȡʽ
	 * 麯ڲȱʡ CRC32 Ĺϣ㷨
	 * @param key {const char*} ֵֵַΪ NULLڲ
	 *  Զлѭʽ
	 * @param exclusive {bool} ǷҪӳ飬Ҫ̬
	 *  ӳؼȺʱֵӦΪ true
	 * @return {connect_pool*} һõӳأָԶǿ
	 */
	virtual connect_pool* peek(const char* key, bool exclusive = true);

	/**
	 * û peek ʱԵô˺ӳع̼
	 */
	void lock();

	/**
	 * û peek ʱԵô˺ӳع̼
	 */
	void unlock();

	/**
	 * еķӳأӳаȱʡķӳ
	 * @return {std::vector<connect_pool*>&}
	 */
	std::vector<connect_pool*>& get_pools()
	{
		return pools_;
	}

	/**
	 * ӳؼӳضĸ
	 * @return {size_t}
	 */
	size_t size() const
	{
		return pools_.size();
	}

	/**
	 * ȱʡķӳ
	 * @return {connect_pool*}  init  default_addr Ϊʱ
	 *  ú NULL
	 */
	connect_pool* get_default_pool()
	{
		return default_pool_;
	}

protected:
	/**
	 * 麯ʵִ˺ӳض
	 * @param idx {size_t} ӳضڼе±λ( 0 ʼ)
	 * @param addr {const char*} ַʽip:port
	 * @param count {int} ӳصĴС
	 * @return {connect_pool*} شӳض
	 */
	virtual connect_pool* create_pool(const char* addr,
		int count, size_t idx) = 0;

	/**
	 * ӡǰ redis ӳصķ
	 */
	void statistics();

private:
	std::string default_addr_;		// ȱʡķַ
	connect_pool* default_pool_;		// ȱʡķӳ
	std::vector<connect_pool*> pools_;	// еķӳ
	size_t service_idx_;			// һҪʵĵ±ֵ
	locker* lock_;				//  pools_ ʱĻ
	int  stat_inter_;			// ͳƷĶʱ

	// óȱʡ֮ķȺ
	void set_service_list(const char* addr_list, int count);
};

} // namespace acl_min
