#include <iostream>
#include <assert.h>
#include "lib_acl.h"
#include "acl_cpp/stream/aio_handle.hpp"
#include "acl_cpp/stream/aio_istream.hpp"
#include "acl_cpp/stream/aio_listen_stream.hpp"
#include "acl_cpp/stream/aio_socket_stream.hpp"

using namespace acl;

/**
 * 첽ͻĻص
 */
class io_callback : public aio_callback
{
public:
	io_callback(aio_socket_stream* client)
		: client_(client)
	{
	}

	~io_callback()
	{
		std::cout << "delete io_callback now ..." << std::endl;
	}

	/**
	 * ʵָе麯ͻĶɹص
	 * @param data {char*} ݵַ
	 * @param len {int} ݳ
	 * @return {bool}  true ʾϣرո첽
	 */
	bool read_callback(char* data, int len)
	{
		string buf;
		buf.copy(data, len);

		// Զ̿ͻ˻дյ

		buf += "\r\n";
		client_->write(buf.c_str(), buf.length());

		//client_->read(6); // ÿζݳͬ򲻱ʽ read 
		return true;
	}

	/**
	 * ʵָе麯ͻдɹص
	 * @return {bool}  true ʾϣرո첽
	 */
	bool write_callback()
	{
		return true;
	}

	/**
	 * ʵָе麯ͻĳʱص
	 */
	void close_callback()
	{
		// ڴ˴ɾö̬ĻصԷֹڴй¶
		delete this;
	}

	/**
	 * ʵָе麯ͻĳʱص
	 * @return {bool}  true ʾϣرո첽
	 */
	bool timeout_callback()
	{
		std::cout << "Timeout ..." << std::endl;
		return true;
	}

private:
	aio_socket_stream* client_;
};

/**
 * 첽Ļص
 */
class io_accept_callback : public aio_accept_callback
{
public:
	io_accept_callback() {}
	~io_accept_callback()
	{
		printf(">>io_accept_callback over!\n");
	}

	/**
	 * 麯ӵô˻ص
	 * @param client {aio_socket_stream*} 첽ͻ
	 * @return {bool}  true ֪ͨ
	 */
	bool accept_callback(aio_socket_stream* client)
	{
		// 첽ͻĻص첽а
		io_callback* callback = new io_callback(client);

		// ע첽Ķص
		client->add_read_callback(callback);

		// ע첽дص
		client->add_write_callback(callback);

		// ע첽Ĺرջص
		client->add_close_callback(callback);

		// ע첽ĳʱص
		client->add_timeout_callback(callback);

		// 첽
		client->read(6);
		return true;
	}
};

static void usage(const char* procname)
{
	printf("usage: %s -h[help] -k[use kernel event: epoll/iocp/kqueue/devpool]\n", procname);
}

int main(int argc, char* argv[])
{
	bool use_kernel = true;
	int  ch;

	while ((ch = getopt(argc, argv, "hk")) > 0)
	{
		switch (ch)
		{
		case 'h':
			usage(argv[0]);
			return 0;
		case 'k':
			use_kernel = true;
			break;
		default:
			break;
		}
	}

	// 첽
	aio_handle handle(use_kernel ? ENGINE_KERNEL : ENGINE_SELECT);

	// 첽
	aio_listen_stream* sstream = new aio_listen_stream(&handle);
	const char* addr = "127.0.0.1:9001";

	// ʼACL(WIN32һҪô˺UNIXƽ̨¿ɲ)
	acl_init();

	// ָĵַ
	if (sstream->open(addr) == false)
	{
		std::cout << "open " << addr << " error!" << std::endl;
		sstream->close();
		// XXX: Ϊ˱֤ܹرռӦڴ˴ check һ
		handle.check();

		getchar();
		return 1;
	}

	// ص󣬵ӵʱԶôĻص
	io_accept_callback callback;
	sstream->add_accept_callback(&callback);
	std::cout << "Listen: " << addr << " ok!" << std::endl;

	while (true)
	{
		//  false ʾټҪ˳
		if (handle.check() == false)
		{
			std::cout << "aio_server stop now ..." << std::endl;
			break;
		}
	}

	// رռͷ
	sstream->close();

	// XXX: Ϊ˱֤ܹرռӦڴ˴ check һ
	handle.check();

	return 0;
}
