#pragma once
#include <map>
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/stdlib/locker.hpp"
#include "acl_cpp/queue/queue_file.hpp"

typedef struct ACL_SCAN_DIR ACL_SCAN_DIR;

namespace acl {

class queue_file;

class ACL_CPP_API queue_manager
{
public:
	/**
	 * жĹ캯
	 * @param home {const char*} еĸĿ¼
	 * @param queueName {const char*} öжĶ
	 */
	queue_manager(const char* home, const char* queueName,
		unsigned sub_width = 2);
	~queue_manager();

	/**
	 * ö
	 * @return {const char*}
	 */
	const char* get_queueName() const;

	/**
	 * öиĿ¼
	 * @return {const char*}
	 */
	const char* get_home() const;

	/**
	 * ļ
	 * @param extName {const char*} ļչ
	 * @return {queue_file*} ļ, ԶNULL, ÷ֵ
	 *  Ϊ̬, Ҫ delete ͷռڴ
	 */
	queue_file* create_file(const char* extName);

	/**
	 * 򿪴ϴڵĶļڶ/д
	 * @param path {const char*} ļ
	 * @param no_cache {bool} Ϊ true ʱҪڻиļӦ KEY
	 *  벻ڣ򷵻 NULL ʾļ; òΪ
	 *  false ʱֱʹûеĶ
	 * @return {queue_file*} ļ, 򲻴򷵻 NULL
	 */
	queue_file* open_file(const char* path, bool no_cache = true);

	/**
	 * رնļ, ͷŸļ󣬲ɾļ
	 * @param fp {queue_file*} ļ
	 * @return {bool} رǷɹ
	 */
	bool close_file(queue_file* fp);

	/**
	 * Ӵɾļ, ͷŸļ
	 * @param fp {queue_file*} ļ
	 * @return {bool} ɾļǷɹ
	 */
	bool delete_file(queue_file* fp);

	/**
	 * ޸ļչ
	 * @param fp {queue_file*} ļ
	 * @param extName {const char*} µչ
	 * @return {bool} ޸ļչǷɹ
	 */
	bool rename_extname(queue_file* fp, const char* extName);

	/**
	 * ļĿ, ƶɹ, ļڲݽᷢı
	 * @param fp {queue_file*} ļ
	 * @param queueName {const char*} Ŀ
	 * @param extName {const char*} ļչ
	 * @return {bool} ƶļǷɹ, ƶʧ, Ӧõ
	 *  close_file رոöļ, ļᱻʱɨ
	 */
	bool move_file(queue_file* fp, const char* queueName, const char* extName);

	/**
	 * һļĿж
	 * @param fp {queue_file*} ļ
	 * @param toQueue {queue_manager*} Ŀж
	 * @param extName {const char*} ļչ
	 * @return {bool} ƶļǷɹ, ƶʧ, Ӧõ
	 *  close_file رոöļ, ļᱻʱɨ
	 */
	bool move_file(queue_file* fp, queue_manager* toQueue, const char* extName);

	/**
	 * Ӵɾļ, ɾɹöļѾɾ, ,
	 * ʹɾļʧ, öļҲͷ, ֻǴӴɾļʧ,
	 * Եô˺ fp ٴʹ
	 * @param fp {queue_file*}
	 * @return {bool} ɾǷɹ
	 */
	bool remove(queue_file* fp);

	/**
	* ļǷڱʹ
	* @param fileName {const char*} ļ
	* @return {bool} Ƿʹ
	*/
	bool busy(const char* fileName);

	/**
	* ڶжĻвĳļ
	* @param key {const char*} ļĲļ(·չ)
	* @return {queue_file*}  NULL ʾδ鵽
	*/
	queue_file* cache_find(const char* key);

	/**
	* жĻĳļ
	* @param fp {queue_file*} ļ
	* @return {bool} Ƿɹ, ʧ˵öӦļֵ
	*  Ѿڻ
	*/
	bool cache_add(queue_file* fp);

	/**
	* ӶжĻɾĳļ
	* @param key {const char*} ļļֵ
	* @return {bool} ɾǷɹ, ʧ˵öļ󲻴
	*/
	bool cache_del(const char* key);

	/*-------------------- ɨصĺ ------------------------*/

	/**
	* 򿪴ɨ
	* @param scanSub {bool} ǷݹɨĿ¼
	* @return {bool} 򿪶Ƿɹ
	*/
	bool scan_open(bool scanSub = true);

	/**
	* رɨ
	*/
 	void scan_close();

	/**
	* ô̶еһļ, ɨ򷵻ؿ
	* @return {queue_file*} ɨĶļ, ؿʾɨ
	*  ǿնһҪ delete ͷڲԴ
	*/
	queue_file* scan_next(void);

	/**
	* ļ·, ļ(·չ), ļչ
	* @param filePath {const char*} ļȫ·
	* @param home {acl::string*} 洢ļڵĸĿ¼
	* @param queueName {acl::string*} 洢ļڵĶ
	* @param queueSub {acl::string*} 洢ļĶĿ¼
	* @param partName {acl::string*} 洢ļļ(·չ)
	* @param extName {acl::string*} 洢ļչ
	*/
	static bool parse_filePath(const char* filePath, acl::string* home,
		string* queueName, string* queueSub,
		string* partName, string* extName);

	/**
	* ļ(չ·), ļ(·չ),
	* ļչ
	*/
	static bool parse_fileName(const char* fileName, acl::string* partName,
		string* extName);

	/**
	* ·, ȡ
	*/
	static bool parse_path(const char* path, acl::string* home,
		string* queueName, acl::string* queueSub);

	/**
	* ݲļ(Ŀ¼չ)Ŀ¼·(ֱʾ)
	* @param partName {const char*} ļ
	* @param width {unsigned} жĿ¼ĸ
	* @return {unsigned int} Ŀ¼·(ֱʾ)
	*/
	static unsigned int hash_queueSub(const char* partName, unsigned width);

protected:
private:
	bool cache_check(queue_file* fp);

	//typedef struct ACL_SCAN_DIR ACL_SCAN_DIR;

	// ɨĿ¼ľ
	ACL_SCAN_DIR* m_scanDir;
	string m_home;
	string m_queueName;
	unsigned sub_width_;

	std::map<string, queue_file*> m_queueList;
	locker m_queueLocker;
};

} // namespace acl
