#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stdlib/string.hpp"
#include <map>

namespace acl
{

/**
 * SQL ѯѯԶ sql еһЩַת壬ʹ÷ʽ
 * java hibernate  SQL 乹ʽ
 */
class ACL_CPP_API query
{
public:
	query();
	~query();

	/**
	 *  sql 䣬ηʽ÷ printf 
	 * @param sql_fmt {const char*} sql 䣬ʽ磺
	 *  select * from xxx where name = :name and len >= %d
	 *  е :name,  set_parameter еֵ滻, len Ϊֵ
	 * @return {query&}
	 */
	query& create_sql(const char* sql_fmt, ...) ACL_CPP_PRINTF(2, 3);;

	/**
	 *  sql 䣬Ǳηʽ
	 * @param sql {const char*}  sql 䣬ʽ磺
	 *  select * from xxx where name = :name and len >= :len
	 *  е :name, :len  set_parameter еֵ滻
	 * @return {query&}
	 */
	query& create(const char* sql);

	/**
	 * ַ͵ıֵ
	 * @param name {const char*} 
	 * @param value {const char*} ֵ
	 * @return {query&}
	 */
	query& set_parameter(const char* name, const char *value);

	/**
	 * ַ͵ıֵ
	 * @param name {const char*} 
	 * @param value {char} ֵ
	 * @return {query&}
	 */
	query& set_parameter(const char* name, char value);

	/**
	 *  16 λ͵ıֵ
	 * @param name {const char*} 
	 * @param value {short} ֵ
	 * @return {query&}
	 */
	query& set_parameter(const char* name, short value);

	/**
	 *  32 λ͵ıֵ
	 * @param name {const char*} 
	 * @param value {int} ֵ
	 * @return {query&}
	 */
	query& set_parameter(const char* name, int value);

	/**
	 * õȸ͵ıֵ
	 * @param name {const char*} 
	 * @param value {float} ȸ
	 * @param precision {int} βľֵ
	 * @return {query&}
	 */
	query& set_parameter(const char* name, float value, int precision = 8);

	/**
	 * ˫ȸ͵ıֵ
	 * @param name {const char*} 
	 * @param value {double} ˫ȸ
	 * @param precision {int} βľֵ
	 * @return {query&}
	 */
	query& set_parameter(const char* name, double value, int precision = 8);

	/**
	 *  64 λ͵ıֵ
	 * @param name {const char*} 
	 * @param value {long long int} ֵ
	 * @return {query&}
	 */
#if defined(_WIN32) || defined(_WIN64)
	query& set_parameter(const char* name, __int64 value);
#else
	query& set_parameter(const char* name, long long int value);
#endif

	/**
	 * (time_t)͵ıֵ
	 * @param name {const char*} 
	 * @param value {time_t} ֵ
	 * @param fmt {const char*} ڸʽ
	 * @return {query&}
	 */
	query& set_date(const char* name, time_t value,
		const char* fmt = "%Y-%m-%d %H:%M:%S");

	/**
	 * Աηʽñֵ
	 * @param name {const char*} 
	 * @param fmt {const char*} ֵʽ
	 * @return {query&}
	 */
	query& set_format(const char* name, const char* fmt, ...)
		ACL_CPP_PRINTF(3, 4);

	/**
	 * Աηʽñֵ
	 * @param name {const char*} 
	 * @param fmt {const char*} ֵʽ
	 * @param ap {va_list} ֵб
	 * @return {query&}
	 */
	query& set_vformat(const char* name, const char* fmt, va_list ap);

	/**
	 * Բѯ sql ת󷵻ظ
	 * @return {const string&}
	 */
	const string& to_string();

	/**
	 * ղѯһεĻݣ SQL ѯ󱻶ʹʱӦǰ
	 * ֮ǰ SQL ѯ״̬
	 */
	void reset();

	/**
	 *  sql еһЩַת崦Էֹ SQL ע
	 * @param in {const char*} ֵ
	 * @param len {size_t} in ݳ
	 * @param out {string&} 洢תĽĻòȱ
	 * @return {const string&} ת崦Ľ(ʵ out ĵַ)
	 */
	static const string& escape(const char* in, size_t len, string& out);

	/**
	 * ʱת DateTime ʽַ(YYYY-MM-DD HH:MM:SS)
	 * @param t {time_t} ʱ
	 * @param out {string&} 洢תĻ
	 * @param fmt {const char*} ڸʽ _WIN32 ±뱣֤øʽȷԣ
	 *   _WIN32 API ԣʽ磺"%Y-%m-%d %H:%M:%S"
	 * @return {const char*} ת󻺳ַ NULL ʾתʧ
	 */
	static const char* to_date(time_t t, string& out,
		const char* fmt = "%Y-%m-%d %H:%M:%S");

private:
	typedef enum
	{
		DB_PARAM_CHAR,
		DB_PARAM_SHORT,
		DB_PARAM_INT32,
		DB_PARAM_INT64,
		DB_PARAM_FLOAT,
		DB_PARAM_DOUBLE,
		DB_PARAM_STR
	} db_param_type;

	struct query_param
	{
		char type;
		int  dlen;
		int  precision;
		union
		{
			char  c;
			short s;
			int   n;
			long long int l;
			double d;
			float f;
			char  S[1];
		} v;
	};

	std::map<string, query_param*> params_;
	string* sql_buf_;
	string sql_;
	string buf_;

	void del_param(const string& key);
	bool append_key(string& buf, char* key);
};

} // namespace acl
