#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>
#include <list>
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/stdlib/pipe_stream.hpp"

struct ACL_XML;
struct ACL_XML_NODE;
struct ACL_XML_ATTR;
struct ACL_TOKEN;
struct ACL_ITER;

/**
 *  ACL  XML ķװ C++ ûʹã̫עأ
 * ֱʹø࣬ڷִҷǳעܣֱʹ ACL 
 * XML ΪҲǵ ACL е XML ̣жο
 * ̣ܻ΢ӰһЩܣһӦӰ΢
 */

namespace acl {

class xml;
class xml_node;

class ACL_CPP_API xml_attr
{
public:
	/**
	 * 
	 * @return {const char*} Զ᷵ؿָ룬ֵ
	 *  пΪ "\0"
	 */
	const char* get_name(void) const;

	/**
	 * ֵ
	 * @return {const char*} ֵԶ᷵ؿָ룬ֵ
	 *  пΪ "\0"
	 */
	const char* get_value(void) const;

private:
	friend class xml_node;

	xml_node* node_;
	ACL_XML_ATTR* attr_;

	xml_attr(void);
	~xml_attr(void);
};

class ACL_CPP_API xml_node
{
public:
	/**
	 * ȡñ XML ıǩ
	 * @return {const char*}  XML ǩؿգ˵
	 *  ڱǩxxxxԷһҪжϷֵ
	 */
	const char* tag_name(void) const;

	/**
	 *  XML  ID Բڣ򷵻ؿָ
	 * @return {const char*}  ID ԴʱضӦֵ򷵻ؿ
	 */
	const char* id(void) const;

	/**
	 * ظ XML 
	 * @return {const char*} ؿ˵û
	 */
	const char* text(void) const;

	/**
	 * ظ XML ĳֵ
	 * @param name {const char*} 
	 * @return {const char*} ֵؿ˵Բ
	 */
	const char* attr_value(const char* name) const;

	/**
	 * ظ XML ĳֵıд
	 * @param name {const char*} 
	 * @return {const char*} ֵؿ˵Բ
	 */
	const char* operator[](const char* name) const;

	/**
	 * ʱҪô˺õһԶ
	 * @return {const xml_attr*} صһԶΪգʾ
	 *  ýû
	 */
	const xml_attr* first_attr(void) const;

	/**
	 * ʱñһԶ
	 * @return {const xml_attr*} һԶΪգʾ
	 *  
	 */
	const xml_attr* next_attr(void) const;

	/**
	 *  XML 
	 * @param name {const char*} 
	 * @param value {const char*} ֵ
	 * @return {xml_node&}
	 */
	xml_node& add_attr(const char* name, const char* value);

	/**
	 *  XML 
	 * @param name {const char*} 
	 * @param n {char} ֵ
	 * @return {xml_node&}
	 */
	xml_node& add_attr(const char* name, char n);

	/**
	 *  XML 
	 * @param name {const char*} 
	 * @param n {int} ֵ
	 * @return {xml_node&}
	 */
	xml_node& add_attr(const char* name, int n);

	/**
	 *  XML 
	 * @param name {const char*} 
	 * @param n {size_t} ֵ
	 * @return {xml_node&}
	 */
	xml_node& add_attr(const char* name, size_t n);

	/**
	 *  XML 
	 * @param name {const char*} 
	 * @param n {acl_int64} ֵ
	 * @return {xml_node&}
	 */
#if defined(_WIN32) || defined(_WIN64)
	xml_node& add_attr(const char* name, __int64 n);
#else
	xml_node& add_attr(const char* name, long long int n);
#endif

	/**
	 *  xml ı
	 * @param str {const char*} ַ
	 * @return {xml_node&}
	 */
	xml_node& set_text(const char* str);

	/**
	 *  xml ı
	 * @param number {long long int} 64 λ
	 * @return {xml_node&}
	 */
#if defined(_WIN32) || defined(_WIN64)
	xml_node& set_text(__int64 number);
#else
	xml_node& set_text(long long int number);
#endif

	/**
	 *  xml  xml_node ӽ
	 * @param child {xml_node*} ӽ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {xml_node&} return_child Ϊ true ӽã
	 *  򷵻ر xml 
	 */
	xml_node& add_child(xml_node* child, bool return_child = false);

	/**
	 *  xml  xml_node ӽ
	 * @param child {xml_node&} ӽ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {xml_node&} return_child Ϊ true ӽã
	 *  򷵻ر xml 
	 */
	xml_node& add_child(xml_node& child, bool return_child = false);

	/**
	 *  xml  xml_node ӽ
	 * @param tag {const char* tag} ӽıǩ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @param str {const char*} ıַ
	 * @return {xml_node&} return_child Ϊ true ӽã
	 *  򷵻ر xml 
	 */
	xml_node& add_child(const char* tag, bool return_child = false,
		const char* str = NULL);

	/**
	 *  xml  xml_node ӽ
	 * @param tag {const char* tag} ӽıǩ
	 * @param number {long long int} 64 λ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {xml_node&} return_child Ϊ true ӽã
	 *  򷵻ر xml 
	 */
#if defined(_WIN32) || defined(_WIN64)
	xml_node& add_child(const char* tag, __int64 number,
		bool return_child = false);
#else
	xml_node& add_child(const char* tag, long long int number,
		bool return_child = false);
#endif

	/**
	 * ñĸ
	 * @return {xml_node&}
	 */
	xml_node& get_parent(void) const;

	/**
	 * ñĵһӽ㣬Ҫӽʱȵô˺
	 * @return {xml_node*} ؿձʾûӽ
	 */
	xml_node* first_child(void);

	/**
	 * ñһӽ
	 * @return {xml_node*} ؿձʾ̽
	 */
	xml_node* next_child(void);

	/**
	 * ظ XML  XML е
	 * @return {int}
	 */
	int   depth(void) const;

	/**
	 * ظ xml һӽĸ
	 * @return {int} Զ >= 0
	 */
	int   children_count(void) const;

	/**
	 * ڱ xml ʱڲᶯ̬һЩʱ xml_node 󣬵ô˺
	 * Щһô˺ first_child/next_child
	 * ص xml_node 󽫲ٿãڴǷ
	 */
	void clear();

	/**
	 *  xml 
	 * @return {xml&}
	 */
	xml& get_xml(void) const;

	/**
	 * ȡӦ ACL е XML 
	 * @return {ACL_XML_NODE*} ؽעýûܵͷ
	 */
	ACL_XML_NODE* get_xml_node() const;

private:
	friend class xml;

	/**
	 * xml 㹹캯
	 * @param node {ACL_XML_NODE*} μ acl  acl_xml.hеͷļǿ
	 * @param xml_ptr {xml*} xml 󣬷ǿ
	 */
	xml_node(ACL_XML_NODE* node, xml* xml_ptr);

	/**
	 * ҪöǶ̬
	 */
	~xml_node(void);

	/**
	 *  xml 
	 * @param node {ACL_XML_NODE*}
	 */
	void set_xml_node(ACL_XML_NODE* node);

private:
	ACL_XML_NODE *node_;
	xml* xml_;
	xml_node* parent_;
	xml_node* parent_saved_;
	ACL_ITER* child_iter_;
	ACL_ITER* attr_iter_;
	std::vector<xml_node*> nodes_tmp_;
	std::vector<xml_attr*> attrs_tmp_;
};

class string;

class ACL_CPP_API xml : public pipe_stream
{
public:
	/**
	 * 캯
	 * @param data {const char*} xml ʽַ
	 *  xml ַҲǲֵ xml ַҲǿָ룬
	 *  ΣûȻòֻ xml ַ update
	 *  ڵ update н xmlʵ캯
	 *   data ǿʱҲ update
	 */
	xml(const char* data = NULL);
	~xml(void);

	xml& part_word(bool on);
	xml& ignore_slash(bool on);

	/**
	 * ʽʽѭñ XML ݣҲһ
	 *  XML ݣظʹø XML  XML
	 * Ӧڽһ XML ǰ reset() 
	 * һεĽ
	 * @param data {const char*} xml 
	 */
	void update(const char* data);

	/**
	 *  XML ״̬ XML Զ XML 
	 * нڷʹñ XML ǰҪñ
	 * ڲ XML ״̬һεĽ
	 */
	void reset(void);

	/**
	 * ӽ XML ԭʼнȡı
	 * @return {const string&} ؽã
	 *  ûҪͷ
	 */
	const string& getText(void);

	/**
	 *  XML ȡĳǩн㼯
	 * @param tag {const char*} ǩ(ִСд)
	 * @return {const std::vector<xml_node*>&} ؽĶã
	 *  ѯΪգüΪգempty() == true
	 *  עصе xml_node ݿ޸ģɾý㣬
	 *  ΪÿڲԶɾĻ
	 */
	const std::vector<xml_node*>& getElementsByTagName(const char* tag) const;

	/**
	 *  xml лöӦǩĵһ xml 
	 * @param tag {const char*} ǩ(ִСд)
	 * @return {const xml_node*} ؿձñǩӦ xml 㲻
	 */
	const xml_node* getFirstElementByTag(const char* tag) const;

	/**
	 *  xml ле༶ǩͬ xml ļ
	 * @param tags {const char*} ༶ǩ '/' ָǩ xml ݣ
	 *  <root> <first> <second> <third name="test1"> text1 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test2"> text2 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test3"> text3 </third> </second> </first> ...
	 *  ͨ༶ǩroot/first/second/third һԲзĽ
	 * @return {const std::vector<xml_node*>&}  xml 㼯, 
	 *  ѯΪգüΪգempty() == true
	 *  עصе xml_node ݿ޸ģɾý㣬
	 *  ΪÿڲԶɾĻ
	 */
	const std::vector<xml_node*>& getElementsByTags(const char* tags) const;

	/**
	 *  xml лָ༶ǩĵһ xml 
	 * @param tags {const char*} ༶ǩ '/' ָǩ xml ݣ
	 *  <root> <first> <second> <third name="test1"> text1 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test2"> text2 </third> </second> </first> ...
	 *  <root> <first> <second> <third name="test3"> text3 </third> </second> </first> ...
	 *  ͨ༶ǩroot/first/second/third һԲзĽ
	 * @return {const xml_node*} ؿձʾ
	 */
	const xml_node* getFirstElementByTags(const char* tags) const;

	/**
	 *  xml ле name ֵͬ xml Ԫؼ
	 * @param value {const char*} Ϊ name ֵ
	 * @return {const std::vector<xml_node*>&} ؽĶã
	 *  ѯΪգüΪգempty() == true
	 *  עصе xml_node ݿ޸ģɾý㣬
	 *  ΪÿڲԶɾĻ
	 */
	const std::vector<xml_node*>& getElementsByName(const char* value) const;

	/**
	 *  xml лиֵ xml Ԫؼ
	 * @param name {const char*} 
	 * @param value {const char*} ֵ
	 * @return {const std::vector<xml_node*>&} ؽĶã
	 *  ѯΪգüΪգempty() == true
	 */
	const std::vector<xml_node*>& getElementsByAttr(
		const char* name, const char* value) const;

	/**
	 *  xml лָ id ֵ xml Ԫ
	 * @param id {const char*} id ֵ
	 * @return {const xml_node*} xml Ԫ,  NULL ʾûз
	 *   xml , ֵҪͷ
	 */
	const xml_node* getElementById(const char* id) const;

	/**
	 * ȡ acl е ACL_XML 
	 * @return {ACL_XML*} ֵΪգעû޸ĸöֵ
	 *  ͷŸö
	 */
	ACL_XML* get_xml(void) const;

	/**
	 * һ xml_node 
	 * @param tag {const char*} ǩ
	 * @param text {const char*} ıַ
	 * @return {xml_node*} ² xml_node ҪûֹͷţΪ
	 *  xml ͷʱЩԶͷţȻûҲڲʱ
	 *  reset ͷЩ xml_node 
	 */
	xml_node& create_node(const char* tag, const char* text = NULL);

	/**
	 * һ xml_node 
	 * @param tag {const char*} ǩ
	 * @param number {long long int} 64 λ
	 * @return {xml_node*} ² xml_node ҪûֹͷţΪ
	 *  xml ͷʱЩԶͷţȻûҲڲʱ
	 *  reset ͷЩ xml_node 
	 */
#if defined(_WIN32) || defined(_WIN64)
	xml_node& create_node(const char* tag, __int64 number);
#else
	xml_node& create_node(const char* tag, long long int number);
#endif

	/**
	 * ø󣬵Ҫע⣬ýΪ㣬治κݣ
	 *  xml 㸸
	 * @return {xml_node&}
	 */
	xml_node& get_root();

	/**
	 * ʼ xml 󲢻õһ
	 * @return {xml_node*} ؿձʾ xml Ϊս
	 *  עصĽûֹͷţΪö
	 *  ڲԶͷ
	 */
	xml_node* first_node(void);

	/**
	 *  xml һ xml 
	 * @return {xml_node*} ؿձʾ
	 *  עصĽûֹͷţΪö
	 *  ڲԶͷ
	 */
	xml_node* next_node(void);

	/**
	 *  xml תַ
	 * @param out {string&} 洢תĻ
	 */
	void build_xml(string& out);

	// pipe_stream 麯

	virtual int push_pop(const char* in, size_t len,
		string* out, size_t max = 0);
	virtual int pop_end(string* out, size_t max = 0);
	virtual void clear(void);

private:
	ACL_XML *xml_;
	xml_node* root_;
	std::vector<xml_node*> elements_;
	string* buf_;
	//bool dummyRootAdded_;

	ACL_TOKEN* m_pTokenTree;
	std::list<xml_node*> nodes_tmp_;
	ACL_ITER* iter_;
};

} // namespace acl
