#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <list>
#include <vector>
#include "acl_cpp/stdlib/pipe_stream.hpp"

struct ACL_JSON_NODE;
struct ACL_JSON;
struct ACL_ITER;

/**
 *  ACL  json ķװ C++ ûʹã̫עأ
 * ֱʹø࣬ڷִҷǳעܣֱʹ ACL 
 * json ΪҲǵ ACL е json ̣жο
 * ̣ܻ΢ӰһЩܣһӦӰ΢
 */

namespace acl {

class string;
class json;

/**
 * json 㣬 json.create_node() ʽ
 */
class ACL_CPP_API json_node
{
public:
	/**
	 * ȡñ json ıǩ
	 * @return {const char*}  json ǩؿգ˵
	 *  ҪжϷֵ
	 */
	const char* tag_name(void) const;

	/**
	 * ظ json ıǩֵֵΪͻֵʱ߿
	 * нת
	 * @return {const char*} ؿ˵ûıǩֵ
	 */
	const char* get_text(void) const;

	/**
	 *  json ӽʱر json ǩӦ json ӽ
	 * @param {const json_node*}  NULL ˵ӽ
	 *  עget_text  get_obj ͬʱط NULL
	 */
	json_node* get_obj(void) const;

	/**
	 *  json бǩʱµıǩֵǾɵıǩ
	 * @param name {const char*} µıǩֵΪǿַ
	 * @return {bool}  false ʾýûбǩմûн滻
	 */
	bool set_tag(const char* name);

	/**
	 *  json ΪҶʱ滻ıֵ
	 * @param text {const char*} µҶıֵΪǿַ
	 * @return {bool}  false ʾýҶǷ
	 */
	bool set_text(const char* text);

	/**
	 * ǰ json ת json ַ( json 㼰ӽ)
	 * @return {const char*}
	 */
	const string& to_string(void);

	/**
	 *  json  json_node ӽ
	 * @param child {json_node*} ӽ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {json_node&} return_child Ϊ true ʱӽã
	 *  򷵻ر json 
	 */
	json_node& add_child(json_node* child, bool return_child = false);

	/**
	 *  json  json_node ӽ
	 * @param child {json_node&} ӽ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {json_node&} return_child Ϊ true ʱӽã
	 *  򷵻ر json 
	 */
	json_node& add_child(json_node& child, bool return_child = false);

	/**
	 * һ json 󣬲֮Ϊ json ӽ
	 * @param as_array {bool} Ƿ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {json_node&} return_child Ϊ true ʱ½ã
	 *  򷵻ر json 
	 */
	json_node& add_array(bool return_child = false);
	json_node& add_child(bool as_array = false, bool return_child = false);

	/**
	 * һַ͵ json 󣬲֮Ϊ json ӽ
	 * @param tag {const char*} ǩ
	 * @param value {const char*} ǩֵ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {json_node&} return_child Ϊ true ʱ½ã
	 *  򷵻ر json 
	 * ע˴ add_text  add_child ͬĹ
	 */
	json_node& add_text(const char* tag, const char* value,
		bool return_child = false);

	json_node& add_child(const char* tag, const char* value,
		bool return_child = false);

	/**
	 * һint64 ͵ json 󣬲֮Ϊ json ӽ
	 * @param tag {const char*} ǩ
	 * @param value {int64} ǩֵ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {json_node&} return_child Ϊ true ʱ½ã
	 *  򷵻ر json 
	 */
#if defined(_WIN32) || defined(_WIN64)
	json_node& add_number(const char* tag, __int64 value,
		bool return_child = false);
#else
	json_node& add_number(const char* tag, long long int value,
		bool return_child = false);
#endif

	/**
	 * һ͵ json 󣬲֮Ϊ json ӽ
	 * @param tag {const char*} ǩ
	 * @param value {bool} ǩֵ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {json_node&} return_child Ϊ true ʱ½ã
	 *  򷵻ر json 
	 */
	json_node& add_bool(const char* tag, bool value,
		bool return_child = false);

	/**
	 * һ json ַ󣬲֮Ϊ json ӽ
	 * @param text {const char*} ıַ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {json_node&} return_child Ϊ true ʱ½ã
	 *  򷵻ر json 
	 */
	json_node& add_array_text(const char* text, bool return_child = false);

	ACL_CPP_DEPRECATED_FOR("add_text")
	json_node& add_child(const char* text, bool return_child = false);

	/**
	 * һ json ֶ󣬲֮Ϊ json ӽ
	 * @param value {acl_int64} ֵ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {json_node&} return_child Ϊ true ʱ½ã
	 *  򷵻ر json 
	 */
#if defined(_WIN32) || defined(_WIN64)
	json_node& add_array_number(__int64 value, bool return_child = false);
#else
	json_node& add_array_number(long long int value, bool return_child = false);
#endif

	/**
	 * һ json 󣬲֮Ϊ json ӽ
	 * @param value {bool} ֵ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {json_node&} return_child Ϊ true ʱ½ã
	 *  򷵻ر json 
	 */
	json_node& add_array_bool(bool value, bool return_child = false);

	/**
	 * һ json 󣬲֮Ϊ json ӽ
	 * @param tag {const char*} ǩ
	 * @param node {json_node*} ǩֵָ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {json_node&} return_child Ϊ true ʱ½ã
	 *  򷵻ر json 
	 */
	json_node& add_child(const char* tag, json_node* node,
		bool return_child = false);

	/**
	 * һ json 󣬲֮Ϊ json ӽ
	 * @param tag {const char*} ǩ
	 * @param node {json_node&} ǩֵ
	 * @param return_child {bool} ǷҪ´ӽ
	 * @return {json_node&} return_child Ϊ true ʱ½ã
	 *  򷵻ر json 
	 */
	json_node& add_child(const char* tag, json_node& node,
		bool return_child = false);

	/**
	 * @return {json_node&} رĸ
	 */
	json_node& get_parent(void) const;

	/**
	 * ñĵһӽ㣬Ҫӽʱȵô˺
	 * @return {json_node*} ؿձʾûӽ㣬صķǿն
	 *  ⲿ deleteΪڲԶͷ
	 */
	json_node* first_child(void);

	/**
	 * ñһӽ
	 * @return {json_node*} ؿձʾ̽صķǿն
	 *  ⲿ deleteΪڲԶͷ
	 */
	json_node* next_child(void);

	/**
	 * ظ json  json е
	 * @return {int}
	 */
	int   depth(void) const;

	/**
	 * ظ json һӽĸ
	 * @return {int} Զ >= 0
	 */
	int   children_count(void) const;

	/**
	 * ڱ json ʱڲᶯ̬һЩʱ json_node 󣬵ô˺
	 * Щһô˺ first_child/next_child
	 * ص json_node 󽫲ٿãڴǷ
	 */
	void clear();

	/**
	 *  json 
	 * @return {json&}
	 */
	json& get_json(void) const;

	/**
	 * ȡӦ ACL е json 
	 * @return {ACL_JSON_NODE*} ؽעýûܵͷ
	 */
	ACL_JSON_NODE* get_json_node() const;

private:
	friend class json;
	/**
	 * 캯Ҫöֻ json 󴴽
	 * @param node {ACL_JSON_NODE*} ACL е ACL_JSON_NODE ṹ
	 */
	json_node(ACL_JSON_NODE* node, json* json_ptr);

	/**
	 * ҪöǶ̬
	 */
	~json_node(void);

	/**
	 *  json 
	 * @param node {ACL_JSON_NODE*}
	 */
	void set_json_node(ACL_JSON_NODE* node);

private:
	ACL_JSON_NODE* node_me_;
	json* json_;
	json_node* parent_;
	json_node* parent_saved_;
	std::vector<json_node*>* children_;
	ACL_ITER* iter_;
	string* buf_;
	json_node* obj_;

	void prepare_iter();
};

class ACL_CPP_API json : public pipe_stream
{
public:
	/**
	 * 캯ڽ json ַ json 
	 * @param data {const char*} json ʽַ
	 *  json ַҲǲֵ json ַҲǿָ룬
	 *  ΣûȻòֻ json ַ update
	 *  ڵ update н jsonʵ캯
	 *   data ǿʱҲ update
	 */
	json(const char* data = NULL);

	/**
	 * һ json еһ json 㹹һµ json 
	 * @param node {const json_node&} Դ json еһ json 
	 */
	json(const json_node& node);

	~json(void);

	/**
	 * ǷڽʱԶֵ
	 * @param on {bool}
	 * @return {json&}
	 */
	json& part_word(bool on);

	/**
	 * ʽʽѭñ json ݣҲһ
	 *  json ݣظʹø json  json
	 * Ӧڽһ json ǰ reset() 
	 * һεĽ
	 * @param data {const char*} json 
	 */
	void update(const char* data);

	/**
	 *  json ״̬ json Զ json 
	 * нڷʹñ json ǰҪñ
	 * ڲ json ״̬һεĽ
	 */
	void reset(void);

	/**
	 *  json ȡĳǩн㼯
	 * @param tag {const char*} ǩ(ִСд)
	 * @return {const std::vector<json_node*>&} ؽĶã
	 *  ѯΪգüΪգempty() == true
	 *  עصе json_node ݿ޸ģɾý㣬
	 *  ΪÿڲԶɾĻ
	 */
	const std::vector<json_node*>& getElementsByTagName(const char* tag) const;

	/**
	 *  json ле༶ǩͬ json ļ
	 * @param tags {const char*} ༶ǩ '/' ָǩ
	 *   json ݣ
	 *  { 'root': [
	 *      'first': { 'second': { 'third': 'test1' } },
	 *      'first': { 'second': { 'third': 'test2' } },
	 *      'first': { 'second': { 'third': 'test3' } }
	 *    ]
	 *  }
	 *  ͨ༶ǩroot/first/second/third һԲз
	 *  Ľ
	 * @return {const std::vector<json_node*>&}  json 㼯, 
	 *  ѯΪգüΪգempty() == true
	 *  עصе json_node ݿ޸ģɾý㣬
	 *  ΪÿڲԶɾĻ
	 */
	const std::vector<json_node*>& getElementsByTags(const char* tags) const;

	/**
	 * ȡ acl е ACL_JSON 
	 * @return {ACL_JSON*} ֵΪգעû޸ĸöֵ
	 *  ͷŸö
	 */
	ACL_JSON* get_json(void) const;

	/**
	 * һ json_node Ҷ󣬸ýĸʽΪ
	 * "tag_name": "tag_value"
	 * @param tag {const char*} ǩ
	 * @param value {const char*} ǩֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node 
	 */
	json_node& create_node(const char* tag, const char* value);

	/**
	 * һ json_node Ҷ󣬸ýĸʽΪ
	 * "tag_name": tag_value
	 * @param tag {const char*} ǩ
	 * @param value {int64} ǩֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node 
	 */
#if defined(_WIN32) || defined(_WIN64)
	json_node& create_node(const char* tag, __int64 value);
#else
	json_node& create_node(const char* tag, long long int value);
#endif

	/**
	 * һ json_node Ҷ󣬸ýĸʽΪ
	 * "tag_name": true|false
	 * @param tag {const char*} ǩ
	 * @param value {bool} ǩֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node 
	 */
	json_node& create_node(const char* tag, bool value);

	/**
	 * һ json_node Ҷַ󣬸ýĸʽΪ"string"
	 *  json 淶ýֻܼ
	 * @param text {const char*} ıַ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node 
	 */
	json_node& create_array_text(const char* text);

	ACL_CPP_DEPRECATED_FOR("create_array_text")
	json_node& create_node(const char* text);

	/**
	 * һ json_node Ҷֵ
	 *  json 淶ýֻܼ
	 * @param value {acl_int64} ֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩԶͷţȻûҲ
	 * ʱ reset ͷЩ json_node 
	 */
#if defined(_WIN32) || defined(_WIN64)
	json_node& create_array_number(__int64 value);
#else
	json_node& create_array_number(long long int value);
#endif

	/**
	 * һ json_node Ҷ㲼
	 *  json 淶ýֻܼ
	 * @param value {bool} ֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩԶͷţȻûҲ
	 * ʱ reset ͷЩ json_node 
	 */
	json_node& create_array_bool(bool value);

	/**
	 * һ json_node 󣬸öûбǩ,
	 * ýĸʽΪ"{}"  "[]"
	 * @param as_array {bool} Ƿ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node 
	 */
	json_node& create_node(bool as_array = false);
	json_node& create_array();

	/**
	 * һ json_node 󣬸ýĸʽΪtag_name: {}
	 *  tag_name: []
	 * @param tag {const char*} ǩ
	 * @param node {json_node*} json Ϊǩֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node 
	 */
	json_node& create_node(const char* tag, json_node* node);

	/**
	 * һ json_node 󣬸ýĸʽΪtag_name: {}
	 *  tag_name: []
	 * @param tag {const char*} ǩ
	 * @param node {json_node&} json Ϊǩֵ
	 * @return {json_node&} ² json_node Ҫûֹͷţ
	 *  Ϊ json ͷʱЩԶͷţȻûҲ
	 *  ʱ reset ͷЩ json_node 
	 */
	json_node& create_node(const char* tag, json_node& node);

	/**
	 * һ json еһ json 㸴һ json еһ
	 *  json вظµ json 
	 * @param node {json_node*} Դ json һ json 
	 * @return {json_node&} ǰĿ json ´ json 
	 */
	json_node& duplicate_node(const json_node* node);

	/**
	 * һ json еһ json 㸴һ json еһ
	 *  json вظµ json 
	 * @param node {json_node&} Դ json һ json 
	 * @return {json_node&} ǰĿ json ´ json 
	 */
	json_node& duplicate_node(const json_node& node);

	/**
	 * ø
	 * @return {json_node&}
	 */
	json_node& get_root();

	/**
	 * ʼ json 󲢻õһ
	 * @return {json_node*} ؿձʾ json Ϊս
	 *  עصĽûֹͷţΪö
	 *  ڲԶͷ
	 */
	json_node* first_node(void);

	/**
	 *  json һ json 
	 * @return {json_node*} ؿձʾ
	 *  עصĽûֹͷţΪö
	 *  ڲԶͷ
	 */
	json_node* next_node(void);

	/**
	 *  json תַ
	 * @param out {string&} 洢תĻ
	 */
	void build_json(string& out);

	/**
	 *  json ת json ַ
	 * @return {const string&}
	 */
	const string& to_string();

	// pipe_stream 麯

	virtual int push_pop(const char* in, size_t len,
		string* out, size_t max = 0);
	virtual int pop_end(string* out, size_t max = 0);
	virtual void clear(void);

private:
	// Ӧ acl е ACL_JSON 
	ACL_JSON *json_;
	// json еĸ
	json_node* root_;
	// ʱ json ѯ
	std::vector<json_node*> nodes_query_;
	// ɸ json  json 㼯
	std::list<json_node*> nodes_tmp_;
	// 
	string* buf_;
	ACL_ITER* iter_;
};

} // namespace acl
