#pragma once
#include "acl_cpp/acl_cpp_define.hpp"

struct ACL_DBUF_POOL;

namespace acl
{

/**
 * ڴ࣬ṩڴ亯ʱڴᱻһԵͷţ
 * ʺҪƵһЩСȵСڴӦã
 * ʵǷװ lib_acl е ACL_DBUF_POOL ṹ
 */
class ACL_CPP_API dbuf_pool
{
public:
	/**
	 * 붯̬
	 */
	dbuf_pool();

	/**
	 * Ҫ̬ʹҪ destroy
	 * ٶ̬
	 */
	void destroy();

	/**
	 *  new/delete  new dbuf_pool ʱʹ֮ڴϣ
	 * Ӷ malloc/free Ĵ
	 */
	void *operator new(size_t size);
	void operator delete(void* ptr);

	/**
	 * ڴص״̬Աظʹøڴض
	 */
	void dbuf_reset();

	/**
	 * ָȵڴ
	 * @param len {size_t} Ҫڴ泤ȣڴȽСʱ(Сڹ캯е
	 *  block_size)ʱڴ dbuf_pool ڴϣڴϴʱ
	 *  ֱʹ malloc з
	 * @return {void*} ·ڴַ
	 */
	void* dbuf_alloc(size_t len);

	/**
	 * ָȵڴ沢ڴ
	 * @param len {size_t} Ҫڴ泤
	 * @return {void*} ·ڴַ
	 */
	void* dbuf_calloc(size_t len);

	/**
	 * ַ̬µڴ沢ַڴиƣ strdup
	 * @param s {const char*} Դַ
	 * @return {char*} ¸Ƶַַ
	 */
	char* dbuf_strdup(const char* s);

	/**
	 * ڴݶ̬ڴ沢ݽи
	 * @param s {const void*} Դڴַ
	 * @param len {size_t} Դݳ
	 * @return {void*} ¸Ƶݵַ
	 */
	void* dbuf_memdup(const void* s, size_t len);

private:
	ACL_DBUF_POOL* pool_;
	size_t mysize_;

	~dbuf_pool();
};

} // namespace acl
