#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/db/db_handle.hpp"

typedef struct st_mysql MYSQL;

namespace acl {

class ACL_CPP_API db_mysql : public db_handle
{
public:
	db_mysql(const char* dbaddr, const char* dbname,
		const char* dbuser, const char* dbpass,
		unsigned long dbflags = 0, bool auto_commit = true,
		int conn_timeout = 60, int rw_timeout = 60);
	~db_mysql(void);

	/**
	 *  mysql ͻ˿İ汾
	 * @return {unsigned long}
	 */
	unsigned long mysql_libversion() const;

	/**
	 *  mysql ͻ˿Ϣ
	 * @return {const char*}
	 */
	const char* mysql_client_info() const;

	/**
	 * ֱӻ mysql Ӿ NULL ʾ mysql ûд
	 * ʱڲԶر mysql 
	 * @return {MYSQL*}
	 */
	MYSQL* get_conn() const
	{
		return conn_;
	}

	/********************************************************************/
	/*         Ϊ db_handle ӿ                            */
	/********************************************************************/

	/**
	 * ݿ
	 * @return {const char*}
	 */
	const char* dbtype() const;

	/**
	 * ϴݿĳ
	 * @return {int}
	 */
	int get_errno() const;

	/**
	 * ϴݿĳ
	 * @return {const char*}
	 */
	const char* get_error() const;

	/**
	 *  db_handle Ĵӿ
	 * @param local_charset {const char*} ַ(gbk, utf8, ...)
	 * @return {bool} Ƿɹ
	 */
	bool dbopen(const char* local_charset);

	/**
	 *  db_handle ĴӿڣݿǷѾ
	 * @return {bool}  true ݿѾ
	 */
	bool is_opened() const;

	/**
	 *  db_handle Ĵӿ
	 * @return {bool} رǷɹ
	 */
	bool close(void);

	/**
	 *  db_handle Ĵӿڣʵִ˽ӿжݱǷ
	 * @return {bool} Ƿ
	 */
	bool tbl_exists(const char* tbl_name);

	/**
	 *  db_handle Ĵӿ
	 * @param sql {const char*} ׼ SELECT SQL 䣬ǿգһ
	 *  Ҫע SQL 뾭ת崦Էֹ SQL ע빥
	 * @return {bool} ִǷɹ
	 */
	bool sql_select(const char* sql);

	/**
	 *  db_handle Ĵӿ
	 * @param sql {const char*} ׼ INSERT/UPDATE/DELETE SQL 䣬
	 *  һҪע SQL 뾭ת崦Էֹ SQL ע빥
	 * @return {bool} ִǷɹ
	 */
	bool sql_update(const char* sql);

	/**
	 *  db_handle Ĵӿڣϴ sql Ӱļ¼
	 * @return {int} Ӱ-1 ʾ
	 */
	int affect_count() const;

	/**
	 *  db_handle 麯ʾĿʼעҪʹʽ
	 * Ҫ db_mysql Ĺ캯дĲ auto_commit Ϊ false
	 * @return {bool}
	 */
	bool begin_transaction();

	/**
	 *  db_handle 麯ʾĽ
	 * @return {bool}
	 */
	bool commit();

private:
	char* dbaddr_;  // ݿַ
	char* dbname_;  // ݿ
	char* dbuser_;  // ݿ˺
	char* dbpass_;  // ݿ˺

	unsigned long dbflags_;
	int   conn_timeout_;
	int   rw_timeout_;
	bool  auto_commit_;
	MYSQL* conn_;

	bool sane_mysql_query(const char* sql);
};

} // namespace acl
