#ifndef ACL_XML_INCLUDE_H
#define ACL_XML_INCLUDE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdlib/acl_array.h"
#include "stdlib/acl_ring.h"
#include "stdlib/acl_vstream.h"
#include "stdlib/acl_htable.h"
#include "stdlib/acl_vstring.h"
#include "stdlib/acl_iterator.h"
#include "stdlib/acl_slice.h"

typedef struct ACL_XML	ACL_XML;
typedef struct ACL_XML_NODE	ACL_XML_NODE;
typedef struct ACL_XML_ATTR	ACL_XML_ATTR;

struct ACL_XML_ATTR {
	ACL_XML_NODE *node;         /**<  */
	ACL_VSTRING *name;          /**<  */
	ACL_VSTRING *value;         /**< ֵ */

	/* private */
	int   quote;                /**<  0 ʾ '  " */
	int   backslash;            /**< תַ \ */
	int   part_word;            /**< ֵ־λ */
	int   slash;                /**< Ƿ '/' ־λ趨 */
};

struct ACL_XML_NODE {
	ACL_VSTRING *ltag;          /**< ǩ */
	ACL_VSTRING *rtag;          /**< ұǩ */
	const ACL_VSTRING *id;      /**< IDʶ, ֻ xml->id_table ڵĽ id ŷǿ */
	ACL_VSTRING *text;          /**< ıʾ */
	ACL_ARRAY *attr_list;       /**< (ACL_XML_ATTR)б */
	ACL_XML_NODE *parent;       /**<  */
	ACL_RING children;          /**< ӽ㼯 */
	int  depth;                 /**< ǰ */

	/* private */
	ACL_XML *xml;               /**< xml  */
	ACL_RING node;              /**< ǰ */
	ACL_XML_ATTR *curr_attr;    /**< ǰڽ */
	int   quote;                /**<  0 ʾ '  " */
	int   last_ch;              /**< ¼ǰһֵֽ */
	int   nlt;                  /**< '<'  */
	char  meta[3];              /**< Ԫʱ */
	unsigned int flag;
#define	ACL_XML_F_META_QM	(1 << 0)    /**< '?' flag */
#define	ACL_XML_F_META_CM	(1 << 1)    /**< '!--' flag */
#define	ACL_XML_F_META_EM	(1 << 2)    /**< only '!' flag */
#define ACL_XML_F_SELF_CL	(1 << 3)    /**< self closed flag */
#define	ACL_XML_F_LEAF		(1 << 4)    /**< leaf node has no child node */

/**< ǷԪ */
#define	ACL_XML_F_META		\
	(ACL_XML_F_META_QM | ACL_XML_F_META_CM | ACL_XML_F_META_EM)

	int   status;               /**< ״̬ǰ״̬ */
#define ACL_XML_S_NXT	0       /**< һ */
#define ACL_XML_S_LLT	1       /**<  '<' */
#define ACL_XML_S_LGT	2       /**< ұ '>' */
#define	ACL_XML_S_LCH	3       /**<  '<' һֽ */
#define ACL_XML_S_LEM	4       /**<  '<'  '!' */
#define ACL_XML_S_LTAG	5       /**< ߵıǩ */
#define ACL_XML_S_RLT	6       /**< ұߵ '<' */
#define ACL_XML_S_RGT	7       /**< ұߵ '>' */
#define ACL_XML_S_RTAG	8       /**< ұߵıǩ */
#define ACL_XML_S_ATTR	9       /**< ǩ */
#define ACL_XML_S_AVAL	10      /**< ǩֵ */
#define ACL_XML_S_TXT	11      /**< ı */
#define ACL_XML_S_MTAG	12      /**< Ԫݱǩ */
#define ACL_XML_S_MTXT	13      /**< Ԫı */
#define ACL_XML_S_MCMT	14      /**< Ԫע */
#define ACL_XML_S_MEND	15      /**< Ԫݽ */

	/* public: for acl_iterator, ͨ acl_foreach гýһӽ */

	/* ȡͷ */
	ACL_XML_NODE *(*iter_head)(ACL_ITER*, ACL_XML_NODE*);
	/* ȡһ */
	ACL_XML_NODE *(*iter_next)(ACL_ITER*, ACL_XML_NODE*);
	/* ȡβ */
	ACL_XML_NODE *(*iter_tail)(ACL_ITER*, ACL_XML_NODE*);
	/* ȡһ */
	ACL_XML_NODE *(*iter_prev)(ACL_ITER*, ACL_XML_NODE*);
};

struct ACL_XML {
	/* public */
	int   depth;                /**<  */
	int   node_cnt;             /**< ,  root  */
	ACL_XML_NODE *root;         /**< XML  */

	/* private */
	ACL_HTABLE *id_table;       /**< id ʶϣ */
	ACL_XML_NODE *curr_node;    /**< ǰڴ XML  */
	ACL_SLICE_POOL *slice;      /**< ڴض */

	ACL_ARRAY *node_cache;      /**< XML㻺 */
	int   max_cache;            /**< XML㻺ص */
	unsigned flag;              /**< ־λ: ACL_XML_FLAG_xxx */ 
#define	ACL_XML_FLAG_PART_WORD		(1 << 0) /**< ǷݺΪת '\'  */
#define	ACL_XML_FLAG_IGNORE_SLASH	(1 << 1) /**< Ƿݵû '/'  */

	/* public: for acl_iterator, ͨ acl_foreach гӽ */

	/* ȡͷ */
	ACL_XML_NODE *(*iter_head)(ACL_ITER*, ACL_XML*);
	/* ȡһ */
	ACL_XML_NODE *(*iter_next)(ACL_ITER*, ACL_XML*);
	/* ȡβ */
	ACL_XML_NODE *(*iter_tail)(ACL_ITER*, ACL_XML*);
	/* ȡһ */
	ACL_XML_NODE *(*iter_prev)(ACL_ITER*, ACL_XML*);
};

#define	ACL_XML_IS_COMMENT(x)	(((x)->flag & ACL_XML_F_META_CM))

/***************************************************************************/
/*                  ӿڣûԷʹøýӿڼ                 */
/***************************************************************************/

/*----------------------------- in acl_xml.c ------------------------------*/

/**
 * ж xml Ƿպϵ, ǷǷ,  xml 
 * xml ԪΪ, ҲΪǱպϵ
 * @param xml {ACL_XML*} xml 
 * @return {int} 0: ; 1: 
 */
ACL_API int acl_xml_is_closure(ACL_XML *xml);

/**
 * ָıǩж xml Ѿ, ñǩ xml  root һӽ
 * еһ xml ıǩͬʱ, Ϊ xml , Ϊ˱֤жϵȷ,
 * ԴӦ֤ĸֻһ,  xml->root һӽֻһ, 
 * 
 * @param xml {ACL_XML*} xml 
 * @param tag {const char*} ûǩ, ڲƥʱִСд
 * @return {int} 0: ; 1: 
 */
ACL_API int acl_xml_is_complete(ACL_XML *xml, const char *tag);

/**
 * һ xml 
 * @return {ACL_XML*} ´ xml 
 */
ACL_API ACL_XML *acl_xml_alloc(void);

/**
 * һ xml 󣬸 xml еڲڴ䶼ڸڴϽз
 * @param slice {ACL_SLICE_POOL*} ڴض󣬿Ϊָ룬ڴ
 * @return {ACL_XML*} ´ xml 
 */
ACL_API ACL_XML *acl_xml_alloc1(ACL_SLICE_POOL *slice);

/**
 * ĳһ ACL_XML_NODE Ϊһ XML ĸ㣬ӶԷر
 * ĸӽ(ڱен㲻)ñʽбڵ
 * ĳһ ACL_XML_NODE ʱܱһӽ
 * @param xml {ACL_XML*} xml 
 * @param node {ACL_XML_NODE*} AXL_XML_NODE 
 */
ACL_API void acl_xml_foreach_init(ACL_XML *xml, ACL_XML_NODE *node);

/**
 *  XML , Ƿû /, :
 * <test id=111>, <test id=111 />, û / д
 * ǺϷģֻеڶдǺϷģּԣ
 * һʧ
 * @param xml {ACL_XML*} xml 
 * @param ignore {int}  0 ʾ /
 */
ACL_API void acl_xml_slash(ACL_XML *xml, int ignore);

/**
 * 򿪻رXMLĻ湦ܣ ACL_XML ʱXMLĽ㻺湦Ч
 * @param xml {ACL_XML*} xml 
 * @param max_cache {int} ֵֵ > 0 ʱ xml  xml 
 *  湦ܣر xml  xml Ļ湦
 */
ACL_API void acl_xml_cache(ACL_XML *xml, int max_cache);

/**
 * ͷ XML  XML 
 * @param xml {ACL_XML*} xml 
 */
ACL_API void acl_xml_cache_free(ACL_XML *xml);

/**
 * ͷһ xml , ͬʱͷŸöɵ xml 
 * @param xml {ACL_XML*} xml 
 */
ACL_API int acl_xml_free(ACL_XML *xml);

/**
 *  XML 
 * @param xml {ACL_XML*} xml 
 */
ACL_API void acl_xml_reset(ACL_XML *xml);

/*------------------------- in acl_xml_parse.c ----------------------------*/

/**
 *  xml , Զ xml 
 * @param xml {ACL_XML*} xml 
 * @param data {const char*}  '\0' βַ,  xml ;
 *  Ҳǲ xml , ѭô˺, ݳ
 */
ACL_API void acl_xml_update(ACL_XML *xml, const char *data);
#define	acl_xml_parse	acl_xml_update

/*------------------------- in acl_xml_util.c -----------------------------*/

/**
 * ʼ input, br, hr ȵԱպϱǩ, γԱպϱǩ, Ա
 * acl_xml_tag_selfclosed ѯ, ǩǷǱԱպϱǩ,
 * úֻܱʼһ, ҲԲʼ
 */
ACL_API void acl_xml_tag_init(void);

/**
 * ûԼһЩԱպϵıǩ
 * @param tag {const char*} ǩעǩȲô 254 ֽ
 */
ACL_API void acl_xml_tag_add(const char *tag);

/**
 *  acl_xml_tag_init ʼԱպϱǩ, Եô˺ж
 * ǩǷԱպϱǩ, δ acl_xml_tag_init, úԶ 0
 * @parma tag {const char*} ǩ
 * @return {int} 0: ʾ, 1: ʾ
 */
ACL_API int  acl_xml_tag_selfclosed(const char *tag);

/**
 * жϱǩ xml ǷҶ, Ҷûӽ
 * @param tag {const char*} ǩ
 * @return {int} 0: Ҷ; 1: Ҷ
 */
ACL_API int  acl_xml_tag_leaf(const char *tag);

/**
 * ͷ acl_xml_getElementsByTagName, acl_xml_getElementsByName,
 * acl_xml_getElementsByAttr ȺصĶ̬, Ϊö̬е
 * Ԫض ACL_XML Ԫص, ͷŵö̬, ֻҪ ACL_XML
 * ͷ, ԭڸеԪȻʹ.
 * ͷ xml Ԫ
 * @param a {ACL_ARRAY*} ̬
 */
ACL_API void acl_xml_free_array(ACL_ARRAY *a);

/**
 *  xml леǩͬ xml ļ
 * @param xml {ACL_XML*} xml 
 * @param tag {const char*} ǩ
 * @return {ACL_ARRAY*}  xml 㼯,  ̬,  NULL 
 *  ʾûз xml , ǿֵҪ acl_xml_free_array ͷ
 */
ACL_API ACL_ARRAY *acl_xml_getElementsByTagName(ACL_XML *xml, const char *tag);

/**
 *  xml ле༶ǩͬ xml ļ
 * @param xml {ACL_XML*} xml 
 * @param tags {const char*} ༶ǩ '/' ָǩ xml ݣ
 *  <root> <first> <second> <third name="test1"> text1 </third> </second> </first>
 *  <root> <first> <second> <third name="test2"> text2 </third> </second> </first>
 *  <root> <first> <second> <third name="test3"> text3 </third> </second> </first>
 *  ͨ༶ǩroot/first/second/third һԲзĽ
 * @return {ACL_ARRAY*}  xml 㼯,  ̬,  NULL 
 *  ʾûз xml , ǿֵҪ acl_xml_free_array ͷ
 */
ACL_API ACL_ARRAY *acl_xml_getElementsByTags(ACL_XML *xml, const char *tags);

/**
 *  xml ле name ֵͬ xml Ԫؼ
 * @param xml {ACL_XML*} xml 
 * @param value {const char*} Ϊ name ֵ
 * @return {ACL_ARRAY*}  xml 㼯,  ̬,  NULL 
 *  ʾûз xml , ǿֵҪ acl_xml_free_array ͷ
 */
ACL_API ACL_ARRAY *acl_xml_getElementsByName(ACL_XML *xml, const char *value);

/**
 *  xml лиֵ xml Ԫؼ
 * @param xml {ACL_XML*} xml 
 * @param name {const char*} 
 * @param value {const char*} ֵ
 * @return {ACL_ARRAY*}  xml 㼯,  ̬,  NULL 
 *  ʾûз xml , ǿֵҪ acl_xml_free_array ͷ
 */
ACL_API ACL_ARRAY *acl_xml_getElementsByAttr(ACL_XML *xml,
	const char *name, const char *value);

/**
 *  xml лָ id ֵ xml ԪصĳԶ
 * @param xml {ACL_XML*} xml 
 * @param id {const char*} id ֵ
 * @return {ACL_XML_ATTR*} ĳ xml ĳԶ,  NULL ʾ
 *  ûз, ֵҪͷ
 */
ACL_API ACL_XML_ATTR *acl_xml_getAttrById(ACL_XML *xml, const char *id);

/**
 *  xml лָ id ֵ xml Ԫصĳֵ
 * @param xml {ACL_XML*} xml 
 * @param id {const char*} id ֵ
 * @return {const char*} ĳ xml ĳֵ,  NULL ʾûз
 *  
 */
ACL_API const char *acl_xml_getAttrValueById(ACL_XML *xml, const char *id);

/**
 *  xml лָ id ֵ xml Ԫ
 * @param xml {ACL_XML*} xml 
 * @param id {const char*} id ֵ
 * @return {ACL_XML_NODE*} xml Ԫ,  NULL ʾûз
 *   xml , ֵҪͷ
 */
ACL_API ACL_XML_NODE *acl_xml_getElementById(ACL_XML *xml, const char *id);

/**
 *  xml ȡ ? ! ȿͷĽ
 * @param xml {ACL_XML*} xml 
 * @param tag {const char*} ǩ
 * @return {ACL_XML_NODE*} xml Ԫ,  NULL ʾûз
 *   xml , ֵҪͷ
 */
ACL_API ACL_XML_NODE *acl_xml_getElementMeta(ACL_XML *xml, const char *tag);

/**
 *  xml ַʽ
 * @param xml {ACL_XML*} xml 
 * @return {const char*} ַʽ NULL ʱʾûи
 */
ACL_API const char *acl_xml_getEncoding(ACL_XML *xml);

/**
 *  xml ݵͣ磺text/xsl
 * @param xml {ACL_XML*} xml 
 * @return {const char*}  NULL ʾûи
 */
ACL_API const char *acl_xml_getType(ACL_XML *xml);

/**
 *  xml лָԶ
 * @param node {ACL_XML_NODE*} xml 
 * @param name {const char*} 
 * @return {ACL_XML_ATTR*} Զ, Ϊձʾ, ֵҪͷ
 */
ACL_API ACL_XML_ATTR *acl_xml_getElementAttr(ACL_XML_NODE *node, const char *name);

/**
 *  xml лֵָ
 * @param node {ACL_XML_NODE*} xml 
 * @param name {const char*} 
 * @return {const char*} ֵ, Ϊձʾ
 */
ACL_API const char *acl_xml_getElementAttrVal(ACL_XML_NODE *node, const char *name);

/**
 *  xml ɾĳԶ, Ϊ id , ͬʱ xml->id_table ɾ
 * @param node {ACL_XML_NODE*} xml 
 * @param name {const char*} 
 * @return {int} 0 ʾɾɹ, -1: ʾɾʧ(пǸԲ)
 */
ACL_API int acl_xml_removeElementAttr(ACL_XML_NODE *node, const char *name);

/**
 *  xml , Ѵ, µֵ滻ֵ, 
 * µԶ
 * @param node {ACL_XML_NODE*} xml 
 * @param name {const char*} 
 * @param value {const char*} ֵ
 * @return {ACL_XML_ATTR*} ظԶ(пԭ, Ҳпµ), 
 *  ֵͷ
 */
ACL_API ACL_XML_ATTR *acl_xml_addElementAttr(ACL_XML_NODE *node,
        const char *name, const char *value);

/**
 * ǩıΪ xml 㣬úҪڹ xml ʱ
 * @param xml {ACL_XML*} xml 󣬸öӦ acl_xml_alloc 
 * @param tagname {const char*} ǩǿַȴ 0
 * @param text {const char*} ıݣΪ
 * @return {ACL_XML_NODE*} ´ xml 㣬÷Զطǿգ
 *  ǷᵼڲԶ
 */
ACL_API ACL_XML_NODE *acl_xml_create_node(ACL_XML *xml,
	const char* tagname, const char* text);

/**
 * һ xml ԣúҪڹ xml ʱ
 * @param node {ACL_XML_NODE*}  acl_xml_create_node Ľ
 * @param name {const char*} Ϊǿַַȴ 0
 * @param value {const char*} ֵΪ
 * @return {ACL_XML_ATTR*} xml Զ󣬵Ƿʱú
 *  ڲԶ
 */
ACL_API ACL_XML_ATTR *acl_xml_node_add_attr(ACL_XML_NODE *node,
	const char *name, const char *value);

/**
 * һ xml һԣúҪڹ xml ʱ
 * @param node {ACL_XML_NODE*}  acl_xml_create_node Ľ
 * @param ... һԣ NULL ʱʾ磺
 *  {name1}, {value1}, {name2}, {value2}, ... NULL
 */
ACL_API void acl_xml_node_add_attrs(ACL_XML_NODE *node, ...);

/**
 * һ xml ıݣúҪڹ xml ʱ
 * @param node {ACL_XML_NODE*}  acl_xml_create_node Ľ
 * @param text {const char*} ı
 */
ACL_API void acl_xml_node_set_text(ACL_XML_NODE *node, const char *text);

/**
 *  xml תַ
 * @param xml {ACL_XML*} xml 
 * @param buf {ACL_VSTRING*} 洢ĻòΪʱڲ
 *  ԶһλӦҪͷŵǿպڲֱӽ洢
 * @return {ACL_VSTRING*} xml תַĴ洢÷ֵԶǿգ
 *  ʹ߿ͨ ACL_VSTRING_LEN(x) жǷΪգص ACL_VSTRING
 *  ָΪúڲģû acl_vstring_free ͷ
 */
ACL_API ACL_VSTRING* acl_xml_build(ACL_XML* xml, ACL_VSTRING *buf);

/**
 *  xml תָУעתϢΪõ
 * @param xml {ACL_XML*} xml 
 * @param fp {ACL_VSTREAM*} 
 */
ACL_API void acl_xml_dump(ACL_XML *xml, ACL_VSTREAM *fp);

/**
 *  xml תָУעתϢΪõ
 * @param xml {ACL_XML*} xml 
 * @param buf {ACL_VSTRING*} , ҪûԼռ
 */
ACL_API void acl_xml_dump2(ACL_XML *xml, ACL_VSTRING *buf);

/***************************************************************************/
/*          ΪΪͼĽӿ, ûԸҪ½ӿ             */
/***************************************************************************/

/*----------------------------- in acl_xml.c ------------------------------*/

/**
 *  xml 
 * @param node {ACL_XML_NODE*} xml 
 * @return {ACL_XML_ATTR*} ´Ľ
 */
ACL_API ACL_XML_ATTR *acl_xml_attr_alloc(ACL_XML_NODE *node);

/**
 * ͷ xml ռڴ, øúǰ, עѾ
 * Ľɾ
 * @param attr {ACL_XML_ATTR*} xml 
 */
ACL_API void acl_xml_attr_free(ACL_XML_ATTR *attr);

/**
 * һ xml 
 * @param xml {ACL_XML*} xml 
 * @return {ACL_XML_NODE*} xml 
 */
ACL_API ACL_XML_NODE *acl_xml_node_alloc(ACL_XML *xml);

/**
 * ĳ xml 㼰ӽ xml ɾ, ͷŸý㼰ӽռռ
 * ͷŸ xml ռڴ
 * @param node {ACL_XML_NODE*} xml 
 * @return {int} ɾĽ
 */
ACL_API int acl_xml_node_delete(ACL_XML_NODE *node);

/**
 * ĳ xml ֵܽ(ֵܽǶ xml )
 * @param node1 {ACL_XML_NODE*} 򱾽 xml 
 * @param node2 {ACL_XML_NODE*} ӵֵ xml 
 */
ACL_API void acl_xml_node_append(ACL_XML_NODE *node1, ACL_XML_NODE *node2);

/**
 * ĳ xml Ϊӽĳ xml 
 * @param parent {ACL_XML_NODE*} 
 * @param child {ACL_XML_NODE*} ӽ
 */
ACL_API void acl_xml_node_add_child(ACL_XML_NODE *parent, ACL_XML_NODE *child);

/**
 * ĳ xml ĸ
 * @param node {ACL_XML_NODE*} xml 
 * @return {ACL_XML_NODE*} , Ϊ NULL ʾ丸㲻
 */
ACL_API ACL_XML_NODE *acl_xml_node_parent(ACL_XML_NODE *node);

/**
 * ĳ xml ĺһֵܽ
 * @param node {ACL_XML_NODE*} xml 
 * @return {ACL_XML_NODE*}  xml ĺһֵܽ, ΪNULLʾ
 */
ACL_API ACL_XML_NODE *acl_xml_node_next(ACL_XML_NODE *node);

/**
 * ĳ xml ǰһֵܽ
 * @param node {ACL_XML_NODE*} xml 
 * @return {ACL_XML_NODE*}  xml ǰһֵܽ, ΪNULLʾ
 */
ACL_API ACL_XML_NODE *acl_xml_node_prev(ACL_XML_NODE *node);

#ifdef __cplusplus
}
#endif
#endif
