#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/connpool/connect_pool.hpp"

namespace acl
{

/**
 * redis ӳ̳࣬ connect_pool connect_pool ͨõй
 * TCP ӳصͨ÷
 * redis connection pool inherting from connect_pool, which includes
 * TCP connection pool methods.
 */
class ACL_CPP_API redis_client_pool : public connect_pool
{
public:
	/**
	 * 캯
	 * constructor
	 * @param addr {const char*} ˵ַʽip:port
	 *  the redis-server's listening address, format: ip:port
	 * @param count {size_t} ӳص
	 *  the max connections for each connection pool
	 * @param idx {size_t} ӳضڼе±λ( 0 ʼ)
	 *  the subscript of the connection pool in the connection cluster
	 */
	redis_client_pool(const char* addr, size_t count, size_t idx = 0);

	virtual ~redis_client_pool();

	/**
	 * ӳʱʱ估 IO дʱʱ()
	 * set the connect and read/write timeout in seconds
	 * @param conn_timeout {int} ӳʱʱ
	 *  the timeout to connect in seconds
	 * @param rw_timeout {int}  IO дʱʱ()
	 *  the timeout to read/write in seconds
	 * @return {redis_client_pool&}
	 */
	redis_client_pool& set_timeout(int conn_timeout, int rw_timeout);

protected:
	/**
	 * ി麯: ô˺һµ
	 * virtual function in class connect_pool to create a new connection
	 * @return {connect_client*}
	 */
	connect_client* create_connect();

private:
	int   conn_timeout_;
	int   rw_timeout_;
};

} // namespace acl
