#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <list>
#include <time.h>

namespace acl {

/**
 * ʼַ
 */
struct rfc822_addr
{
	char* addr;	// ʼַʽΪ xxx@xxx.xxx
	char* comment;	// ʼע
};

typedef enum
{
	tzone_gmt,
	tzone_cst
} tzone_t;

class ACL_CPP_API rfc822
{
public:
	rfc822();
	~rfc822();

	/**
	 *  RFC822 ׼ʱʽ
	 * @param in {const char*} ʱַ磺
	 *  Wed, 11 May 2011 09:44:37 +0800 (CST)
	 *  Wed, 11 May 2011 16:17:39 GMT
	 */
	time_t parse_date(const char *in);

	/**
	 * ɷ RFC822 ׼ʱʽ
	 * @param t {time_t}
	 * @param out {char*} 洢ת
	 * @param size {size_t} out ռС
	 * @param zone {tzone_t} ʱ
	 */
	void mkdate(time_t t, char* out, size_t size, tzone_t  zone = tzone_cst);

	/**
	 * ɶʱʽ
	 * @param t {time_t}
	 * @param out {char*} 洢ת
	 * @param size {size_t} out ռС
	 */
	void mkdate_cst(time_t t, char* out, size_t size);

	/**
	 * ɸʱʱʽ
	 * @param t {time_t}
	 * @param out {char*} 洢ת
	 * @param size {size_t} out ռС
	 */
	void mkdate_gmt(time_t t, char* out, size_t size);

	/**
	 * ʼַб RFC822 ׼ʼַб
	 * ʼַбͬʱûעͲֽ
	 * RFC2047
	 * @param in {const char*} RFC822 ʽʼַб:
	 *  "=?gb2312?B?1dSx+A==?= <zhaobing@51iker.com>;\r\n"
	 *  "\t\"=?GB2312?B?t+vBosn6?=\" <fenglisheng@51iker.com>;\r\n"
	 *  "\t\"zhengshuxin3\";\"zhengshuxin4\" <zhengshuxin2@51iker.com>;"
	 *  "<xuganghui@51iker.com>;<wangwenquan@51iker.com>;"
	 * @return {const std::list<rfc822_addr*>&} 
	 */
	const std::list<rfc822_addr*>& parse_addrs(const char* in);

	/**
	 * һ RFC822 ׼ʼַͬʱûעͲְ
	 * RFC2047 ׼н
	 * @param in {const char*} RFC822 ʽʼַ
	 * @return {const rfc822_addr*}  NULL ʼַ
	 *  RFC822 淶
	 */
	const rfc822_addr* parse_addr(const char* in);

	/**
	 * ʼַǷϷ
	 * @param in {const char*} RFC822 ʽʼַ
	 * @return {bool}
	 */
	bool check_addr(const char* in);

private:
	std::list<rfc822_addr*> addrs_;

	void reset();
};

} // namespace acl
