#ifndef ACL_TCP_CTL_INCLUDE_H
#define ACL_TCP_CTL_INCLUDE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdlib/acl_define.h"

#define ACL_SOCKET_RBUF_SIZE	204800  /**< ȱʡС */
#define ACL_SOCKET_WBUF_SIZE	204800  /**< ȱдС */

/**
 *  TCP ׽ֵĶС
 * @param fd {ACL_SOCKET} ׽
 * @param size {int} ôС
 */
ACL_API void acl_tcp_set_rcvbuf(ACL_SOCKET fd, int size);

/**
 *  TCP ׽ֵдС
 * @param fd {ACL_SOCKET} ׽
 * @param size {int} ôС
 */
ACL_API void acl_tcp_set_sndbuf(ACL_SOCKET fd, int size);

/**
 * ȡ TCP ׽ֵĶС
 * @param fd {ACL_SOCKET} ׽
 * @return {int} С
 */
ACL_API int  acl_tcp_get_rcvbuf(ACL_SOCKET fd);

/**
 * ȡ TCP ׽ֵдС
 * @param fd {ACL_SOCKET} ׽
 * @return {int} С
 */
ACL_API int  acl_tcp_get_sndbuf(ACL_SOCKET fd);

/**
 *  TCP ׽ֵ nodelay 
 * @param fd {ACL_SOCKET} ׽
 */
ACL_API void acl_tcp_set_nodelay(ACL_SOCKET fd);

/**
 *  TCP ׽ֵ nodelay 
 * @param fd {ACL_SOCKET} ׽
 * @param onoff {int} 1 ʾ򿪣0 ʾر
 */
ACL_API void acl_tcp_nodelay(ACL_SOCKET fd, int onoff);

/**
 *  TCP ׽Ƿ nodelay ѡ
 * @param fd {ACL_SOCKET} ׽
 * @return {int} 1 ʾ򿪣0 ʾر
 */
ACL_API int acl_get_tcp_nodelay(ACL_SOCKET fd);

/**
 *  TCP ׽ֵ SO_LINGER ѡ
 * @param fd {ACL_SOCKET} ׽
 * @param onoff {int} Ƿ SO_LINGER ѡ
 * @param timeout {int} SO_LINGERʱȡ timed_wait ʱ䣬λΪ
 */
ACL_API void acl_tcp_so_linger(ACL_SOCKET fd, int onoff, int timeout);

/**
 *  TCP ׽ֵ linger ֵ
 * @param fd {ACL_SOCKET} ׽
 * @return {int}  -1 ʾδ linger ѡڲ>= 0 ʾ linger
 *  ѡҸֵʾ׽ֹرպ TCP ںά TIME_WAIT ״̬Ķʱ()
 */
ACL_API int acl_get_tcp_solinger(ACL_SOCKET fd);

/**
 * ü׽ֵӳٽչܣͻʱŽӷ
 * ӦãĿǰù֧ܽ Linux
 * @param fd {ACL_SOCKET} ׽
 * @param timeout {int} ͻڹ涨ʱδݣҲӷ
 *  Ӧ
 */
ACL_API void acl_tcp_defer_accept(ACL_SOCKET fd, int timeout);

#ifdef __cplusplus
}
#endif

#endif

