#ifndef ACL_JSON_INCLUDE_H
#define ACL_JSON_INCLUDE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdlib/acl_define.h"
#include "stdlib/acl_dbuf_pool.h"
#include "stdlib/acl_iterator.h"
#include "stdlib/acl_vstring.h"
#include "stdlib/acl_ring.h"
#include "stdlib/acl_array.h"

typedef struct ACL_JSON ACL_JSON;
typedef struct ACL_JSON_NODE ACL_JSON_NODE;

struct ACL_JSON_NODE {
	ACL_VSTRING *ltag;          /**< ǩ */
	ACL_VSTRING *text;          /**< ΪҶʱıݷǿ */
	ACL_JSON_NODE *tag_node;    /**< ǩֵΪ json ʱǿ */
	int   type;                 /**<  */
#define	ACL_JSON_T_A_STRING      (1 << 0)
#define	ACL_JSON_T_A_NUMBER      (1 << 1)
#define	ACL_JSON_T_A_BOOL        (1 << 2)
#define	ACL_JSON_T_NUMBER        (1 << 3)
#define ACL_JSON_T_OBJ           (1 << 4)
#define ACL_JSON_T_ARRAY         (1 << 5)
#define	ACL_JSON_T_BOOL          (1 << 6)
#define	ACL_JSON_T_NULL          (1 << 7)

#define ACL_JSON_T_TEXT          (1 << 8)
#define ACL_JSON_T_LEAF          ACL_JSON_T_TEXT
#define ACL_JSON_T_MEMBER        (1 << 9)
#define ACL_JSON_T_PAIR          (1 << 10)
#define	ACL_JSON_T_ELEMENT       (1 << 11)

	ACL_JSON_NODE *parent;      /**<  */
	ACL_RING children;          /**< ӽ㼯 */
	int  depth;                 /**< ǰ */

	/* private */
	ACL_JSON *json;             /**< json  */
	ACL_RING node;              /**< ǰ */
	int   quote;                /**<  0 ʾ '  " */
	int   left_ch;              /**< ĵһַ: { or [ */
	int   right_ch;             /**< һַ: } or ] */
	int   backslash;            /**< תַ \ */
	int   part_word;            /**< ֵ־λ */

	/* public: for acl_iterator, ͨ acl_foreach гýһӽ */

	/* ȡͷ */
	ACL_JSON_NODE *(*iter_head)(ACL_ITER*, ACL_JSON_NODE*);
	/* ȡһ */
	ACL_JSON_NODE *(*iter_next)(ACL_ITER*, ACL_JSON_NODE*);
	/* ȡβ */
	ACL_JSON_NODE *(*iter_tail)(ACL_ITER*, ACL_JSON_NODE*);
	/* ȡһ */
	ACL_JSON_NODE *(*iter_prev)(ACL_ITER*, ACL_JSON_NODE*);
};

enum {
	ACL_JSON_S_ROOT,	/**<  */
	ACL_JSON_S_OBJ,		/**< ǩֵ */
	ACL_JSON_S_MEMBER,
	ACL_JSON_S_ARRAY,	/**< json  array */
	ACL_JSON_S_ELEMENT,
	ACL_JSON_S_PAIR,	/**< name:value pair */
	ACL_JSON_S_NEXT,	/**< һ */
	ACL_JSON_S_TAG,		/**< ǩ */
	ACL_JSON_S_VALUE,	/**< ֵ */
	ACL_JSON_S_COLON,	/**< ð : */
	ACL_JSON_S_STRING,
	ACL_JSON_S_STREND
};

struct ACL_JSON {
	int   depth;                /**<  */
	int   node_cnt;             /**< ,  root  */
	ACL_JSON_NODE *root;        /**< json  */
	int   finish;               /**< Ƿ */
	unsigned flag;              /**< ־λ */
#define	ACL_JSON_FLAG_PART_WORD	(1 << 0)  /**< Ƿݰ */

	/* public: for acl_iterator, ͨ acl_foreach гӽ */

	/* ȡͷ */
	ACL_JSON_NODE *(*iter_head)(ACL_ITER*, ACL_JSON*);
	/* ȡһ */
	ACL_JSON_NODE *(*iter_next)(ACL_ITER*, ACL_JSON*);
	/* ȡβ */
	ACL_JSON_NODE *(*iter_tail)(ACL_ITER*, ACL_JSON*);
	/* ȡһ */
	ACL_JSON_NODE *(*iter_prev)(ACL_ITER*, ACL_JSON*);

	/* private */

	int   status;               /**< ״̬ǰ״̬ */

	ACL_JSON_NODE *curr_node;   /**< ǰڴ json  */
	ACL_DBUF_POOL *dbuf;        /**< Ựڴض */
};

/*----------------------------- in acl_json.c -----------------------------*/

/**
 * һ json 
 * @param json {ACL_JSON*} json 
 * @return {ACL_JSON_NODE*} json 
 */
ACL_API ACL_JSON_NODE *acl_json_node_alloc(ACL_JSON *json);

/**
 * ĳ json 㼰ӽ json ɾ, ͷŸý㼰ӽ
 * ռռ亯ͷŸ json ռڴ
 * @param node {ACL_JSON_NODE*} json 
 * @return {int} ɾĽ
 */
ACL_API int acl_json_node_delete(ACL_JSON_NODE *node);

/**
 * ĳ json ֵܽ(ֵܽǶ json )
 * @param node1 {ACL_JSON_NODE*} 򱾽 json 
 * @param node2 {ACL_JSON_NODE*} ӵֵ json 
 */
ACL_API void acl_json_node_append(ACL_JSON_NODE *node1, ACL_JSON_NODE *node2);

/**
 * ĳ json Ϊӽĳ json 
 * @param parent {ACL_JSON_NODE*} 
 * @param child {ACL_JSON_NODE*} ӽ
 */
ACL_API void acl_json_node_add_child(ACL_JSON_NODE *parent, ACL_JSON_NODE *child);

/**
 * һ JSON  JSON 㸴 JSON еһ JSON У
 * Ŀ´ JSON 
 * @param json {ACL_JSON*} Ŀ JSON 
 * @param from {ACL_JSON_NODE*} Դ JSON һ JSON 
 * @return {ACL_JSON_NODE*} طǿնָ
 */
ACL_API ACL_JSON_NODE *acl_json_node_duplicate(ACL_JSON *json, ACL_JSON_NODE *from);

/**
 * ĳ json ĸ
 * @param node {ACL_JSON_NODE*} json 
 * @return {ACL_JSON_NODE*} , Ϊ NULL ʾ丸㲻
 */
ACL_API ACL_JSON_NODE *acl_json_node_parent(ACL_JSON_NODE *node);

/**
 * ĳ json ĺһֵܽ
 * @param node {ACL_JSON_NODE*} json 
 * @return {ACL_JSON_NODE*}  json ĺһֵܽ, ΪNULLʾ
 */
ACL_API ACL_JSON_NODE *acl_json_node_next(ACL_JSON_NODE *node);

/**
 * ĳ json ǰһֵܽ
 * @param node {ACL_JSON_NODE*} json 
 * @return {ACL_JSON_NODE*}  json ǰһֵܽ, ΪNULLʾ
 */
ACL_API ACL_JSON_NODE *acl_json_node_prev(ACL_JSON_NODE *node);

/**
 * ǰ json ַ
 * @param node {ACL_JSON_NODE*} json 
 * @return {const char*} json ͵ַ
 */
ACL_API const char *acl_json_node_type(const ACL_JSON_NODE *node);

/**
 * һ json 
 * @return {ACL_JSON*} ´ json 
 */
ACL_API ACL_JSON *acl_json_alloc(void);

/**
 * һ JSON һ JSON 㴴һµ JSON 
 * @param node {ACL_JSON_NODE*} Դ JSON һ JSON 
 * @return {ACL_JSON*} ´ JSON 
 */
ACL_API ACL_JSON *acl_json_create(ACL_JSON_NODE *node);

/**
 * ĳһ ACL_JSON_NODE Ϊһ json ĸ㣬
 * ӶԷرýĸӽ(ڱе
 * 㲻)ñʽбڵ
 * ĳһ ACL_JSON_NODE ʱܱһӽ
 * @param json {ACL_JSON*} json 
 * @param node {ACL_JSON_NODE*} ACL_JSON_NODE 
 */
ACL_API void acl_json_foreach_init(ACL_JSON *json, ACL_JSON_NODE *node);

/**
 * ͷһ json , ͬʱͷŸöɵ json 
 * @param json {ACL_JSON*} json 
 */
ACL_API void acl_json_free(ACL_JSON *json);

/**
 *  json 
 * @param json {ACL_JSON*} json 
 */
ACL_API void acl_json_reset(ACL_JSON *json);

/*------------------------- in acl_json_parse.c ---------------------------*/

/**
 *  json , Զ json 
 * @param json {ACL_JSON*} json 
 * @param data {const char*}  '\0' βַ,  json ;
 *  Ҳǲ json , ѭô˺, ݳ
 */
ACL_API void acl_json_update(ACL_JSON *json, const char *data);

/*------------------------- in acl_json_util.c ----------------------------*/

/**
 * ͷ acl_json_getElementsByTagName, acl_json_getElementsByName,
 * ȺصĶ̬, Ϊö̬е
 * Ԫض ACL_JSON Ԫص, ͷŵö̬, ֻҪ ACL_JSON
 * ͷ, ԭڸеԪȻʹ.
 * ͷ xml Ԫ
 * @param a {ACL_ARRAY*} ̬
 */
ACL_API void acl_json_free_array(ACL_ARRAY *a);

/**
 *  json леǩͬ json ļ
 * @param json {ACL_JSON*} json 
 * @param tag {const char*} ǩ
 * @return {ACL_ARRAY*}  json 㼯,  ̬,  NULL 
 *  ʾûз json , ǿֵҪ acl_json_free_array ͷ
 */
ACL_API ACL_ARRAY *acl_json_getElementsByTagName(ACL_JSON *json, const char *tag);

/**
 *  json ле༶ǩͬ json ļ
 * @param json {ACL_JSON*} json 
 * @param tags {const char*} ༶ǩ '/' ָǩ json ݣ
 *  { 'root': [
 *      'first': { 'second': { 'third': 'test1' } },
 *      'first': { 'second': { 'third': 'test2' } },
 *      'first': { 'second': { 'third': 'test3' } }
 *    ]
 *  }
 *  ͨ༶ǩroot/first/second/third һԲзĽ
 * @return {ACL_ARRAY*}  json 㼯,  ̬,  NULL 
 *  ʾûз json , ǿֵҪ acl_json_free_array ͷ
 */
ACL_API ACL_ARRAY *acl_json_getElementsByTags(ACL_JSON *json, const char *tags);

/**
 *  json ʱ json Ҷ
 * @param json {ACL_JSON*}  acl_json_alloc / acl_json_alloc1 
 * @param name {const char*} ǩǿ
 * @param value {const char*} ǩֵǿ
 * @return {ACL_JSON_NODE*} ´Ľͷ ACL_JSON ʱ
 *  һͷţԲҪͷ
 */
ACL_API ACL_JSON_NODE *acl_json_create_text(ACL_JSON *json,
	const char *name, const char *value);
#define acl_json_create_leaf acl_json_create_text

/**
 *  json ʱ json ͵Ҷ
 * @param json {ACL_JSON*}  acl_json_alloc / acl_json_alloc1 
 * @param name {const char*} ǩǿ
 * @param value {int} ֵ
 * @return {ACL_JSON_NODE*} ´Ľͷ ACL_JSON ʱ
 *  һͷţԲҪͷ
 */
ACL_API ACL_JSON_NODE *acl_json_create_bool(ACL_JSON *json,
	const char *name, int value);

/**
 *  json ʱ json int ͵Ҷ
 * @param json {ACL_JSON*}  acl_json_alloc / acl_json_alloc1 
 * @param name {const char*} ǩǿ
 * @param value {acl_int64} зֵ
 * @return {ACL_JSON_NODE*} ´Ľͷ ACL_JSON ʱ
 *  һͷţԲҪͷ
 */
ACL_API ACL_JSON_NODE *acl_json_create_int64(ACL_JSON *json,
	const char *name, acl_int64 value);

/**
 *  json ַ㣬 json 淶ýֻܼ
 * @param json {ACL_JSON*}  acl_json_alloc / acl_json_alloc1 
 * @param text {const char*}
 * @return {ACL_JSON_NODE*} ´Ľͷ ACL_JSON ʱ
 *  һͷţԲҪͷ
 */
ACL_API ACL_JSON_NODE *acl_json_create_array_text(ACL_JSON *json,
	const char *text);
ACL_API ACL_JSON_NODE *acl_json_create_string(ACL_JSON *json,
	const char *text);

/**
 *  json ֵ㣬 json 淶ýֻܼ
 * @param json {ACL_JSON*}  acl_json_alloc / acl_json_alloc1 
 * @param text {const char*}
 * @return {ACL_JSON_NODE*} ´Ľͷ ACL_JSON ʱ
 *  һͷţԲҪͷ
 */
ACL_API ACL_JSON_NODE *acl_json_create_array_int64(ACL_JSON *json,
	acl_int64 value);

/**
 *  json Ĳ㣬 json 淶ýֻܼ
 * @param json {ACL_JSON*}  acl_json_alloc / acl_json_alloc1 
 * @param value {int}
 * @return {ACL_JSON_NODE*} ´Ľͷ ACL_JSON ʱ
 *  һͷţԲҪͷ
 */
ACL_API ACL_JSON_NODE *acl_json_create_array_bool(ACL_JSON *json, int value);

/**
 *  json ʱ json ( {} Ķ)
 * @param json {ACL_JSON*}  acl_json_alloc / acl_json_alloc1 
 * @return {ACL_JSON_NODE*} ´Ľͷ ACL_JSON ʱ
 *  һͷţԲҪͷ
 */
ACL_API ACL_JSON_NODE *acl_json_create_obj(ACL_JSON *json);

/**
 *  json ʱ json ( [] Ķ)
 * @param json {ACL_JSON*}  acl_json_alloc / acl_json_alloc1 
 * @return {ACL_JSON_NODE*} ´Ľͷ ACL_JSON ʱ
 *  һͷţԲҪͷ
 */
ACL_API ACL_JSON_NODE *acl_json_create_array(ACL_JSON *json);

/**
 *  json ʱ json ( tagname: ACL_JSON_NODE)
 * @param json {ACL_JSON*}  acl_json_alloc / acl_json_alloc1 
 * @param name {const char*} json ıǩ
 * @param value {ACL_JSON_NODE*} json Ϊǩֵ
 * @return {ACL_JSON_NODE*} ´Ľͷ ACL_JSON ʱ
 *  һͷţԲҪͷ
 */
ACL_API ACL_JSON_NODE *acl_json_create_node(ACL_JSON *json,
	const char *name, ACL_JSON_NODE *value);

/**
 *  json ʱһ acl_json_create_obj  acl_json_create_array
 *  json ӽ㣬ӽ½ӿڴĽ:
 * acl_json_create_leaf, acl_json_create_obj, acl_json_create_array
 */
ACL_API void acl_json_node_append_child(ACL_JSON_NODE *parent,
	ACL_JSON_NODE *child);

/**
 *  json һ JSON תַ
 * @param node {ACL_JSON_NODE*} json 
 * @param buf {ACL_VSTRING*} 洢ĻòΪʱڲ
 *  ԶһλӦҪͷŵǿպڲֱӽ洢
 * @return {ACL_VSTRING*} json תַĴ洢
 *  ÷ֵԶǿգʹ߿ͨ ACL_VSTRING_LEN(x) жǷΪգ
 *  ص ACL_VSTRING ָΪúڲģû
 *  acl_vstring_free ͷ
 */
ACL_API ACL_VSTRING *acl_json_node_build(ACL_JSON_NODE *json, ACL_VSTRING *buf);

/**
 *  json תַ
 * @param json {ACL_JSON*} json 
 * @param buf {ACL_VSTRING*} 洢ĻòΪʱڲ
 *  ԶһλӦҪͷŵǿպڲֱӽ洢
 * @return {ACL_VSTRING*} json תַĴ洢÷ֵԶǿգ
 *  ʹ߿ͨ ACL_VSTRING_LEN(x) жǷΪգص ACL_VSTRING
 *  ָΪúڲģû acl_vstring_free ͷ
 */
ACL_API ACL_VSTRING *acl_json_build(ACL_JSON *json, ACL_VSTRING *buf);

/**
 * ʽ JSON תַ̣úڽ JSON תΪַĹУ
 * һתһ߽ͨصߣ߿޶޶û
 * ʱôӦڵJSONתɵַǳʱ(糬100 MB),
 * ΪʽתʽԲҪһڴ
 * @param json {ACL_JSON*} json 
 * @param length {size_t} תΪַĹȳóص
 *  û趨Ļص
 * @param callback {int (*)(ACL_JSON*, ACL_VSTRING*, void*)} û趨Ļص
 *  صĵڶΪ NULL ʱʾϣûڸûص
 *  ĳαú󷵻ֵ < 0 ֹͣ
 * @param ctx {void*} callback һ
 */
ACL_API void acl_json_building(ACL_JSON *json, size_t length,
	int (*callback)(ACL_JSON *, ACL_VSTRING *, void *), void *ctx);

#ifdef __cplusplus
}
#endif

#endif
