#ifndef	__HTTP_PLUGIN_INCLUDE_H__
#define	__HTTP_PLUGIN_INCLUDE_H__

#include "lib_acl.h"
#include "lib_protocol.h"

#ifdef	__cplusplus
extern "C" {
#endif

/**
 * HTTP ʼעắ, úǿգڸտʼʱ
 * @param dll_env {ACL_DLL_ENV*} DLL , dll_env->logfp ־ļ,
 *  ϣ־־ļУԽֵÿ
 * @param dmptr {ACL_DEBUG_MEM*} ڴԵľ
 * @param cfg_dir {const char*} ļ··´ж̬ļ
 */
void http_plugin_init(ACL_DLL_ENV *dll_env, const char *cfg_dir);

/**
 * HTTP עắúǿգյHTTPͷʱ
 * @param client {ACL_VSTREAM*} ͻ
 * @param hdr_req {HTTP_HDR_REQ*} HTTPͷ
 * @param ctx_ptr {void**} ָ洢ûĶ̬
 * @return {int} < 0: ʾֹHTTP, ֵʾţΪ-5xx/-4xx;
 *  0: ʾHTTP; > 0: ʾHTTPģĵ
 *  ̴߳
 */
int http_request_filter(ACL_VSTREAM *client, HTTP_HDR_REQ *hdr_req, void **ctx_ptr);

/**
 * HTTP ӹܴעắúǿգ http_request_filter() > 0
 * ô˺ȫӹܸHTTPӦٴHTTPHTTPӦ
 * @param client {ACL_VSTREAM*} HTTPͻ
 * @param hdr_req {HTTP_HDR_REQ*} ͻHTTPͷ
 * @param ctx {void*} Ĳö̬ http_request_filter е ctx_ptr
 *  ص
 */
void http_request_forward(ACL_VSTREAM *client, HTTP_HDR_REQ *hdr_req, void *ctx);

/*----------------------------------------------------------------------------*/

#define	DEBUG_BASE	500
#define	DBG_REQ		(DEBUG_BASE + 1)
#define	DBG_RES		(DEBUG_BASE + 2)

#define	STR	acl_vstring_str
#define	LEN	ACL_VSTRING_LEN

typedef struct {
	char *alias;
	char *cgi;
	HTTP_HDR_REQ *hdr_req;
	HTTP_REQ *req;
	HTTP_HDR_RES *hdr_res;
	ACL_VSTREAM *client;
} CGI;

/* ȫñ */

extern char *var_cfg_log_name;
extern char *var_cfg_cgi_bin;
extern int   var_cfg_data_clone;

/* in http_conf.c */

/**
 * ļ
 * @param cfg_dir {const char*} ļڵĿ¼λ
 */
void http_conf_load(const char *cfg_dir);

/* in http_plugin.c */

/**
 * ̳߳
 * @param threads_limit {int} ̸̳߳߳
 * @param threads_idle {int} ̳߳ÿ̵߳ʱ()
 */
void http_plugin_pool_create(int threads_limit, int threads_idle);

/**
 * ̳߳ûӵ̳߳еĳ߳̽ӹ
 * @param start_routine {void (*)(void*)} ûӵص
 * @param arg {void*} ̳߳еĳ̻߳ص start_routine ʱĻص
 */
void http_plugin_pool_append(void (*start_routine)(void *), void *arg);

/**
 * Ҫڴ״̬ʱĺ
 * @param level {int} Լ𣬿õļΪ: 1, 2, 3
 */
void http_plugin_debug_memory(int level);

/* in http_cgi.c */

void http_cgi_init(void);
void http_cgi_end(void);
void http_cgi_add2(const char *alias, const char *cgi);
void http_cgi_add1(const ACL_ARGV *args);
CGI *http_cgi_path(const char *alias);
void http_cgi_thread(void *ctx);

#ifdef	__cplusplus
}
#endif

#endif
