#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>
#include <list>
#include <stdarg.h>
#include <utility>

struct ACL_VSTRING;
struct ACL_LINE_STATE;

namespace acl {

/**
 * Ϊִַ֧࣬󲿷 std::string еĹܣͬʱ֧䲻ֵ֧һЩ
 * ܣڲԶ֤һַΪ \0
 */
class ACL_CPP_API string
{
public:
	/**
	 * 캯
	 * @param n {size_t} ʼʱڴС
	 * @param bin {bool} ǷԶƷʽ󣬸ֵΪ true ʱ
	 *  򵱵 += int|int64|short|char  << int|int64|short|char
	 *  ʱ򰴶Ʒʽıʽ
	 */
	string(size_t n = 64, bool bin = false);

	/**
	 * 캯
	 * @param s {const string&} Դַ󣬳ʼڲԶ
	 *  ַ
	 */
	string(const string& s);

	/**
	 * 캯
	 * @param s {const char*} ڲԶøַʼs 
	 *   \0 β
	 */
	string(const char* s);

	/**
	 * 캯
	 * @param s {const char*} Դ
	 * @param n {size_t} s ݳ
	 */
	string(const void* s, size_t n);
	virtual ~string(void);

	/**
	 * ַΪƴģʽ
	 * @param bin {bool} ֵΪ true ʱַΪƴ
	 *  ʽΪıʽΪ true ʱ򵱵 += int|int64|short|char
	 *   << int|int64|short|char ʱ򰴶Ʒʽı
	 *  ʽ
	 * @return {string&}
	 */
	string& set_bin(bool bin);

	/**
	 * û󳤶ȣԱ⻺
	 * @param max {int}
	 * @return {string&}
	 */
	string& set_max(int  max);

	/**
	 * жϵǰַǷΪƴʽ 
	 * @return {bool} ֵΪ true ʱʾΪƷʽ
	 */
	bool get_bin() const;

	/**
	 * صǰ󳤶ƣֵ <= 0 ʾû
	 * @return {int}
	 */
	int get_max(void) const;

	/**
	 * ַ±ָλõַΪϷֵ
	 * ڲ
	 * @param n {size_t} ָλãֵ >= 0  < ַ)Խ
	 *  
	 * @return {char} ָλõַ
	 */
	char operator[](size_t n) const;

	/**
	 * ַ±ָλõַΪϷֵ
	 * ڲ
	 * @param n {int} ָλãֵ >= 0  < ַ)Խ磬
	 *  
	 * @return {char} ָλõַ
	 */
	char operator[](int n) const;

	/**
	 * ֵֵأûֱʹö±иֵ±ֵ
	 * Խ磬ڲԶ仺ռ
	 * @param n {size_t} ±λ
	 * @return {char&}
	 */
	char& operator[](size_t n);

	/**
	 * ֵֵأûֱʹö±иֵ±ֵ
	 * Խ磬ڲԶ仺ռ
	 * @param n {int} ±λãֵ >= 0
	 * @return {char&}
	 */
	char& operator[](int n);

	/**
	 * Ŀֵַ
	 * @param s {const char*} Դַ
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(const char* s);

	/**
	 * Ŀֵַ
	 * @param s {const string&} Դַ
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(const string& s);

	/**
	 * Ŀֵַ
	 * @param s {const string*} Դַ
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(const string* s);

#if defined(_WIN32) || defined(_WIN64)
	/**
	 * Ŀֵַ
	 * @param n {long long int} Դ 64 λųǰĵǰ״̬Ϊ
	 *  ģʽúԶƷʽֵַ󣬷ı
	 *  ʽֵַ󣻹ڶģʽıʽ京μ
	 *  set_bin(bool)
	 * @return {string&} صǰֶãڶԸв
	 */
	string& operator=(__int64 n);

	/**
	 * Ŀֵַ
	 * @param n {unsinged long long int} Դ 64 λ޷ųַ
	 *  ĵǰ״̬ΪģʽúԶƷʽֵַ
	 *  ıʽֵַ󣻹ڶģʽıʽ京
	 *  μ set_bin(bool)
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(unsigned __int64);
#else
	string& operator=(long long int);
	string& operator=(unsigned long long int);
#endif

	/**
	 * Ŀֵַ
	 * @param n {char} Դзַַĵǰ״̬Ϊģʽ
	 *  úԶƷʽֵַ󣬷ıʽֵ
	 *  󣻹ڶģʽıʽ京μ set_bin(bool)
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(char n);

	/**
	 * Ŀֵַ
	 * @param n {char} Դ޷ַĵǰ״̬Ϊģʽú
	 *  ԶƷʽֵַ󣬷ıʽֵַ
	 *  ڶģʽıʽ京μ set_bin(bool)
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(unsigned char n);

	/**
	 * Ŀֵַ
	 * @param n {char} Դзųͣǰ״̬Ϊģʽú
	 *  ԶƷʽֵַ󣬷ıʽֵַ
	 *  ڶģʽıʽ京μ set_bin(bool)
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(long n);

	/**
	 * Ŀֵַ
	 * @param n {char} Դ޷ųֶͣĵǰ״̬Ϊģʽ
	 *  úԶƷʽֵַ󣬷ıʽֵ
	 *  ַ󣻹ڶģʽıʽ京μ set_bin(bool)
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(unsigned long n);

	/**
	 * Ŀֵַ
	 * @param n {char} Դзַͣĵǰ״̬Ϊģʽ
	 *  úԶƷʽֵַ󣬷ıʽֵַ
	 *  󣻹ڶģʽıʽ京μ set_bin(bool)
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(int n);

	/**
	 * Ŀֵַ
	 * @param n {char} Դ޷ַͣĵǰ״̬Ϊģʽ
	 *  úԶƷʽֵַ󣬷ıʽֵַ
	 *  󣻹ڶģʽıʽ京μ set_bin(bool)
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(unsigned int n);

	/**
	 * Ŀֵַ
	 * @param n {char} ԴзŶַͣĵǰ״̬Ϊģʽ,
	 *  úԶƷʽֵַ󣬷ıʽֵַ
	 *  󣻹ڶģʽıʽ京μ set_bin(bool)
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(short n);

	/**
	 * Ŀֵַ
	 * @param n {char} Դ޷Ŷͣĵǰ״̬Ϊģʽ
	 *  ԶƷʽֵַ󣬷ıʽֵַ
	 *  󣻹ڶģʽıʽ京μ set_bin(bool)
	 * @return {string&} صǰãڶԸв
	 */
	string& operator=(unsigned short n);

	/**
	 * Ŀַβַ
	 * @param s {const char*} Դַָ
	 * @return {string&} Ŀַ
	 */
	string& operator+=(const char* s);

	/**
	 * Ŀַβַ
	 * @param s {const string&} Դַ
	 * @return {string&} Ŀַ
	 */
	string& operator+=(const string& s);

	/**
	 * Ŀַβַ
	 * @param s {const string*} Դַָ
	 * @return {string&} Ŀַ
	 */
	string& operator+=(const string* s);
#if defined(_WIN32) || defined(_WIN64)
	/**
	 * Ŀַβзų֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long long int} Դ 64 λз
	 * @return {string&} Ŀַ
	 */
	string& operator+=(__int64 n);

	/**
	 * Ŀַβ޷ų֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long long int} Դ 64 λ޷
	 * @return {string&} Ŀַ
	 */
	string& operator+=(unsigned __int64 n);
#else
	string& operator+=(long long int n);
	string& operator+=(unsigned long long int n);
#endif

	/**
	 * Ŀַβзų֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դзų
	 * @return {string&} Ŀַ
	 */
	string& operator+=(long n);

	/**
	 * Ŀַβ޷ų֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դ޷ų
	 * @return {string&} Ŀַ
	 */
	string& operator+=(unsigned long n);

	/**
	 * Ŀַβз֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դз
	 * @return {string&} Ŀַ
	 */
	string& operator+=(int n);

	/**
	 * Ŀַβ޷֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դ޷
	 * @return {string&} Ŀַ
	 */
	string& operator+=(unsigned int n);

	/**
	 * ĿַβзŶ֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} ԴзŶ
	 * @return {string&} Ŀַ
	 */
	string& operator+=(short n);

	/**
	 * Ŀַβ޷Ŷ֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դ޷Ŷ
	 * @return {string&} Ŀַ
	 */
	string& operator+=(unsigned short n);

	/**
	 * ĿַβзַΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դзַ
	 * @return {string&} Ŀַ
	 */
	string& operator+=(char n);

	/**
	 * Ŀַβ޷ַΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դ޷ַ
	 * @return {string&} Ŀַ
	 */
	string& operator+=(unsigned char n);

	/**
	 * Ŀַβַ
	 * @param s {const string&} Դַ
	 * @return {string&} Ŀַ
	 */
	string& operator<<(const string& s);

	/**
	 * Ŀַβַ
	 * @param s {const string*} Դַָ
	 * @return {string&} Ŀַ
	 */
	string& operator<<(const string* s);

	/**
	 * Ŀַβַ
	 * @param s {const char*} Դַָ
	 * @return {string&} Ŀַ
	 */
	string& operator<<(const char* s);
#if defined(_WIN32) || defined(_WIN64)
	/**
	 * Ŀַβзų֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long long int} Դ 64 λз
	 * @return {string&} Ŀַ
	 */
	string& operator<<(__int64 n);

	/**
	 * Ŀַβ޷ų֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long long int} Դ 64 λ޷
	 * @return {string&} Ŀַ
	 */
	string& operator<<(unsigned __int64 n);
#else
	string& operator<<(long long int n);
	string& operator<<(unsigned long long int n);
#endif

	/**
	 * Ŀַβзų֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դзų
	 * @return {string&} Ŀַ
	 */
	string& operator<<(long n);

	/**
	 * Ŀַβ޷ų֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դ޷ų
	 * @return {string&} Ŀַ
	 */
	string& operator<<(unsigned long n);

	/**
	 * Ŀַβз֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դз
	 * @return {string&} Ŀַ
	 */
	string& operator<<(int n);

	/**
	 * Ŀַβ޷֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դ޷
	 * @return {string&} Ŀַ
	 */
	string& operator<<(unsigned int n);

	/**
	 * ĿַβзŶ֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} ԴзŶ
	 * @return {string&} Ŀַ
	 */
	string& operator<<(short n);

	/**
	 * Ŀַβ޷Ŷ֣ΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դ޷Ŷ
	 * @return {string&} Ŀַ
	 */
	string& operator<<(unsigned short n);

	/**
	 * ĿַβзַΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դзַ
	 * @return {string&} Ŀַ
	 */
	string& operator<<(char n);

	/**
	 * Ŀַβ޷ַΪĿַΪ
	 * Ʒʽʱ򰴶ַʽӣıʽ
	 * @param n {long} Դ޷ַ
	 * @return {string&} Ŀַ
	 */
	string& operator<<(unsigned char n);

	/**
	 * ַеݸĿַ
	 * @param s {string*} Ŀַ
	 * @return {size_t} ؿʵֽempty() == true ʱ򷵻 0
	 */
	size_t operator>>(string* s);
#if defined(_WIN32) || defined(_WIN64)
	/**
	 * ַеݸĿ 64 λз
	 * @param n {string*} Ŀ 64 λз
	 * @return {size_t} ؿʵֽempty() == true ʱ򷵻 0
	 */
	size_t operator>>(__int64& n);

	/**
	 * ַеݸĿ 64 λ޷
	 * @param n {string*} Ŀ 64 λ޷
	 * @return {size_t} ؿʵֽempty() == true ʱ򷵻 0
	 */
	size_t operator>>(unsigned __int64& n);
#else
	size_t operator>>(long long int&);
	size_t operator>>(unsigned long long int&);
#endif

	/**
	 * ַеݸĿ 32 λз
	 * @param n {string*} Ŀ 32 λз
	 * @return {size_t} ؿʵֽempty() == true ʱ򷵻 0
	 */
	size_t operator>>(int& n);

	/**
	 * ַеݸĿ 32 λ޷
	 * @param n {string*} Ŀ 32 λ޷
	 * @return {size_t} ؿʵֽempty() == true ʱ򷵻 0
	 */
	size_t operator>>(unsigned int& n);

	/**
	 * ַеݸĿ 16 λз
	 * @param n {string*} Ŀ 16 λз
	 * @return {size_t} ؿʵֽempty() == true ʱ򷵻 0
	 */
	size_t operator>>(short& n);

	/**
	 * ַеݸĿ 16 λ޷
	 * @param n {string*} Ŀ 16 λ޷
	 * @return {size_t} ؿʵֽempty() == true ʱ򷵻 0
	 */
	size_t operator>>(unsigned short& n);

	/**
	 * ַеݸĿ 8 λзַ
	 * @param n {string*} Ŀ 16 λзַ
	 * @return {size_t} ؿʵֽempty() == true ʱ򷵻 0
	 */
	size_t operator>>(char& n);

	/**
	 * ַеݸĿ 8 λ޷ַ
	 * @param n {string*} Ŀ 16 λ޷ַ
	 * @return {size_t} ؿʵֽempty() == true ʱ򷵻 0
	 */
	size_t operator>>(unsigned char& n);

	/**
	 * жϵǰַǷȣڲִСд
	 * @param s {const string&} ַ
	 * @return {bool}  true ʾַͬ
	 */
	bool operator==(const string& s) const;

	/**
	 * жϵǰַǷȣڲִСд
	 * @param s {const string&} ַָ
	 * @return {bool}  true ʾַͬ
	 */
	bool operator==(const string* s) const;

	/**
	 * жϵǰַǷȣڲִСд
	 * @param s {const string&} ַָ
	 * @return {bool}  true ʾַͬ
	 */
	bool operator==(const char* s) const;

	/**
	 * жϵǰַǷ񲻵ȣڲִСд
	 * @param s {const string&} ַ
	 * @return {bool}  true ʾַݲͬ
	 */
	bool operator!=(const string& s) const;

	/**
	 * жϵǰַǷ񲻵ȣڲִСд
	 * @param s {const string&} ַָ
	 * @return {bool}  true ʾַݲͬ
	 */
	bool operator!=(const string* s) const;

	/**
	 * жϵǰַǷ񲻵ȣڲִСд
	 * @param s {const string&} ַָ
	 * @return {bool}  true ʾַݲͬ
	 */
	bool operator!=(const char* s) const;

	/**
	 * жϵǰǷСַݣڲִСд
	 * @param s {const string&} ַ
	 * @return {bool}  true ʾǰַСַ
	 *  
	 */
	bool operator<(const string& s) const;

	/**
	 * жϵǰǷַݣڲִСд
	 * @param s {const string&} ַ
	 * @return {bool}  true ʾǰַݴַ
	 *  
	 */
	bool operator>(const string& s) const;

	/**
	 * ǰֱתΪַָ루ڲֱӵ
	 * @return {const char*} ֵԶΪǿָ룬пΪմ
	 */
	operator const char*() const;

	/**
	 * ǰֱַתΪָͨ루ڲֱӵ
	 * @return {const char*} ֵԶΪǿָ
	 */
	operator const void*() const;

	/**
	 * һзַӽǰַβ
	 * @param ch {char} зַ
	 * @return {string&} ǰַ
	 */
	string& push_back(char ch);

	/**
	 * ȽַǷִͬСд
	 * @param s {const string&} ַ
	 * @return {int} 0ʾͬ > 0ǰַݴݣ
	 *  < 0 ǰַС
	 */
	int compare(const string& s) const;

	/**
	 * ȽַǷִͬСд
	 * @param s {const string&} ַָ
	 * @return {int} 0ʾͬ > 0ǰַݴݣ
	 *  < 0 ǰַС
	 */
	int compare(const string* s) const;

	/**
	 * ȽַǷͬ
	 * @param s {const string&} ַ
	 * @param case_sensitive {bool} Ϊ true ʾִСд
	 * @return {int} 0ʾͬ > 0ǰַݴݣ
	 *  < 0 ǰַС
	 */
	int compare(const char* s, bool case_sensitive = true) const;

	/**
	 * ȽϵǰĻǷĻͬ
	 * @param ptr {const void*} Ļַ
	 * @param len {size_t} ptr Ļݳ
	 * @return {int} ؽ:
	 *  0ʾͬ
	 *  > 0ǰ󻺳ݴݣ
	 *  < 0 ǰ󻺳С
	 */
	int compare(const void* ptr, size_t len) const;

	/**
	 * Ƚϵǰ󻺳ǷĻͬ޶Ƚݳ
	 * @param s {const void*} Ļַ
	 * @param len {size_t} ptr Ļݳ
	 * @param case_sensitive {bool} Ϊ true ʾִСд
	 * @return {int} 0ʾͬ > 0ǰ󻺳ݴݣ
	 *  < 0 ǰ󻺳С
	 */
	int ncompare(const char* s, size_t len, bool case_sensitive = true) const;

	/**
	 * βǰȽϵǰĻǷĻͬ
	 * ޶Ƚݳ
	 * @param s {const void*} Ļַ
	 * @param len {size_t} ptr Ļݳ
	 * @param case_sensitive {bool} Ϊ true ʾִСд
	 * @return {int} 0ʾͬ
	 *  > 0ǰ󻺳ݴݣ
	 *  < 0 ǰ󻺳С
	 */
	int rncompare(const char* s, size_t len, bool case_sensitive = true) const;

	/**
	 * ڵǰַвҿеλãѭñԻе
	 * 
	 * @param left_count {int*} ָǿʱ洢ǰַʣݳ
	 * @param buf {string*} ҵʱһο(ÿ)
	 *  ο(ÿ)֮ݴڸûڣעڲ
	 *  ոûΪ׷ӷʽ
	 * @return {int}  0 ʾδҵУֵ > 0 ʾеһ
	 *  λ(ΪҪҵһзصǸÿеһλãҵ
	 *  򷵻ֵһ 0)ֵ < 0 ʾڲ
	 */
	int find_blank_line(int* left_count = NULL, string* buf = NULL);

	/**
	 * ڲѯ״̬Ҫ¿ʼ find_blank_line ʱҪñ
	 * ڲѯ״̬
	 * @return {string&}
	 */
	string& find_reset(void);

	/**
	 * ַָڵǰ󻺳λã± 0 ʼ
	 * @param n {char} Ҫҵзַ
	 * @return {int} ַڻеλãֵ < 0 ʾ
	 */
	int find(char n) const;

	/**
	 * ַָڵǰ󻺳ʼλã± 0 ʼ
	 * @param needle {const char*} Ҫҵзַ
	 * @param case_sensitive {bool} Ϊ true ʾִСд
	 * @return {char*} ַڻеʼλãؿָʾ
	 */
	char* find(const char* needle, bool case_sensitive=true) const;

	/**
	 * βǰַָڵǰ󻺳ʼλã± 0 ʼ
	 * @param needle {const char*} Ҫҵзַ
	 * @param case_sensitive {bool} Ϊ true ʾִСд
	 * @return {char*} ַڻеʼλãֵΪָʾ
	 */
	char* rfind(const char* needle, bool case_sensitive=true) const;

	/**
	 * شӵǰַлָλ
	 * @param npos {size_t} ±λãֵڵڵǰַݳʱ
	 *  򷵻ַ󣻷ֵֵָλõַ
	 * @return {string} ֵΪһĶ󣬲ҪͷţúЧ
	 *  ̫ܲ
	 */
	string left(size_t npos);

	/**
	 * شӵǰַлָλҵ
	 * @param npos {size_t} ±λãֵڵڵǰַݳʱ
	 *  򷵻صַΪգֵֵָλõַ
	 * @return {const string} ֵΪһĶ󣬲Ҫͷţ
	 *  Чʿ̫ܲ
	 */
	string right(size_t npos);

	/**
	 * ǰĻݿһĿ껺
	 * @param buf {void*} Ŀ껺ַ
	 * @param size {size_t} buf 
	 * @param move {bool} ڿݺǷҪǰƶ
	 *  ǰѿ
	 * @return {size_t} ؿʵֽ empty() == true ʱ򷵻 0
	 */
	size_t scan_buf(void* buf, size_t size, bool move = false);

	/**
	 * ӵǰĻпһ("\r\n")Ŀ껺ڣ
	 * Ŀ껺ԴδݻᷢƶǱ
	 * 
	 * @param out {string&} Ŀ껺ڲԶոû
	 * @param nonl {bool} صһǷȥβ "\r\n"  "\n"
	 * @param n {size_t*} òΪǿָʱ洢ݳȣ
	 *  һ nonl Ϊ true ʱõַ洢 0
	 * @param move {bool} ڿݺǷҪǰƶ
	 *  ǰѿ
	 * @return {bool} Ƿ񿽱һݣ false Ҫ
	 *  empty() == true жϵǰǷ
	 */
	bool scan_line(string& out, bool nonl = true, size_t* n = NULL,
		bool move = false);

	/**
	 * ʹ scan_xxx ෽Իвʱδָ move ñ
	 * ʹʣǰƶײ
	 * @return {size_t} ƶֽ
	 */
	size_t scan_move();

	/**
	 * صǰ󻺳еһݵβַ
	 * @return {char*} ֵΪ NULL ˵ڲΪգ empty() == true
	 */
	char* buf_end(void);

	/**
	 * صǰ󻺳ʼַ
	 * @return {void*} صַԶǿ
	 */
	void* buf() const;

	/**
	 * ַʽصǰ󻺳ʼַ
	 * @return {char*} صַԶǿ
	 */
	char* c_str() const;

	/**
	 * صǰַĳȣ\0
	 * @return {size_t} ֵ >= 0
	 */
	size_t length() const;

	/**
	 * صǰַĳȣ\0 length ͬ
	 * @return {size_t} ֵ >= 0
	 */
	size_t size() const;

	/**
	 * صǰĻĿռ䳤ȣֵ >= ݳ
	 * @return {size_t} ֵ > 0
	 */
	size_t capacity() const;

	/**
	 * жϵǰĻݳǷΪ 0
	 * @return {bool}  true ʾΪ
	 */
	bool empty() const;

	/**
	 * صǰڲõ acl C е ACL_VSTRING ַ
	 * @return {ACL_VSTRING*} ֵԶǿ
	 */
	ACL_VSTRING* vstring(void) const;

	/**
	 * ǰĻ±λָλ
	 * @param n {size_t} Ŀ±λãֵ >= capacity ʱڲ
	 *  ·Щڴ
	 * @return {string&} ǰ
	 */
	string& set_offset(size_t n);

	/**
	 * øúԤȱ֤ҪĻС
	 * @param n {size_t} ϣĻռСֵ
	 * @return {string&} ǰ
	 */
	string& space(size_t n);

	/**
	 * ǰ洢ַзָ
	 * @param sep {const char*} зָʱķָ
	 * @return {std::list<string>&}  list ʽķָصĽ
	 *  Ҫͷţ˵ǰһڲָ
	 */
	std::list<string>& split(const char* sep);

	/**
	 * ǰ洢ַзָ
	 * @param sep {const char*} зָʱķָ
	 * @return {std::vector<string>&}  vector ʽķָص
	 *  Ҫͷţ˵ǰһڲָ
	 */
	std::vector<string>& split2(const char* sep);

	/**
	 *  '=' Ϊָǰ洢ַָ name/value ԣָʱ
	 * ԶȥԴַʼβԼָ '=' ߵĿո TAB
	 * @return {std::pair<string, string>&} ǰ洢ַ
	 *  Ϸָϸ name=valueʽ򷵻صĽַ
	 *  Ϊմ,صĽҪͷţ˵ǰһڲַ
	 */
	std::pair<string, string>& split_nameval(void);

	/**
	 * ַǰĻ
	 * @param ptr {const char*} Դַַ '\0' 
	 * @return {string&} ǰ
	 */
	string& copy(const char* ptr);

	/**
	 * ԴݵĶݿǰĻ
	 * @param ptr {const void*} Դݵַ
	 * @param len {size_t} ptr Դݳ
	 * @return {string&} ǰ
	 */
	string& copy(const void* ptr, size_t len);

	/**
	 * ԴַƶǰĻУڲԶжԴ
	 * ַǷڵǰĻ
	 * @param src {const char*} Դݵַ
	 * @return {string&} ǰ
	 */
	string& memmove(const char* src);

	/**
	 * ԴַƶǰĻУڲԶжԴ
	 * ַǷڵǰĻ
	 * @param src {const char*} Դݵַ
	 * @param len {size_t} ƶݵĳ
	 * @return {string&} ǰ
	 */
	string& memmove(const char* src, size_t len);

	/**
	 * ַָڵǰݻݵβ
	 * @param s {const string&} Դݶ
	 * @return {string&} ǰ
	 */
	string& append(const string& s);

	/**
	 * ַָڵǰݻݵβ
	 * @param s {const string&} Դݶָ
	 * @return {string&} ǰ
	 */
	string& append(const string* s);

	/**
	 * ַָڵǰݻݵβ
	 * @param s {const string&} Դݶָ
	 * @return {string&} ǰ
	 */
	string& append(const char* s);

	/**
	 * ָеڵǰݻݵβ
	 * @param ptr {const void*} Դݶָ
	 * @param len {size_t} ptr ݳ
	 * @return {string&} ǰ
	 */
	string& append(const void* ptr, size_t len);

	/**
	 * ַָڵǰݻݵײ
	 * @param s {const char*} Դݵַ
	 * @return {string&} ǰ
	 */
	string& prepend(const char* s);

	/**
	 * ָڴڵǰݻݵײ
	 * @param ptr {const void*} Դݵַ
	 * @param len {size_t} ptr ݳ
	 * @return {string&} ǰ
	 */
	string& prepend(const void* ptr, size_t len);

	/**
	 * ڴݲָ±λÿʼĵǰ󻺳
	 * @param start {size_t} ǰ󻺳Ŀʼ±ֵ
	 * @param ptr {const void*} ڴݵĵַ
	 * @param len {size_t} ڴݵĳ
	 * @return {string&} ǰ
	 */
	string& insert(size_t start, const void* ptr, size_t len);

	/**
	 * ʽʽݣ sprintf ӿڷʽ
	 * @param fmt {const char*} ʽַ
	 * @param ... 
	 * @return {string&} ǰ
	 */
	string& format(const char* fmt, ...) ACL_CPP_PRINTF(2, 3);

	/**
	 * ʽʽݣ vsprintf ӿڷʽ
	 * @param fmt {const char*} ʽַ
	 * @param ap {va_list} 
	 * @return {string&} ǰ
	 */
	string& vformat(const char* fmt, va_list ap);

	/**
	 * ʽʽڵǰβ
	 * @param fmt {const char*} ʽַ
	 * @param ... 
	 * @return {string&} ǰ
	 */
	string& format_append(const char* fmt, ...)  ACL_CPP_PRINTF(2, 3);

	/**
	 * ʽʽڵǰβ
	 * @param fmt {const char*} ʽַ
	 * @param ap {va_list} 
	 * @return {string&} ǰ
	 */
	string& vformat_append(const char* fmt, va_list ap);

	/**
	 * ǰеݵַ滻
	 * @param from {char} Դַ
	 * @param to {char} Ŀַ
	 * @return {string&} ǰ
	 */
	string& replace(char from, char to);

	/**
	 * ǰݽض̣ڲƶ±ַָ
	 * @param n {size_t} ݽض̺ݳȣֵ >= ǰ
	 *  ݳȣڲκα仯
	 * @return {string&} ǰ
	 */
	string& truncate(size_t n);

	/**
	 * ڵǰĻȥַָݣڴлᷢ
	 * ƶ
	 * @param needle {const char*} ָҪȥַ
	 * @param each {bool} Ϊ true ʱÿһ needle еַ
	 *  ڵǰĻȥ򣬽ڵǰ󻺳ȥ
	 *  needle ַ
	 * @return {string&} ǰ
	 *   acl::string s("hello world!");
	 *   s.strip("hel", true), Ϊ s == "o word!"
	 *   s.strip("hel", false), Ϊ: s = "lo world!"
	 */
	string& strip(const char* needle, bool each = false);

	/**
	 * ǰ󻺳ߵĿհףոTABȥ
	 * @return {string&} ǰ
	 */
	string& trim_left_space();

	/**
	 * ǰ󻺳ұߵĿհףոTABȥ
	 * @return {string&} ǰ
	 */
	string& trim_right_space();

	/**
	 * ǰ󻺳еĿհףոTABȥ
	 * @return {string&} ǰ
	 */
	string& trim_space();

	/**
	 * ǰ󻺳ߵĻسзȥ
	 * @return {string&} ǰ
	 */
	string& trim_left_line();

	/**
	 * ǰ󻺳ұߵĻسзȥ
	 * @return {string&} ǰ
	 */
	string& trim_right_line();

	/**
	 * ǰ󻺳еĻسзȥ
	 * @return {string&} ǰ
	 */
	string& trim_line();

	/**
	 * յǰݻ
	 * @return {string&} ǰ
	 */
	string& clear();

	/**
	 * ǰݻеݾתΪСд
	 * @return {string&} ǰ
	 */
	string& lower(void);

	/**
	 * ǰݻеݾתΪд
	 * @return {string&} ǰ
	 */
	string& upper(void);

	/**
	 * ӵǰнָƫָȵݿĿ껺
	 * @param out {string&} Ŀ껺ڲ׷ӷʽոö
	 * @param pos {size_t} ǰʼλ
	 * @param len {size_t}  pos ʼλÿʼֵΪ 0 ʱ
	 *  򿽱ָ pos λúеݣ򿽱ָȵݣָ
	 *  ݳȴʵҪĳȣʵʴڵ
	 * @return {size_t} ؿʵݳȣpos Խʱ÷ֵΪ 0
	 */
	size_t substr(string& out, size_t pos = 0, size_t len = 0);

	/**
	 * ǰݻеݽ base64 ת
	 * @return {string&} ǰ
	 */
	string& base64_encode(void);

	/**
	 * Դݽ base64 ת벢뵱ǰĻ
	 * @param ptr {const void*} Դݵĵַ
	 * @param len {size_t} Դݳ
	 * @return {string&} ǰ
	 */
	string& base64_encode(const void* ptr, size_t len);

	/**
	 * ǰĻеǾ base64 ģ˺Щ
	 * ݽн
	 * @return {string&} ǰ
	 */
	string& base64_decode(void);

	/**
	 *  base64 ݽн벢뵱ǰĻ
	 * @param s {const char*}  base64 Դ
	 * @return {string&} ǰ
	 */
	string& base64_decode(const char* s);

	/**
	 *  base64 ݽн벢뵱ǰĻ
	 * @param ptr {const void*}  base64 Դ
	 * @param len {size_t} ptr ݳ
	 * @return {string&} ǰ
	 */
	string& base64_decode(const void* ptr, size_t len);

	/**
	 * Դݽ url 벢뵱ǰĻ
	 * @param s {const char*} Դ
	 * @return {string&} ǰ
	 */
	string& url_encode(const char* s);

	/**
	 *  url Դݽ벢뵱ǰĻ
	 * @param s {const char*}  url Դ
	 * @return {string&} ǰ
	 */
	string& url_decode(const char* s);

	/**
	 * Դݽ H2B 벢뵱ǰĻ
	 * @param s {const void*} Դݵַ
	 * @param len {size_t} Դݳ
	 * @return {string&} ǰ
	 */
	string& hex_encode(const void* s, size_t len);

	/**
	 * Դݽ H2B 벢뵱ǰĻ
	 * @param s {const char*} Դݵַ
	 * @param len {size_t} Դݳ
	 * @return {string&} ǰ
	 */
	string& hex_decode(const char* s, size_t len);

	/**
	 * ļȫ·ȡļ
	 * @param path {const char*} ļȫ·ַǿַ
	 * @return {string&} ǰ
	 */
	string& basename(const char* path);

	/**
	 * ļȫ·ȡļĿ¼
	 * @param path {const char*} ļȫ·ַǿַ
	 * @return {string&} ǰ
	 */
	string& dirname(const char* path);

	/**
	 *  32 λзתΪַ棨ڲʹֲ߳̾
	 * @param n {int} 32 λз
	 * @return {string&} תãڲһֲ߳̾
	 */
	static string& parse_int(int n);

	/**
	 *  32 λ޷תΪַ棨ڲʹֲ߳̾
	 * @param n {int} 32 λ޷
	 * @return {string&} תãڲһֲ߳̾
	 */
	static string& parse_int(unsigned int n);
#if defined(_WIN32) || defined(_WIN64)
	static string& parse_int64(__int64 n);
	static string& parse_int64(unsigned __int64 n);
#else
	/**
	 *  64 λзתΪַ棨ڲʹֲ߳̾
	 * @param n {long long int} 64 λз
	 * @return {string&} תãڲһֲ߳̾
	 */
	static string& parse_int64(long long int n);

	/**
	 *  64 λ޷תΪַ棨ڲʹֲ߳̾
	 * @param n {unsigned long long int} 64 λ޷
	 * @return {string&} תãڲһֲ߳̾
	 */
	static string& parse_int64(unsigned long long int n);
#endif

private:
	bool use_bin_;
	ACL_VSTRING* vbf_;
	char* scan_ptr_;
	std::list<string>* list_tmp_;
	std::vector<string>* vector_tmp_;
	std::pair<string, string>* pair_tmp_;
	ACL_LINE_STATE* line_state_;
	int   line_state_offset_;

	void init(size_t len);
};

} // namespce acl
