#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/stdlib/locker.hpp"
#include <vector>

struct ACL_EVENT;

namespace acl
{

class connect_pool;
class connect_monitor;

/**
 * connect pool лȡӳصȹ
 */
class ACL_CPP_API connect_manager
{
public:
	connect_manager();
	virtual ~connect_manager();

	/**
	 * ʼзӳأúڲ set ÿӳ
	 * @param default_addr {const char*} ȱʡķַǿգ
	 *  ڲѯʱʹô˷
	 * @param addr_list {const char*} збΪ
	 *  ʽ: IP:PORT:COUNT;IP:PORT:COUNT;IP:PORT;IP:PORT ...
	 *      IP:PORT:COUNT,IP:PORT:COUNT,IP:PORT;IP:PORT ...
	 *  磺127.0.0.1:7777:50;192.168.1.1:7777:10;127.0.0.1:7778
	 * @param default_count {size_t}  addr_list зָĳû
	 *  COUNT Ϣʱôֵ
	 *  עdefault_addr  addr_list ͬʱΪ
	 */
	void init(const char* default_addr, const char* addr_list,
		size_t default_count);

	/**
	* ӷĿͻӳأúڳʱãڲԶ
	 * @param addr {const char*} ַ(ip:port)
	 * @param count {size_t} ӳ
	 * @return {connect_pool&} ӵӳض
	 */
	connect_pool& set(const char* addr, size_t count);

	/**
	 * ӳʧܺԵʱʱ룩úڳʱãڲԶ
	 * @param n {int} ֵ <= 0 ʱӳس
	 * @return {void}
	 */
	void set_retry_inter(int n);

	/**
	 * ӳؼȺɾĳַӳأúڳй
	 * ãΪڲԶ
	 * @param addr {const char*} ַ(ip:port)
	 */
	void remove(const char* addr);

	/**
	 * ݷ˵ַø÷ӳ
	 * @param addr {const char*} redis ַ(ip:port)
	 * @param exclusive {bool} ǷҪӳ飬Ҫ̬
	 *  ӳؼȺʱֵӦΪ true
	 * @param restore {bool} ÷㱻ΪʱòǷԶ
	 *  ָ֮Ϊ״̬
	 * @return {connect_pool*} ؿձʾûд˷
	 */
	connect_pool* get(const char* addr, bool exclusive = true,
		bool restore = false);

	/**
	 * ӳؼȺлһӳأúѭʽӳؼлȡһ
	 * ˷ӳأӶ֤ȫľԣúڲԶӳع
	 * м
	 * ⣬úΪӿڣʵԼѭʽ
	 * @return {connect_pool*} һӳأָԶǿ
	 */
	virtual connect_pool* peek();

	/**
	 * ӳؼȺлһӳأúùϣλʽӼлȡһ
	 * ˷ӳأش麯ԼļȺȡʽ
	 * 麯ڲȱʡ CRC32 Ĺϣ㷨
	 * @param key {const char*} ֵֵַΪ NULLڲ
	 *  Զлѭʽ
	 * @param exclusive {bool} ǷҪӳ飬Ҫ̬
	 *  ӳؼȺʱֵӦΪ true
	 * @return {connect_pool*} һõӳأָԶǿ
	 */
	virtual connect_pool* peek(const char* key, bool exclusive = true);

	/**
	 * û peek ʱԵô˺ӳع̼
	 */
	void lock();

	/**
	 * û peek ʱԵô˺ӳع̼
	 */
	void unlock();

	/**
	 * еķӳأӳаȱʡķӳ
	 * @return {std::vector<connect_pool*>&}
	 */
	std::vector<connect_pool*>& get_pools()
	{
		return pools_;
	}

	/**
	 * ӳؼӳضĸ
	 * @return {size_t}
	 */
	size_t size() const
	{
		return pools_.size();
	}

	/**
	 * ȱʡķӳ
	 * @return {connect_pool*}  init  default_addr Ϊʱ
	 *  ú NULL
	 */
	connect_pool* get_default_pool()
	{
		return default_pool_;
	}

	/**
	 * ӡǰ redis ӳصķ
	 */
	void statistics();

	/**
	 * ̨̼߳ӳ״̬
	 * @param monitor {connect_monitor*} Ӽ
	 * @return {bool} ǷӼ false ˵ǰ
	 *  еӼٴʱҪȵ stop_monitor
	 */
	bool start_monitor(connect_monitor* monitor);

	/**
	 * ֹ̨ͣ߳
	 * @param graceful {bool} Ƿڹرռ߳ʱҪȴеļӹرպ
	 *  ŷأӳؼȺΪ̿ռڲηͷʱֵΪ false
	 *  Ӷʹ߳̿˳Ӧõȴмӹرպʹ߳˳
	 * @return {connect_monitor*}  start_monitor õļͬʱڲ
	 *   monitor_ ԱԶ NULL
	 */
	connect_monitor* stop_monitor(bool graceful = true);

	/**
	 * ĳӳطĴ״̬ڲԶ
	 * @param addr {const char*} ַʽip:port
	 * @param alive {bool} ÷Ƿ
	 */
	void set_pools_status(const char* addr, bool alive);

protected:
	/**
	 * 麯ʵִ˺ӳض
	 * @param addr {const char*} ַʽip:port
	 * @param count {size_t} ӳصĴС
	 * @param idx {size_t} ӳضڼе±λ( 0 ʼ)
	 * @return {connect_pool*} شӳض
	 */
	virtual connect_pool* create_pool(const char* addr,
		size_t count, size_t idx) = 0;

private:
	string default_addr_;			// ȱʡķַ
	connect_pool* default_pool_;		// ȱʡķӳ
	std::vector<connect_pool*> pools_;	// еķӳ
	size_t service_idx_;			// һҪʵĵ±ֵ
	locker lock_;				//  pools_ ʱĻ
	int  stat_inter_;			// ͳƷĶʱ
	int  retry_inter_;			// ӳʧܺԵʱ
	connect_monitor* monitor_;		// ̨߳̾

	// óȱʡ֮ķȺ
	void set_service_list(const char* addr_list, int count);
};

} // namespace acl
