#ifndef	ACL_ARRAY_INCLUDE_H
#define	ACL_ARRAY_INCLUDE_H

#ifdef  __cplusplus
extern "C" {
#endif

#include "acl_define.h"
#include "acl_iterator.h"

/**
 * ̬Ͷ
 */
typedef	struct ACL_ARRAY ACL_ARRAY;
struct ACL_ARRAY{
	int     capacity;	/**< items ռС */
	int     count;		/**< items кԪصĸ */
	void    **items;	/**< ̬ */

	/* Ӽ */

	/* βӶ̬ */
	void  (*push_back)(struct ACL_ARRAY*, void*);
	/* ͷӶ̬ */
	void  (*push_front)(struct ACL_ARRAY*, void*);
	/* β̬ */
	void *(*pop_back)(struct ACL_ARRAY*);
	/* ͷ̬ */
	void *(*pop_front)(struct ACL_ARRAY*);

	/* for acl_iterator */

	/* ȡͷ */
	void *(*iter_head)(ACL_ITER*, struct ACL_ARRAY*);
	/* ȡһ */
	void *(*iter_next)(ACL_ITER*, struct ACL_ARRAY*);
	/* ȡβ */
	void *(*iter_tail)(ACL_ITER*, struct ACL_ARRAY*);
	/* ȡһ */
	void *(*iter_prev)(ACL_ITER*, struct ACL_ARRAY*);
};

/**
 * һ̬
 * @param init_size {int} ̬ĳʼС
 * @return {ACL_ARRAY*} ָ̬
 */
ACL_API ACL_ARRAY *acl_array_create(int init_size);

/**
 * ͷŵ̬ڵĳԱͷŶ̬
 * @param a {ACL_ARRAY*} ָ̬
 * @param free_fn {void (*)(void*)} ͷŶ̬ڳԱͷźָ
 */
ACL_API void acl_array_clean(ACL_ARRAY *a, void (*free_fn)(void *));

/**
 * ͷŵ̬ڵĳԱͷŶ̬
 * @param a {ACL_ARRAY*} ָ̬
 * @param free_fn {void (*)(void*)} ͷŶ̬ڳԱͷźָ
 */
ACL_API void acl_array_free(ACL_ARRAY *a, void (*free_fn)(void *));
#define acl_array_destroy acl_array_free

/**
 * ̬βӶ̬Ա
 * @param a {ACL_ARRAY*} ָ̬
 * @param obj {void*} ̬Ա
 * @return {int} >=0: ɹ, ֵΪԪе±λã-1: ʧ
 */
ACL_API int acl_array_append(ACL_ARRAY *a, void *obj);

/**
 * ̬ͷӶ̬Ա
 * @param a {ACL_ARRAY*} ָ̬
 * @param obj {void*} ̬Ա
 * @return {int} >=0: ɹ, ֵΪԪе±λã-1: ʧ
 */
ACL_API int acl_array_prepend(ACL_ARRAY *a, void *obj);

/**
 * ָ̬λǰӶ̬Ա(ý㼰Ժн㶼һλ)
 * @param a {ACL_ARRAY*} ָ̬
 * @param position {int} ĳλãԽ
 * @param obj {void*} ̬Ա
 * @return {int} 0: ɹ-1: ʧ
 */
ACL_API int acl_array_pred_insert(ACL_ARRAY *a, int position, void *obj);

/**
 * ָ̬λúӶ̬Ա(ýԺн㶼һλ)
 * @param a {ACL_ARRAY*} ָ̬
 * @param position {int} ĳλãԽ
 * @param obj {void*} ̬Ա
 * @return {int} 0: ɹ-1: ʧ
 */
ACL_API int acl_array_succ_insert(ACL_ARRAY *a, int position, void *obj);
#define acl_array_insert acl_array_succ_insert

/**
 * Ӷ̬еָλɾĳ̬, ɾԪصȺ˳򱣳ֲ,
 * ɾλмĳλãΪ˱֤Ԫص˳ԣڲɾԪغԪ
 * ǰһλ
 * @param a {ACL_ARRAY*} ָ̬
 * @param position {int} ĳλãԽ
 * @param free_fn {void (*)(void*)} ͷŶ̬ڳԱͷźָ룬
 *  ָΪգͷţô˺ͷŶ̬
 * @return {int} 0: ɹ-1: ʧ
 */
ACL_API int acl_array_delete_idx(ACL_ARRAY *a, int position, void (*free_fn)(void *));

/**
 * Ӷ̬еָλɾĳɾԪصȺ˳пܷ˸ı,
 * ΪɾԶԪλô
 * @param a {ACL_ARRAY*} ָ̬
 * @param position {int} ĳλãԽ
 * @param free_fn {void (*)(void*)} ͷŶ̬ڳԱͷźָ룬
 *  ָΪգͷţô˺ͷŶ̬
 * @return {int} 0: ɹ-1: ʧ
 */
ACL_API int acl_array_delete(ACL_ARRAY *a, int position, void (*free_fn)(void*));

/**
 * Ӷ̬ɾַָָĶ̬, ɾԪصȺ˳򱣳ֲ
 * ɾλмĳλãΪ˱֤Ԫص˳ڲɾԪغԪ
 * ǰһλ
 * @param a {ACL_ARRAY*} ָ̬
 * @param obj {void*} ַָ̬
 * @param free_fn {void (*)(void*)} ͷŶ̬ڳԱͷźָ룬
 *  ָΪգͷţô˺ͷŶ̬
 * @return {int} 0: ɹ-1: ʧ
 */
ACL_API int acl_array_delete_obj(ACL_ARRAY *a, void *obj, void (*free_fn)(void *));

/**
 * Ӷ̬ɾĳ±귶ΧĶ̬
 * @param a {ACL_ARRAY*} ָ̬
 * @param ibegin {int} ʼ±λ
 * @param iend {int} ±λ
 * @param free_fn {void (*)(void*)} ͷŶ̬ڳԱͷźָ룬
 *  ָΪգͷţô˺ͷŶ̬
 * @return {int} 0: ɹ-1: ʧ
 */
ACL_API int acl_array_delete_range(ACL_ARRAY *a, int ibegin, int iend, void (*free_fn)(void*));

/**
 * ƶ̬еĶ
 * @param a {ACL_ARRAY*} ָ̬
 * @param ito {int} ƶĿ±λ
 * @param ifrom {int} Ӵ±λÿʼƶ
 * @param free_fn {void (*)(void*)} ͷŶ̬ڳԱͷźָ룬
 *  ָΪգͷţô˺ͷŶ̬ͷŵĶ̬Ϊ
 *  [idx_obj_begin, idx_src_begin), Ϊһ뿪
 * @return {int} 0: ɹ-1: ʧ
 */
ACL_API int acl_array_mv_idx(ACL_ARRAY *a, int ito, int ifrom, void (*free_fn)(void *) );

/**
 * Ԥȱ֤̬Ŀռ䳤
 * @param a {ACL_ARRAY*} ָ̬
 * @param app_count {int} Ҫ̬ app_count λ
 * @return {int} 0: ɹ-1: ʧ
 */
ACL_API int acl_array_pre_append(ACL_ARRAY *a, int app_count);

/**
 * Ӷ̬еĳ±λȡ̬
 * @param a {ACL_ARRAY*} ָ̬
 * @param idx {int} ±λãԽ磬򷵻-1
 * @return {void*} != NULL: ɹ== NULL: ڻʧ
 */
ACL_API void *acl_array_index(const ACL_ARRAY *a, int idx);

/**
 * õǰ̬ж̬ĸ
 * @param a {ACL_ARRAY*} ָ̬
 * @return {int} ̬ж̬ĸ
 */
ACL_API int acl_array_size(const ACL_ARRAY *a);

#ifdef  __cplusplus
}
#endif

#endif

