#ifndef ACL_PROCTL_INCLUDE_H
#define ACL_PROCTL_INCLUDE_H

#include "stdlib/acl_define.h"
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * ȡƽ̵ִгڵ·λ
 * @param buf {char*} 洢ڴλ, صĽĽβ
 *   "\"  "/",磺"C:\\test_path\\test1_path", 
 *  "C:\\test_path\\test1_path\\"
 * @param size {size_t} buf ĿռС
 */
ACL_API void acl_proctl_daemon_path(char *buf, size_t size);

/**
 * ʼ̿ƿܣ acl_proctl_start Ҫ
 * @param progname {const char*} ƽ̽
 */
ACL_API void acl_proctl_deamon_init(const char *progname);

/**
 * ƽΪ̨Уӽ̵״̬
 * ӽ쳣˳ӽ
 */
ACL_API void acl_proctl_daemon_loop(void);

/**
 * ڿƽһӽ
 * @param progchild {const char*} ӽ̵ĳ
 * @param argc {int} argv ĳ
 * @param argv {char* []}
 * @return 0: ok; -1: error
 */
ACL_API int acl_proctl_deamon_start_one(const char *progchild, int argc, char *argv[]);

/**
 * ʽĳӽ
 * @param progname {const char*} ƽ̽
 * @param progchild {const char*} ӽ̽
 * @param argc {int} argv ĳ
 * @param argv {char* []} ݸӽ̵Ĳ
 */
ACL_API void acl_proctl_start_one(const char *progname,
	const char *progchild, int argc, char *argv[]);

/**
 * ʽֹͣĳӽ
 * @param progname {const char*} ƽ̽
 * @param progchild {const char*} ӽ̽
 * @param argc {int} argv ĳ
 * @param argv {char* []} ݸӽ̵Ĳ
 */
ACL_API void acl_proctl_stop_one(const char *progname,
	const char *progchild, int argc, char *argv[]);

/**
 * ʽֹͣеӽ
 * @param progname {const char*} ƽ̽
 */
ACL_API void acl_proctl_stop_all(const char *progname);

/**
 * ʽ֪ͨƽֹͣеӽ̣ӽ˳ƽҲԶ˳
 * @param progname {const char*} ƽ̽
 */
ACL_API void acl_proctl_quit(const char *progname);

/**
 * гǰеķ
 * @param progname {const char*} ƽ̽
 */
ACL_API void acl_proctl_list(const char *progname);

/**
 * ̽ĳǷ
 * @param progname {const char*} ƽ̽
 * @param progchild {const char*} ӽ̽
 */
ACL_API void acl_proctl_probe(const char *progname, const char *progchild);

/**
 * ӽ̵ýӿڣͨ˽ӿ븸֮佨/ƹϵ
 * @param progname {const char*} ӽ̽
 * @param onexit_fn {void (*)(void*)} ǿӽ˳ʱõĻص
 * @param arg {void*} onexit_fn ֮һ
 */
ACL_API void acl_proctl_child(const char *progname, void (*onexit_fn)(void *), void *arg);

#ifdef __cplusplus
}
#endif

#endif
