#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <stdarg.h>
#include "acl_cpp/stdlib/string.hpp"
#include "acl_cpp/stream/aio_handle.hpp"
#include "acl_cpp/stream/aio_timer_callback.hpp"
#include "acl_cpp/stream/aio_stream.hpp"

namespace acl
{

class aio_ostream;

/**
 * ӳ첽д࣬Ϊ aio_timer_callback (see aio_handle.hpp)
 * νӳ첽дǰ첽д(aio_ostream)ڶʱУ
 * 첽д( aio_handle ļн)ָ
 * ʱ䵽첽д( timer_callback ص½첽
 * 첽д)ͬʱöʱԶ( destroy )
 * û̳ aio_timer_writer ࣬಻ڶϷģ
 *  destroyͬʱ destroy ִԴͷŵ
 * زδ destroy򵱶ʱڲԶ
 *  aio_timer_writer  destroy-- delete thisʱ
 * ᵼ·ǷڴͷŲ)
 * 
 */
class ACL_CPP_API aio_timer_writer : public aio_timer_callback
{
public:
	aio_timer_writer();

	/**
	 *  aio_istream еô˺ͷӦʵָú
	 */
	virtual void destroy()
	{
		delete this;
	}

protected:
	virtual ~aio_timer_writer();

	/**
	 * ӳٶʱĻص aio_timer_callback м̳ж
	 */
	virtual void timer_callback(unsigned int id);
private:
	friend class aio_ostream;

	aio_ostream* out_;
	//int   write_delayed_;
	acl::string buf_;
};

/**
 * 첽дඨ壬ֻڶϱʵʱҪ close
 * ͷŸ
 */
class ACL_CPP_API aio_ostream : virtual public aio_stream
{
public:
	/**
	 * 캯
	 * @param handle {aio_handle*} 첽¼
	 */
	aio_ostream(aio_handle* handle);

	/**
	 * дʱĻصָ룬ûصѾڣֻ
	 * ʹöڴ򿪿״̬
	 * @param callback {aio_callback*} ̳ aio_callback ص
	 *  첽ʱȵô˻صе write_callback ӿ
	 */
	void add_write_callback(aio_callback* callback);

	/**
	 * дص󼯺ɾ
	 * @param callback {aio_callback*} ɾдص
	 *  ֵΪգɾеĻصд
	 * @return {int} رӻص󼯺ɾĻصĸ
	 */
	int del_write_callback(aio_callback* callback = NULL);

	/**
	 * ֹص༯еĳص󣬵ӻص
	 * ɾֻǲö
	 * @param callback {aio_callback*} õдص
	 *  ֵΪգедص
	 * @return {int} رӻص󼯺нõĻصĸ
	 */
	int disable_write_callback(aio_callback* callback = NULL);

	/**
	 * еĻص󱻵
	 * @param callback {aio_callback*} ָдص
	 *  ֵΪգедص
	 * @return {int} رõдصĸ
	 */
	int enable_write_callback(aio_callback* callback = NULL);

	/**
	 * 첽д涨ֽݣȫдɹʱʱ
	 * ûעĻصӳ첽дʱһ
	 * ô˹ʱÿӳ첽дᱻӳд
	 * ĶУԱ֤ÿӳ첽дڸԵĶʱ
	 * ʱִ
	 * @param data {const void*} ݵַ
	 * @param len {int} ݳ
	 * @param delay {int64} ֵ > 0 ӳٷ͵ģʽ(λΪ΢)
	 * @param callback {aio_timer_writer*} ʱʱĻص
	 */
#ifdef WIN32
	void write(const void* data, int len, __int64 delay = 0,
		aio_timer_writer* callback = NULL);
#else
	void write(const void* data, int len, long long int delay = 0,
		aio_timer_writer* callback = NULL);
#endif

	/**
	 * ʽʽ첽дݣȫдɹʱʱ
	 * ûעĻص
	 * @param fmt {const char*} ʽַ
	 */
	void format(const char* fmt, ...) ACL_CPP_PRINTF(2, 3);

	/**
	 * ʽʽ첽дݣȫдɹʱʱ
	 * ûעĻص
	 * @param fmt {const char*} ʽַ
	 * @param ap {va_list} ֵб
	 */
	void vformat(const char* fmt, va_list ap);

	/**
	 * 첽ȴдú첽д״̬пдʱ
	 * صûԼݵĶȡ
	 * @param timeout {int} дʱʱ()ֵΪ 0 ʱûдʱ
	 */
	void write_wait(int timeout = 0);

	/**
	 * ֹ첽첽д״̬򽫸첽첽ļ
	 * ¼ƳֱûκһдʱԶ
	 * д״̬(ʱ±첽)
	 */
	void disable_write();
protected:
	virtual ~aio_ostream();

	/**
	 * ͷŶ̬麯
	 */
	virtual void destroy();

	/**
	 * hook д
	 */
	void hook_write();

private:
	friend class aio_timer_writer;
	std::list<aio_timer_writer*> timer_writers_;
	std::list<AIO_CALLBACK*> write_callbacks_;
	bool write_hooked_;

	static int write_callback(ACL_ASTREAM*, void*);
	static int write_wakup(ACL_ASTREAM*, void*);
};

}  // namespace acl
