#pragma once

struct ACL_SCAN_DIR;

namespace acl
{

class string;

class ACL_CPP_API scan_dir
{
public:
	scan_dir();
	~scan_dir();

	/**
	 * Ŀ¼
	 * @param path {const char*} Ŀ¼·ǿָ
	 * @param recursive {bool} ǷݹɨĿ¼
	 * @return {bool} Ŀ¼Ƿɹ
	 */
	bool open(const char* path, bool recursive = true);

	/**
	 * رĿ¼ͬʱͷڲԴ
	 */
	void close();

	/**
	 * ɨһļ(Ŀ¼Զ) open ָݹɨѡ
	 * ( recursive = true)úݹɨĿ¼Ŀ¼
	 * @param full {bool} ǷҪļȫ·
	 * @return {const char*}  NULL ʾɨ赽ļʾɨ
	 *  Ŀ¼δ
	 */
	const char* next_file(bool full = false);

	/**
	 * ɨһĿ¼(ļ "."  ".." ) open ָ
	 * ݹɨ( recursive = true)úݹɨĿ¼
	 * Ŀ¼
	 * @param full {bool} ǷҪĿ¼ȫ·
	 * @return {const char*}  NULL ʾɨ赽Ŀ¼ʾɨ
	 *  ϻĿ¼δ
	 */
	const char* next_dir(bool full = false);

	/**
	 * ɨһĿ¼ļ open ָݹɨ( resursive
	 * = true)úݹɨĿ¼Ŀ¼ļ
	 * @param full {bool} ǷҪĿ¼ļȫ·Ϊ true 
	 *  ȫ·ֻļĿ¼Ҷ·
	 * @param is_file {bool*} ؽǿʱõַ洢ֵʾɨ赽
	 *  ǷļΪ true ΪļΪĿ¼
	 * @return {const char*}  NULL ʾɨ赽Ŀ¼ļ
	 *  ʾɨϻĿ¼δ 
	 */
	const char* next(bool full = false, bool* is_file = NULL);

	/**
	 * õǰɨڵĿ¼·ص·β·ָ '/'
	 *  '\\' (win32)·/home/zsx/᷵ /home/zsx
	 * ·Ϊ·/  '/' ᱣ WIN32 £
	 * C:\Users\zsx ·
	 * @return {const char*} Ŀ¼ʱúطǿָ룬򷵻 NULL
	 */
	const char* curr_path();

	/**
	 * õǰɨɨļ
	 * @param full {bool} ǷҪͬʱļȫ·
	 * @return {bool} Ŀ¼δҿǰɨĲļ򷵻 NULL
	 */
	const char* curr_file(bool full = false);

	/**
	 * صǰѾɨĿ¼ĸ
	 * @return {size_t}
	 */
	size_t dir_count() const;

	/**
	 * صǰѾɨļĸ
	 * @return {size_t}
	 */
	size_t file_count() const;

#ifdef WIN32
	/**
	 * õǰѾɨļĿ¼Сܺ
	 * @return {acl_uint64}
	 */
	unsigned __int64 scaned_size() const;

	/**
	 * open ɹñͳƸĿ¼ļĿ¼Сܺ
	 * @param nfiles {int*} ǿʱ洢ɾļ
	 * @param ndirs {int*} ǿʱ洢ɾĿ¼
	 * @return {acl_uint64} Ŀ¼ļĿ¼Сܺ
	 */
	unsigned __int64 all_size(int* nfiles = NULL, int* ndirs = NULL) const;

	/**
	 * Ŀ¼ļĿ¼Сܺ
	 * @param path {const char*} ҪɾĸĿ¼
	 * @param recursive {bool} ǷݹɨĿ¼
	 * @param nfiles {int*} ǿʱ洢ɾļ
	 * @param ndirs {int*} ǿʱ洢ɾĿ¼
	 * @return {acl_uint64} Ŀ¼ļĿ¼Сܺ
	 */
	static unsigned __int64 all_size(const char* path, bool recursive = true,
		int* nfiles = NULL, int* ndirs = NULL);

	/**
	 * open ɹñɾĿ¼µļĿ¼
	 * @param nfiles {int*} ǿʱ洢ɾļ
	 * @param ndirs {int*} ǿʱ洢ɾĿ¼
	 * @return {acl_unint64} ɾļĿ¼Сܺ(ֽڵλ)
	 */
	unsigned __int64 remove_all(int* nfiles = NULL, int* ndirs = NULL) const;

	/**
	 * ɾĿ¼µļĿ¼
	 * @param path {const char*} ҪɾĸĿ¼
	 * @param recursive {bool} ǷݹɨĿ¼
	 * @param nfiles {int*} ǿʱ洢ɾļ
	 * @param ndirs {int*} ǿʱ洢ɾĿ¼
	 * @return {acl_unint64} ɾļĿ¼Сܺ(ֽڵλ)
	 */
	static unsigned __int64 remove_all(const char* path, bool recursive = true,
		int* nfiles = NULL, int* ndirs = NULL);
#else
	unsigned long long scaned_size() const;
	unsigned long long all_size(int* nfiles = NULL, int* ndirs = NULL) const;
	static unsigned long long all_size(const char* path, bool recursive = true,
		int* nfiles = NULL, int* ndirs = NULL);
	unsigned long long remove_all(int* nfiles = NULL, int* ndirs = NULL) const;
	static unsigned long long remove_all(const char* path, bool recursive = true,
		int* nfiles = NULL, int* ndirs = NULL);
#endif

	/**
	 * õǰе·
	 * @param out {string&} 洢
	 * @return {bool} Ƿɹõǰ·
	 */
	static bool get_cwd(string& out);

private:
	char* path_;
	ACL_SCAN_DIR* scan_;
	string* path_buf_;
	string* file_buf_;
};

}  // namespace acl
