#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stream/aio_listen_stream.hpp"

namespace acl {

class aio_handle;
class aio_listen_stream;

/**
 * 첽Ϣˣ
 */
class ACL_CPP_API ipc_server : private aio_accept_callback
{
public:
	ipc_server();

	virtual ~ipc_server();

	/**
	 * 첽
	 * @param handle {aio_handle*} 첽ǿ
	 * @param addr {const char*} ַ
	 * @return {bool} Ƿɹ
	 */
	bool open(aio_handle* handle, const char* addr = "127.0.0.1:0");

	/**
	 *  open ɹͨ˺üַ
	 * @return {const char*} ַʽΪ IP:PORT
	 */
	const char* get_addr() const;

	/**
	 * 첽
	 * @return {aio_listen_stream*}
	 */
	aio_listen_stream* get_stream() const;

	/**
	 * 첽
	 */
	aio_handle& get_handle() const;

protected:
	/**
	 * ɹ򿪺Ļص
	 * @param addr {const char*} ʵʵļַʽIP:PORT
	 */
	virtual void on_open(const char*addr)
	{
		(void) addr;
	}

	/**
	 * رʱĻص
	 */
	virtual void on_close() {}

	/**
	 * 첽һͻӺĻص
	 * @param client {aio_socket_stream*} ͻ IPC 
	 */
	virtual void on_accept(aio_socket_stream* client)
	{
		(void) client;
	}

#ifdef WIN32
	/**
	 * ڻ WIN32 Ϣ open ʱڲ
	 * Զ create_windows 
	 */
	virtual bool create_window()
	{
		return false;
	}
#endif

private:
	aio_handle* handle_;
	aio_listen_stream* sstream_;

	/**
	 * 麯ӵô˻ص
	 * @param client {aio_socket_stream*} 첽ͻ
	 * @return {bool}  true ֪ͨ
	 */
	virtual bool accept_callback(aio_socket_stream* client);

	/**
	 * 麯رʱĻص
	 */
	virtual void close_callback();

	/**
	 * 麯ʱĻص
	 */
	virtual bool timeout_callback();
};

}  // namespace acl
