#pragma once
#include "acl_cpp/acl_cpp_define.hpp"

struct HTTP_HDR_RES;
struct HTTP_RES;
struct HTTP_HDR_REQ;
struct HTTP_REQ;

namespace acl {

class string;
class zlib_stream;
class socket_stream;
class ostream;
class istream;
class http_header;

/**
 * ô1 HTTP ͻʱ2 HTTP ˽
 *  HTTP ͻʱһӦ HTTP ͻ
 * ÿͻֳ֧
 */
class ACL_CPP_API http_client
{
public:
	/**
	 * ȱʡĹ캯ʹô˹캯 HTTP ͻ˶Ҫʾ
	 *  http_client::open 
	 */
	http_client(void);

	/**
	 * Ѿӳɹ󴴽 HTTP ͻ˶󣬵Ҫעǣ
	 *  http_client ʱ client 󲢲ᱻ٣
	 * ҪӦԼ٣Դй¶
	 * @param client {socket_stream*} HTTP 󣬿˵
	 *  ҲӦ˵ڱʱ󲢲ᱻ٣
	 *  ûͷ֮
	 * @param rw_timeout {int} IO дʱʱ()
	 * @param is_request {bool} ˻Ӧ˵Ŀͻ
	 * @param unzip {bool} ȡӦʱص
	 *  ΪѹʱòڵĺʱǷԶѹ:
	 *  read_body(string&, bool, int*)
	 */
	http_client(socket_stream* client, int rw_timeout = 120,
		bool is_request = false, bool unzip = true);

	virtual ~http_client(void);

	/**
	 * ֳ֧ӵĶУֹô˺мݶ
	 * ȻⲻǱģΪڶε read_head ʱread_head Զ
	 *  reset ϴеǼ
	 */
	void reset(void);

	/**
	 * Զ HTTP 
	 * @param addr {const char*} ַʽIP:PORT  DOMAIN:PORT
	 * @param conn_timeout {int} ӳʱʱ()
	 * @param rw_timeout {int} дʱʱ()
	 * @param unzip {bool} صΪѹʱǷԶѹ
	 * @return {bool} Ƿɹ
	 */
	bool open(const char* addr, int conn_timeout = 60, int rw_timeout = 60,
		bool unzip = true);

	/**
	 * д HTTP ͷ
	 * @param header {http_header&}
	 * @return {int} ʵд,  -1 ʾ
	 */
	int write_head(const http_header& header);

	/**
	 *  HTTP 壬ѭô˺ڵһε write д
	 * HTTP ͷʱ chunked ䷽ʽڲԶ chunked ䷽ʽ; 
	 * ⣬ʹ chunked ʽʱӦٵһαҲ
	 * Ϊ 0 ʾݽ
	 * @param data {const void*} ݵַ
	 * @param len {size_t} data ݳ
	 * @return {bool} Ƿɹ false ʾж
	 */
	bool write_body(const void* data, size_t len);

	/**
	 *  http_client(socket_stream*, bool) 캯
	 *  http_client(void) ͬʱ open ʱ
	 * Եñ
	 * @return {ostream&} ãڣ
	 *  ڲԶԣʾʹӦȽ
	 */
	ostream& get_ostream(void) const;

	/**
	 *  http_client(socket_stream*, bool) 캯
	 *  http_client(void) ͬʱ open ʱ
	 * Եñ
	 * @return {istream&} ãڣ
	 *  ڲԶԣʾʹӦȽ
	 */
	istream& get_istream(void) const;

	/**
	 *  http_client(socket_stream*, bool) 캯
	 *  http_client(void) ͬʱ open ʱ
	 * Եñ
	 * @return {socket_stream&} ãڣ
	 *  ڲԶԣʾʹӦȽ
	 */
	socket_stream& get_stream(void) const;

	/**
	 *  HTTP ȡӦͷݻ HTTP ͻ˶ȡݣ
	 * ڳӵĶУԶϴεмݶ
	 * @return {bool} Ƿɹ
	 */
	bool read_head(void);

	/**
	 *  HTTP Ӧ峤
	 * @return {int64) ֵΪ -1  HTTP ͷڻûгֶ
	 */
#ifdef WIN32
	__int64 body_length(void) const;
#else
	long long int body_length(void) const;
#endif

	/**
	 * HTTP (ӦǷֳ)
	 * @return {bool}
	 */
	bool keep_alive(void) const;

	/**
	 *  HTTP ͷӦͷĳֵֶֶ
	 * @param name {const char*} ֶ
	 * @return {const char*} ֵֶΪʱʾ
	 */
	const char* header_value(const char* name) const;

	/**
	 *  HTTP ص HTTP Ӧ״̬
	 * 1xx, 2xx, 3xx, 4xx, 5xx
	 * @return {int} ֵΪ -1 ʾûỰ
	 *   HTTP ݹ
	 */
	int response_status(void) const;

	/**
	 *  HTTP ͻ HOST ֵֶ
	 * @return {const char*}  NULL ʾڸֶ
	 */
	const char* request_host(void) const;

	/**
	 *  HTTP ͻ PORT ˿ں
	 * @return {int}  -1 ʾ
	 */
	int request_port(void) const;

	/**
	 *  HTTP ͻ HTTP GET, POST, CONNECT
	 * @return {const char*} ֵΪձʾ
	 */
	const char* request_method(void) const;

	/**
	 *  HTTP ͻ URL гȥ HTTP://domain 
	 * 磺 http://test.com.cn/cgi-bin/test?name=value
	 * Ӧ÷أ/cgi-bin/test?name=value
	 * @return {const char*}  NULL ʾ
	 */
	const char* request_url(void) const;

	/**
	 *  HTTP ͻ URL е·()
	 * 磺 http://test.com.cn/cgi-bin/test?name=value
	 * Ӧ÷أ/path/test.cgi
	 * @return {const char*}  NULL ʾ
	 */
	const char* request_path(void) const;

	/**
	 *  HTTP ͻ URL ев磺
	 * http://test.com.cn/cgi-bin/test?name=valueúӦ÷أ
	 * name=value
	 * @return {const char*}  NULL ʾ
	 */
	const char* request_params(void) const;

	/**
	 *  HTTP ͻ URL ָĲֵ磺
	 * http://test.com.cn/cgi-bin/test?name=valueͨú
	 *  name ֵΪ value
	 * @param name {const char*} 
	 * @return {const char*} ֵ NULL ʾ
	 */
	const char* request_param(const char* name) const;

	/**
	 *  HTTP ͻͷе cookie ֵ
	 * @param name {const char*} cookie 
	 * @return {const char*} cookie ֵ NULL ʾ
	 */
	const char* request_cookie(const char* name) const;

	/**
	 *  HTTP ȡӦݻ HTTP ͻ˶ȡݣ
	 * ˺յݽнѹ
	 * @param out {string&} 洢Ļ
	 * @param clean {bool} ڽǰǷԶ buf 
	 * @param real_size {int*} ָǿգ¼ݳȣ
	 *  ָͨ뷵صֵԶ >= 0
	 * @return {int} ֵ£
	 *  > 0: ʾѾݣݻδ
	 *  == 0: ֵΪֵԵ disconnected()жǷѾ
	 *  رգ body_finish жǷѾ HTTP ӦݣѾ
	 *  δرգ򻹿Լֳ
	 *  < 0: ʾӹر
	 * עread_body ܻã
	 *     Ϊѹʱ򷵻صֵΪѹݳ
	 */
	int read_body(string& out, bool clean = true, int* real_size = NULL);
	
	/**
	 *  HTTP ȡӦݻ HTTP ͻ˶ȡݣ
	 * úܶݽнѹ
	 * @param buf {char*} 洢ĻΪ
	 * @param size {size_t} buf 
	 * @return {int} ֵ£
	 *  > 0: ʾѾݣݻδ
	 *  == 0: ʾѾ HTTP ӦݣӲδر
	 *  < 0: ʾӹر
	 */
	int read_body(char* buf, size_t size);

	/**
	 *  HTTP Ӧݻͻжȡһݣ˺ڲԭʼ
	 * нѹѭô˺ֱú false  body_finish() 
	 * true Ϊֹú false ʱʾѾرգ true ʱʾ
	 * һݣʱͨж body_finish() ֵжǷѾ
	 * @param out {string&} 洢ĻڸúڲԶû
	 *  ûڵøúǰûе(ɵ:out.clear())
	 * @param nonl {bool} ȡһʱǷԶȥβ "\r\n"  "\n"
	 * @param size {size_t*} һʱŸݵĳȣһ
	 *   nonl Ϊ true ʱֵΪ 0
	 * @return {bool} Ƿһݣú false ʱʾϻ
	 *  ûжһݣ true ʾһݣһʱ
	 *  úҲ᷵ trueֻ *size = 0
	 */
	bool body_gets(string& out, bool nonl = true, size_t* size = NULL);

	/**
	 * жǷѾ HTTP Ӧ
	 * @return {bool}
	 */
	bool body_finish(void) const;

	/**
	 * жǷѾر
	 * @return {bool}
	 */
	bool disconnected(void) const;

	/**
	 * ȡͨ read_head  HTTP Ӧͷҵ뻺
	 * ǿʱ HTTP Ӧͷݿ
	 * @param buf {string*} ǿʱ洢 HTTP Ӧͷ
	 * @return {const HTTP_HDR_RES*} HTTP ӦͷΪգ˵
	 *  δӦͷ
	 */
	HTTP_HDR_RES* get_respond_head(string* buf);

	/**
	 * ȡͨ read_head  HTTP ͷҵ뻺
	 * ǿʱ HTTP ͷݿ
	 * @param buf {string*} ǿʱ洢 HTTP ͷ
	 * @return {const HTTP_HDR_REQ*} HTTP ͷΪգ˵
	 *  δͷ
	 */
	HTTP_HDR_REQ* get_request_head(string* buf);

	/**
	 * ص HTTP ӦͷϢ׼
	 * @param prompt {const char*} ǿͬ HTTP ͷϢһ
	 */
	void print_header(const char* prompt);

	/**
	 * ص HTTP ӦͷϢ
	 * @param out {ostream&} ļҲ
	 * @param prompt {const char*} ǿͬ HTTP ͷϢһ
	 */
	void fprint_header(ostream& out, const char* prompt);

	/**
	 * ص HTTP ӦͷϢ
	 * @param out {string&} 洢ݻ
	 * @param prompt {const char*} ǿͬ HTTP ͷϢһ
	 */
	void sprint_header(string& out, const char* prompt);

private:
	socket_stream* stream_;     // HTTP 
	bool stream_fixed_;         // Ƿͷ stream_ 

	HTTP_HDR_RES* hdr_res_;     // HTTP ͷӦ
	struct HTTP_RES* res_;      // HTTP Ӧ
	HTTP_HDR_REQ* hdr_req_;     // HTTP ͷ
	struct HTTP_REQ* req_;      // HTTP 
	int  rw_timeout_;           // IO дʱʱ
	bool unzip_;                // Ƿѹݽнѹ
	zlib_stream* zstream_;      // ѹ
	bool is_request_;           // Ƿǿͻ
	int  gzip_header_left_;     // gzip ͷʣĳ
	int  last_ret_;             // ݶ¼ķֵ
	bool body_finish_;          // ǷѾ HTTP Ӧ
	bool disconnected_;         // ǷѾر
	bool chunked_transfer_;     // ǷΪ chunked ģʽ
	string* buf_;               // ڲڰжȲ

	bool read_request_head(void);
	bool read_response_head(void);
	int  read_request_body(char* buf, size_t size);
	int  read_response_body(char* buf, size_t size);
	int  read_request_body(string& out, bool clean, int* real_size);
	int  read_response_body(string& out, bool clean, int* real_size);
};

}  // namespace acl
