#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <vector>
#include "acl_cpp/stdlib/string.hpp"

namespace acl {

/**
 * ݿѯм¼Ͷ
 */
class ACL_CPP_API db_row
{
public:
	/**
	 * 캯
	 * @param names {const std::vector<const char*>&} ݿֶб
	 */
	db_row(const std::vector<const char*>& names);
	~db_row();

	/**
	 * ȡݱеĳӦ±ֵֶ
	 * @param ifield {size_t} ±ֵ
	 * @return {const char*} ؿ˵±ֵԽ
	 */
	const char* field_name(size_t ifield) const;

	/**
	 * Ӳѯļ¼иֶȡӦֵֶ
	 * @param name {const char*} ݱֶ
	 * @return {const char*} ӦֵֶΪʾֵֶڻ
	 *  ֶǷ
	 */
	const char* field_value(const char* name) const;

	/**
	 * Ӳѯļ¼иֶȡӦֵֶ
	 *  field_value ͬ
	 * @param name {const char*} ݱֶ
	 * @return {const char*} ӦֵֶΪʾֵֶڻ
	 *  ֶǷ
	 */
	const char* operator[](const char* name) const;

	/**
	 * Ӳѯļ¼ȡöӦ±ֵֶ
	 * @param ifield {size_t} ±ֵֵӦ < ֶĸ
	 * @return {const char*} ӦֵֶΪʾ±ֵǷ
	 *  ֵֶ
	 */
	const char* field_value(size_t ifield) const;

	/**
	 * Ӳѯļ¼ȡöӦ±ֵֶ field_value ͬ
	 * @param ifield {size_t} ±ֵֵӦ < ֶĸ
	 * @return {const char*} ӦֵֶΪʾ±ֵǷ
	 *  ֵֶ
	 */
	const char* operator[](size_t ifield) const;

	/**
	 * Ӳѯļ¼ȡöӦ±͵ֵֶ
	 * @param ifield {size_t} ±ֵ
	 * @param null_value {int} ΪʱشֵʾδӦ
	 * @return {int} ֵû null_value ֵͬʱûв鵽
	 */
	int field_int(size_t ifield, int null_value = 0) const;

	/**
	 * Ӳѯļ¼ȡֶ͵ֵֶ
	 * @param name {const char*} ±ֵ
	 * @param null_value {int} ΪʱشֵʾδӦ
	 * @return {int} ֵû null_value ֵͬʱûв鵽
	 */
	int field_int(const char* name, int null_value = 0) const;

	
	/**
	 * Ӳѯļ¼ȡöӦ±͵ֵֶ
	 * @param ifield {size_t} ±ֵ
	 * @param null_value {acl_int64} ΪʱشֵʾδӦ
	 * @return {acl_int64} ֵû null_value ֵͬʱûв鵽
	 */
#ifdef WIN32
	__int64 field_int64(size_t ifield, __int64 null_value = 0) const;
#else
	long long int field_int64(size_t ifield, long long int null_value = 0) const;
#endif

	/**
	 * Ӳѯļ¼ȡֶ͵ֵֶ
	 * @param name {const char*} ±ֵ
	 * @param null_value {acl_int64} ΪʱشֵʾδӦ
	 * @return {acl_int64} ֵû null_value ֵͬʱûв鵽
	 */
#ifdef WIN32
	__int64 field_int64(const char* name, __int64 null_value = 0) const;
#else
	long long int field_int64(const char* name, long long int null_value = 0) const;
#endif

	/**
	 * Ӳѯļ¼ȡöӦ±ַ͵ֵֶ
	 * @param ifield {size_t} ±ֵ
	 * @return {const char*} ֵ NULL ʱûв鵽
	 */
	const char* field_string(size_t ifield) const;

	/**
	 * Ӳѯļ¼ȡֶַ͵ֵֶ
	 * @param name {const char*} ±ֵ
	 * @return {const char*} ֵ NULL ʱûв鵽
	 */
	const char* field_string(const char* name) const;

	/**
	 * ¼һֵֵֶֶ˳Ӧֶ˳һ
	 * @param value {const char*} м¼ĳֵֶ
	 */
	void push_back(const char* value);

	/**
	 * м¼ֵֶĸ
	 * @return {size_t}
	 */
	size_t length() const;
protected:
private:
	// ݱֶϵ
	const std::vector<const char*>& names_;

	// ݽеֶμ
	std::vector<const char*> values_;
};

/**
 * ݿѯм¼Ͷ
 */
class ACL_CPP_API db_rows
{
public:
	db_rows();
	virtual ~db_rows();

	/**
	 * Ӳѯм¼иݱֶӦֵֶȡ¼
	 * @param name {const char*} ݱֶ(ִСд)
	 * @param value {const char*} ݱֵֶ(ִСд)
	 * @return {const std::vector<const db_row*>&} м¼Ͷ
	 *  ͨ db_rows.empty() жϽǷΪ
	 */
	const std::vector<const db_row*>& get_rows(
		const char* name, const char* value);

	/**
	 * ȡеĲѯ
	 * @return {const std::vector<db_row*>&} м¼Ͷ
	 *  ͨ db_rows.empty() жϽǷΪ
	 */
	const std::vector<db_row*>& get_rows() const;

	/**
	 * Ӳѯм¼и±ȡöӦĳм¼
	 * @param idx {size_t} ±ֵ꣬Ӧ < С
	 * @return {const db_row*} ؿձʾ±ֵǷֵֶ
	 *  Ϊ
	 */
	const db_row* operator[](size_t idx) const;

	/**
	 * жϽǷΪ
	 * @return {bool} ǷΪ
	 */
	bool empty() const;

	/**
	 * м¼
	 * @return {size_t} м¼
	 */
	size_t length() const;
protected:
	// ݱֶ
	std::vector<const char*> names_;

	// ѯмϣеԪ db_row Ƕ̬ӽȥģ
	// ΪڱʱԶ delete rows_ еԪض
	std::vector<db_row*> rows_;

	// ʱм
	std::vector<const db_row*> rows_tmp_;
private:
};

class db_pool;
class query;

/**
 * ݿ
 */
class ACL_CPP_API db_handle
{
public:
	db_handle(void);
	virtual ~db_handle(void);

	/**
	 * ݿ
	 * @return {const char*}
	 */
	virtual const char* dbtype() const = 0;

	/**
	 * ϴݿĳ
	 * @return {int}
	 */
	virtual int get_errno() const
	{
		return -1;
	}

	/**
	 * ϴݿĳ
	 * @return {const char*}
	 */
	virtual const char* get_error() const
	{
		return "unkonwn error";
	}

	/**
	 * ӿڣʵִ˽ӿڴݿ
	 * @param local_charset {const char*} ַ(GBK, UTF8, ...)
	 * @return {bool} Ƿɹ
	 */
	virtual bool open(const char* local_charset = "GBK") = 0;

	/**
	 * ݿǷѾ
	 * @return {bool}  true ݿѾ
	 */
	virtual bool is_opened() const = 0;

	/**
	 * ӿڣʵִ˽ӿжݱǷ
	 * @return {bool} Ƿ
	 */
	virtual bool tbl_exists(const char* tbl_name) = 0;

	/**
	 * ӿڣʵִ˽ӿڹرݿ
	 * @return {bool} رǷɹ
	 */
	virtual bool close() = 0;

	/**
	 * ӿڣʵִ˽ӿִ SQL 
	 * @param sql {const char*} ׼ SQL 䣬ǿգһҪע
	 *  SQL 뾭ת崦Էֹ SQL ע빥
	 * @return {bool} ִǷɹ
	 */
	virtual bool sql_select(const char* sql) = 0;

	/**
	 * ӿڣʵִ˽ӿִ SQL 
	 * @param sql {const char*} ׼ SQL 䣬ǿգһҪע
	 *  SQL 뾭ת崦Էֹ SQL ע빥
	 * @return {bool} ִǷɹ
	 */
	virtual bool sql_update(const char* sql) = 0;

	/**
	 * ȫõĲѯ̣ô˺ܵͬ sql_selectֻǲѯ query
	 *  sql ǰȫģԷֹ sql ע
	 * @param query {query&}
	 * @return {bool} ִǷɹ
	 */
	bool exec_select(query& query);

	/**
	 * ȫõĸ¹̣ô˺ܵͬ sql_updateֻǲѯ query
	 *  sql ǰȫģԷֹ sql ע
	 * @param query {query&}
	 * @return {bool} ִǷɹ
	 */
	bool exec_update(query& query);

	/**
	 * ӿڣΪֹ sql ע룬ûӦֶַεô˺һЩ
	 * ַת壬ýӿڶԳַת壬ҲʵԼ
	 * ת巽
	 * @param in {const char*} ַ
	 * @param len {size_t} ַ
	 * @param out {string&} 洢ת
	 * @return {string&} Ӧ÷ĻãԱûƴ
	 *  SQL ʱȽϷ
	 */
	virtual string& escape_string(const char* in, size_t len, string& out);

	/**
	 * ϴ sql Ӱļ¼
	 * @return {int} Ӱ-1 ʾ
	 */
	virtual int affect_count() const = 0;

	/////////////////////////////////////////////////////////////////////

	/**
	 * ִ SQL Ľ
	 * @return {const db_rows*}ؽǿգҪ
	 *  free_result() ͷŽ
	 */
	const db_rows* get_result() const;

	/**
	 * Ӳѯм¼иݱֶӦֵֶȡ¼
	 * @param name {const char*} ݱֶ(ִСд)
	 * @param value {const char*} ݱֵֶ(ִСд)
	 * @return {const std::vector<const db_row*>*} м¼Ͷ
	 *  ؽǿգ free_result() ͷŽ
	 */
	const std::vector<const db_row*>* get_rows(
		const char* name, const char* value);

	/**
	 * ȡеĲѯ
	 * @return {const std::vector<db_row*>*} м¼Ͷ
	 *  ؽǿգ free_result() ͷŽ
	 */
	const std::vector<db_row*>* get_rows() const;

	/**
	 * ִ SQL ĵһнΨһݲѯʱԵñȽϱЩ
	 * @return {const db_row*} ؿձʾѯΪգؽǿգ
	 *   free_result() ͷмĽڴ棬ڴй¶
	 */
	const db_row* get_first_row() const;

	/**
	 * ͷϴβѯĽѯɺ󣬱øúͷ
	 * βѯĽúεò޺Ϊһ
	 * ʱԶڲ result_ ÿ
	 */
	void free_result();

	/**
	 * ĳӦ±ֵм¼
	 * @param idx {size_t} ±ֵСڲѯ
	 * @return {const db_row*} Ϊգп±Խ磬
	 *  ҲпǽΪ
	 */
	const db_row* operator[](size_t idx) const;

	/**
	 * ȡòѯ(sql_select)м¼
	 * @return {size_t} м¼Ϊ 0 ʾΪ
	 */
	size_t length() const;

	/**
	 * ѯ(sql_select)ִǷΪ
	 * @return {bool}  true ʾѯΪ
	 */
	bool empty() const;

	/**
	 * ݿѯ
	 * @param max {size_t} Ļм¼ֵƣֵΪ 0
	 *  еĽ
	 */
	void print_out(size_t max = 0) const;

	/////////////////////////////////////////////////////////////////
	/**
	 * ñʵΨһ ID
	 * @param id {const char*} Ψһ ID
	 * @return {db_handle&}
	 */
	db_handle& set_id(const char* id);

	/**
	 * ñʵΨһ ID
	 * @return {const char*} ΪʱʾδùΨһID
	 */
	const char* get_id() const
	{
		return id_;
	}

	/**
	 * ñݿӾǰʹõʱ
	 * @param now {time_t}
	 * @return {db_handle&}
	 */
	db_handle& set_when(time_t now);

	/**
	 * øӾϴαʹõʱ
	 * @return {time_t}
	 */
	time_t get_when() const
	{
		return when_;
	}
protected:
	// ʱ
	db_rows* result_;

	// ʵΨһ ID
	char* id_;

	// ݿӾʹõʱ
	time_t when_;
};

} // namespace acl
