#include "stdafx.h"
#include "rpc_manager.h"
#include "master_service.h"

////////////////////////////////////////////////////////////////////////////////
// 

char *var_cfg_str;
acl::master_str_tbl var_conf_str_tab[] = {
	{ "str", "test_msg", &var_cfg_str },

	{ 0, 0, 0 }
};

int   var_cfg_bool;
acl::master_bool_tbl var_conf_bool_tab[] = {
	{ "bool", 1, &var_cfg_bool },

	{ 0, 0, 0 }
};

int   var_cfg_thread_pool_limit;
int   var_cfg_read_timeout;
acl::master_int_tbl var_conf_int_tab[] = {
	{ "thread_pool_limit", 100, &var_cfg_thread_pool_limit, 0, 0 },
	{ "read_timeout", 120, &var_cfg_read_timeout, 0, 0 },

	{ 0, 0 , 0 , 0, 0 }
};

long long int  var_cfg_int64;
acl::master_int64_tbl var_conf_int64_tab[] = {
	{ "int64", 120, &var_cfg_int64, 0, 0 },

	{ 0, 0 , 0 , 0, 0 }
};

////////////////////////////////////////////////////////////////////////////////

class request_rpc : public acl::rpc_request
{
public:
	request_rpc(acl::aio_socket_stream* client)
	: io_error_(false)
	, client_(client)
	{
	}

	~request_rpc()
	{
	}

protected:
	// 麯̴߳
	virtual void rpc_run()
	{
		// תΪ

		// 
		acl::socket_stream stream;

		//  get_vstream() õ ACL_VSTREAM 
		//  stream Ϊ acl_cpp  acl е
		// ͷնǻ ACL_VSTREAM ACL_VSTREAM 
		// ڲάһ/дڳӵݴУ
		// ÿν ACL_VSTREAM ΪڲĻԴ
		ACL_VSTREAM* vstream = client_->get_vstream();
		ACL_VSTREAM_SET_RWTIMO(vstream, 10);

		// ΪģʽͬдЧ
		acl_non_blocking(ACL_VSTREAM_SOCK(vstream), ACL_BLOCKING);

		// ͬд
		(void) stream.open(vstream);

		// ʼ
		handle_conn(stream);

		//  ACL_VSTREAM 󶨣ܱ֤ͷʱ
		// رߵӣΪӱڷģҪ
		// 첽رշʽйر
		stream.unbind();
	}

	// 麯̴߳յ߳ɵϢ
	virtual void rpc_onover()
	{
		// ر첽
		client_->close();

		// 
		delete this;
	}

	/**
	 * ӿڣ̵߳ñ rpc_signal ʱ߳л
	 * ñӿڣ֪ͨδǰ( rpc_onover ǰ)յ
	 * ߳ем״̬ϢڲԶ֧׽ӿڻ WIN32 
	 * ϢӦó磬 HTTP Ӧã߳п
	 * һأһ̷߳( rpc_signal )ؽ̣
	 * ̻߳ñʵĴ˷Ϣ
	 */
	virtual void rpc_wakeup(void*)
	{
	}

private:
	bool io_error_;
	acl::aio_socket_stream* client_;

	void handle_conn(acl::socket_stream& stream)
	{
		acl::string buf;

		// 첽תΪͬʽԸӳؽжд

		if (stream.gets(buf, false) == false)
		{
			logger_warn("gets error!");
			io_error_ = true;
		}
		else if (stream.write(buf) == -1)
		{
			logger_warn("write error!");
			io_error_ = true;
		}
	}
};

////////////////////////////////////////////////////////////////////////////////

// acl::aio_callback ඨ
class io_callback : public acl::aio_callback
{
public:
	io_callback(acl::aio_socket_stream* client)
		: client_(client)
	{
	}

	~io_callback()
	{
	}

protected:
	/** 
	 * ʵָе麯ͻĶɹص 
	 * @param data {char*} ݵַ 
	 * @param len {int} ݳ 
	 * @return {bool}  true ʾϣرո첽 
	 */  
	virtual bool read_callback(char* data, int len)  
	{
		if (strncmp(data, "quit", len) == 0)
		{
			// ʽص첽Ĺرչ̣Ҳֱӷ false
			// ֪ͨ첽Զرո첽
			// client_->close();
			return false;
		}
		return true;
	}

	virtual bool read_wakeup()
	{
		// Ϊֹ߳ͻӶӱرգ
		// Ա첽ȥԸ첽ļ
		// ӻ request_rpc::rpc_onover бر
		client_->disable_read();

		// ͬ
		request_rpc* req = new request_rpc(client_);

		// ݴͨ rpc ̴ͨ߳
		rpc_manager::get_instance().fork(req);

		return true;
	}

	/** 
	 * ʵָе麯ͻдɹص 
	 * @return {bool}  true ʾϣرո첽 
	 */  
	virtual bool write_callback()  
	{
		return true;  
	}

	/** 
	 * ʵָе麯ͻĹرջص 
	 */  
	virtual void close_callback()  
	{
		// ڴ˴ɾö̬ĻصԷֹڴй¶  
		delete this;  
	}

	/** 
	 * ʵָе麯ͻĳʱص 
	 * @return {bool}  true ʾϣرո첽 
	 */  
	virtual bool timeout_callback()  
	{
		//  false ֪ͨ첽ܹرո첽
		return false;
	}

private:
	acl::aio_socket_stream* client_;
};

////////////////////////////////////////////////////////////////////////////////

master_service::master_service()
{
}

master_service::~master_service()
{
}

bool master_service::on_accept(acl::aio_socket_stream* client)
{
	// 첽ͻĻص첽а
	io_callback* callback = new io_callback(client);

	// ע첽Ķص
	client->add_read_callback(callback);

	// ע첽дص
	client->add_write_callback(callback);

	// ע첽Ĺرջص
	client->add_close_callback(callback);

	// ע첽ĳʱص
	client->add_timeout_callback(callback);

	// дӭϢ
	// client->format("hello, you're welcome\r\n");

	// 첽Ķ״̬ݿɶʱص acl::aio_callback
	// е read_wakeup 麯
	client->read_wait(var_cfg_read_timeout);
	return true;
}

void master_service::proc_on_init()
{
	// 첽ܵ¼
	acl::aio_handle* handle = get_handle();

	// ʼ rpc 
	rpc_manager::get_instance().init(handle, var_cfg_thread_pool_limit);
}

void master_service::proc_on_exit()
{
}
