#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stream/aio_stream.hpp"

namespace acl
{

class aio_socket_stream;

/**
 * 첽յµĿͻʱô˻صеĻص
 * Ϊ࣬Ҫʵ accept_callback ص
 */
class ACL_CPP_API aio_accept_callback : public aio_callback
{
public:
	aio_accept_callback() {}
	virtual ~aio_accept_callback() {}

	/**
	 * յµĿͻʱĻص
	 * @param client {aio_socket_stream*} ͻ첽
	 *  ԶԴжд
	 * @return {bool} ϣرո첽Է false
	 *  һ㲻Ӧ false
	 */
	virtual bool accept_callback(aio_socket_stream* client) = 0;
protected:
private:
};

/**
 * 첽ڿͻ˵ӣͬʱֻ
 * ڶϷ䣬ջ䣬ӦÿԵ close رر
 * 첽Զͷţ delete ɾ
 *
 */
class ACL_CPP_API aio_listen_stream : public aio_stream
{
public:
	/**
	 * 캯Թ첽
	 * @param handle {aio_handle*} 첽
	 */
	aio_listen_stream(aio_handle* handle);

	/**
	 * 첽յ¿ͻʱĻص
	 * @param callback {aio_accept_callback*}
	 */
	void add_accept_callback(aio_accept_callback* callback);

	/**
	 * ʼĳַָΪ׽ӿڣҲΪ׽ӿڣ
	 * @param addr {const char*} ַTCPַַ
	 * ʽ
	 *      TCPӣIP:PORT磺127.0.0.1:9001
	 *      ׽ӿڣ{path}磺/tmp/my.sock
	 * @return {bool} Ƿɹ
	 */
	bool open(const char* addr);

	/**
	 * ÷ַ
	 * @return {const char*}
	 */
	const char* get_addr() const;

	virtual void destroy();
protected:
	virtual ~aio_listen_stream();
private:
	bool accept_hooked_;
	char  addr_[256];
	std::list<aio_accept_callback*> accept_callbacks_;

	void hook_accept();
	static int accept_callback(ACL_ASTREAM*,  void*);
};

}  // namespace acl
