#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include <map>
#include "acl_cpp/stdlib/string.hpp"

namespace acl {

// 洢ֵĻ壬ҪΪ˼ֵ
// ΪƵζӵĽṹ
typedef enum
{
	TODO_NUL,
	TODO_SET,
	TODO_DEL
} todo_t;

struct VBUF
{
	size_t len;
	size_t size;
	todo_t todo;
	char  buf[1];
};

/**
 * session ࣬ʹ memcached 洢 session 
 */
class ACL_CPP_API session
{
public:
	/**
	 * 캯Ĳ sid ǿʱ session ʹø
	 * sidڲԶһ sidûӦͨ get_sid()
	 * Զɵ sid Աÿβѯ sid Ӧ
	 * @param ttl {time_t} ָ session ()
	 * @param sid {const char*} ǿʱ session  sid ʹ
	 *  ֵڲһ session sid
	 *  sid ͨ get_sid() ãȻʹùУû
	 *  Ҳͨ set_sid() ޸ı session sid
	 *  ⣬ sid Ϊգûĳ sid Ӧ
	 *  ݣûȵ set_sid()
	 */
	session(time_t ttl = 0, const char* sid = NULL);
	virtual ~session(void);
	
	/**
	 * ڲ״̬һЩʱ
	 */
	void reset(void);

	/**
	 * ñ session Ψһ ID ʶ
	 * @return {const char*} ǿ
	 */
	virtual const char* get_sid(void) const;

	/**
	 * ñ session Ψһ ID ʶ
	 * @param sid {const char*} ǿ
	 * עñ󣬻Զ֮ǰм仺
	 */
	void set_sid(const char* sid);

	/**
	 *  session  set/set_ttl ʱһ delay Ϊ true
	 * ͨñи
	 * @return {bool} ݸǷɹ
	 */
	bool flush();

	/**
	 *  session µַԣͬʱø
	 * session Ĺʱ()
	 * @param name {const char*} session ǿ
	 * @param value {const char*} session ֵǿ
	 * @param delay {bool} Ϊ true ʱӳٷ͸ָ˵
	 *  û session::flush ٽݸ£
	 *  ߴЧʣΪ false ʱ̸
	 * @return {bool}  false ʾ
	 */
	bool set(const char* name, const char* value, bool delay = false);

	/**
	 *  session µԶͬʱø
	 * session Ĺʱ()
	 * @param name {const char*} session ǿ
	 * @param value {const char*} session ֵǿ
	 * @param len {size_t} value ֵ
	 * @param delay {bool} Ϊ true ʱӳٷ͸ָ˵
	 *  û session::flush ٽݸ£
	 *  ߴЧʣΪ false ʱ̸
	 * @return {bool}  false ʾ
	 */
	bool set(const char* name, const void* value, size_t len, bool delay = false);
	
	/**
	 *  session ȡֵַ
	 * @param name {const char*} session ǿ
	 * @param local_cached {bool}  session Ӻ cache 
	 *  ȡһݺòΪ trueñʱ
	 *  Ǳ󻺴ݣÿζҪӺȡÿñ
	 *  Ӻ cache ȡ
	 * @return {const char*} session ֵصַָԶǿգû
	 *  ͨжϷصǷǿմ(: "\0")жϳ򲻴
	 *  עúطǿݺûӦ̱˷ֵΪ´
	 *      ÿܻʱ
	 */
	const char* get(const char* name, bool local_cached = false);

	/**
	 *  session ȡö͵ֵ
	 * @param name {const char*} session ǿ
	 * @param local_cached {bool}  session Ӻ cache 
	 *  ȡһݺòΪ trueñʱ
	 *  Ǳ󻺴ݣÿζҪӺȡÿñ
	 *  Ӻ cache ȡ
	 * @return {const VBUF*} session ֵؿʱʾ򲻴
	 *  עúطǿݺûӦ̱˷ֵΪ´
	 *      ÿܻʱ
	 */
	const VBUF* get_vbuf(const char* name, bool local_cached = false);

	/**
	 *  session ɾֵָеıɾ
	 * ʱὫ memcached ɾ
	 * @param name {const char*} session ǿ
	 * @param delay {bool} Ϊ true ʱӳٷ͸ָ˵
	 *  û session::flush ٽݸ£
	 *  ߴЧʣΪ false ʱ̸
	 * @return {bool} true ʾɹ()false ʾɾʧ
	 */
	bool del(const char* name, bool delay = false);

	/**
	 *  session ڻϵĻʱ
	 * @param ttl {time_t} ()
	 * @param delay {bool} Ϊ true ʱӳٷ͸ָ˵
	 *  û session::flush ٽݸ£
	 *  ߴЧʣΪ false ʱ̸
	 * @return {bool} Ƿɹ
	 */
	bool set_ttl(time_t ttl, bool delay = true);

	/**
	 * ñ session м¼ session ڣֵп
	 * 洢ڻʱ䲻һ£Ϊпʵ
	 *  session ڻϵ
	 * @return {time_t}
	 */
	time_t get_ttl(void) const;

	/**
	 * ʹ session ӷ˵Ļɾʹ session ʧЧ
	 * @return {bool} Ƿʹ session ʧЧ
	 */
	bool remove(void);

protected:
	// öӦ sid 
	virtual bool get_data(const char* sid, string& buf) = 0;

	// öӦ sid 
	virtual bool set_data(const char* sid, const char* buf,
		size_t len, time_t ttl) = 0;

	// ɾӦ sid 
	virtual bool del_data(const char* sid) = 0;

	// öӦ sid ݵĹʱ
	virtual bool set_timeout(const char* sid, time_t ttl) = 0;

private:
	time_t ttl_;
	VBUF* sid_;

	// ñҪ set_ttl УƲ sid_ ֻ²
	// һûں cache ˴洢 set_ttl º
	//  cache 
	bool sid_saved_;
	bool dirty_;
	std::map<string, VBUF*> attrs_;
	std::map<string, VBUF*> attrs_cache_;

	//  session л
	static void serialize(const std::map<string, VBUF*>& attrs, string& out);

	static void serialize(const char* name, const void* value,
		size_t len, string& buf);

	//  session ݷл
	static void deserialize(string& buf, std::map<string, VBUF*>& attrs);

	//  session Լ
	static void attrs_clear(std::map<string, VBUF*>& attrs);

	// ڴ
	static VBUF* vbuf_new(const void* str, size_t len, todo_t todo);

	// ڴֵڴռ䲻·
	// ڴ棬߱÷ֵΪµڴ󣬸ö
	// ԭеڴҲпµڴ
	static VBUF* vbuf_set(VBUF* buf, const void* str, size_t len, todo_t todo);

	// ͷڴ
	static void vbuf_free(VBUF* buf);
};

} // namespace acl
