#pragma once
#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/http/http_header.hpp"

namespace acl {

class http_client;
class http_pipe;
class socket_stream;
class xml;
class json;

class ACL_CPP_API http_response
{
public:
	/**
	 * 캯ͨù캯 socket_stream 
	 * ᱻرգҪԼر
	 * @param client {socket_stream*} ǿ
	 * עʵڳʱԱʹãһעʹ
	 * ˳get_body->response
	 */
	http_response(socket_stream* client);
	virtual ~http_response(void);

	/////////////////////////////////////////////////////////////////////
	// ȡصķ

	/**
	 * ȡ HTTP ͻ˵ HTTP ͷڵñſԵ
	 * get_body/read_body ȡ HTTP 
	 * @return {bool} Ƿɹ
	 */
	bool read_header();

	/**
	 * ȡ xml ʽ HTTP 壬˺Ӧõ
	 * response ͻ˷Ӧݣúÿαʱڲ
	 * ᱻʼԸúڶỰбε
	 * @param out {xml&}  HTTP ݴ洢ڸ xml 
	 * @param to_charset {const char*} ǿգڲԶ
	 *  תɸַ洢 xml 
	 * @return {bool} Ƿ
	 *  עȵ read_header ܵñ
	 *      رʱӦô˺ڴĹ
	 */
	bool get_body(xml& out, const char* to_charset = NULL);

	/**
	 * ȡ json ʽ HTTP 壬˺Ӧõ
	 * response ͻ˷Ӧݣúÿαʱڲ
	 * ᱻʼԸúڶỰбε
	 * @param out {json&}  HTTP ݴ洢ڸ json 
	 * @param to_charset {const char*} ǿգڲԶ
	 *  תɸַ洢 json 
	 * @return {bool} Ƿ
	 *  עȵ read_header ܵñ
	 *      رʱӦô˺ڴĹ
	 */
	bool get_body(json& out, const char* to_charset = NULL);

	/*
	 * ȡ HTTP ȫݲ洢Ļ
	 * @param out {string&} 洢
	 * @param to_charset {const char*} ǿգڲԶ
	 *  תɸַ洢 out 
	 * עرʱӦô˺ڴĹ
	 *     ȵ read_header ܵñ
	 */
	bool get_body(string& out, const char* to_charset = NULL);

	/*
	 * ȡ HTTP ݲ洢ĻУѭ
	 * ñֱݶˣ
	 * @param buf {char*} 洢
	 * @param size {size_t} buf С
	 * @return {int} ֵ == 0 ʾϣ< 0 ʾͻ
	 *  رӣ> 0 ʾѾݣûӦһֱֱ
	 *  ֵ <= 0 Ϊֹ
	 *  עúԭʼ HTTP ݣѹַ
	 *     룬ûԼҪдȵ read_header
	 *     ܵñ
	 */
	int read_body(char* buf, size_t size);

	/////////////////////////////////////////////////////////////////////
	// Ӧصķ

	/**
	 *  HTTP ӦͷȻڷص HTTP Ӧͷ
	 * ԼӦͷֶλ http_header::reset()Ӧͷ״̬
	 * οhttp_header 
	 * @return {http_header&}
	 */
	http_header& response_header(void);

	/**
	 * ͻ˷ HTTP Ӧݣѭô˺
	 * <b>ڵñǰǰ֤²</b>
	 * 1ȵ read_header && get_body  HTTP ͻ˵ݣ
	 * 2ͨ response_header ȡ http_header ͬʱӦͷ
	 *    ֶΣ磺set_status, set_keep_alive ȣ
	 * <b>ڵñʱ²ᷢ</b>
	 * 1ڲԶڵһдʱ HTTP Ӧͷ
	 * 2ͨ http_header::set_chunked  chunked ䷽ʽ
	 * ڲԶ chunked ䷽ʽ
	 * 3ʹ chunked ʽʱӦٵһα
	 * ҲΪ 0 ʾݽ
	 * @param data {const void*} ݵַ
	 * @param len {size_t} data ݳ
	 * @return {bool} Ƿɹ false ʾж
	 */
	bool response(const void* data, size_t len);

	//////////////////////////////////////////////////////////////////////////

	/**
	 *  http_client HTTP ͨصĶ
	 * ͻͷĲݣοhttp_client 
	 * @return {http_client*} ؿʱʾ
	 */
	http_client* get_client(void) const;

	/**
	 * ر HTTP 
	 */
	void close(void);
protected:
private:
	bool debug_;
	bool header_ok_;
	http_client* client_;
	http_header  header_;
	bool head_sent_;
	http_pipe* get_pipe(const char* to_charset);
};

} // namespace acl
