#pragma once
#include "acl_cpp/stream/aio_handle.hpp"
#include "acl_cpp/ipc/ipc_service.hpp"
#include "acl_cpp/http/http_header.hpp"

namespace acl {

class string;

/**
 * HTTP ̳࣬и
 */
class ACL_CPP_API http_service_request : public http_header
{
public:
	/**
	 * 캯
	 * @param domain {const char*} HTTP (ҲIP)ǿ
	 *  ˿ֵ fatal
	 * @param port {unsigned short} HTTP ˿
	 */
	http_service_request(const char* domain, unsigned short port);

	/**
	 * ɹ캯 domain
	 * @return {const char*} Ϊ
	 */
	const char* get_domain(void) const;

	/**
	 * ɹ캯 port
	 * @return {unsigned short}
	 */
	unsigned short get_port(void) const;

	/**
	 * ϻʱڲ̻Զ destroy ӿڣ
	 * ڸýӿڽһЩͷẒ́䵱öǶ̬ʱ
	 * Ӧڸú delete this ɾԼΪúտ϶
	 * ᱻã಻Ӧط
	 */
	virtual void destroy(void) {}

	//////////////////////////////////////////////////////////////////////////
	// ʵӿ

	/**
	 *  HTTP ݣúбѭãֱصݶ
	 * еΪ
	 * @return {const string*} ݣؿָ򷵻صĻ
	 *  Ϊ( string->empty()) ʾ HTTP ݽ
	 * ע⣺ͬӿ߳бõģʵ
	 *     ˸ýӿڣҪԭ߳̾߱ԴʱӦע
	 */
	virtual const string* get_body(void);

	/**
	 *  HTTP  HTTP ӦͷʱĻصӿ
	 * @param addr {const char*} ֮ӵַʽIP:PORT
	 * @param hdr {const HTTP_HDR_RES*} HTTP Ӧͷýṹμ
	 *  acl_project/lib_protocol/include/http/lib_http_struct.h
	 */
	virtual void on_hdr(const char* addr, const HTTP_HDR_RES* hdr) = 0;

	/**
	 *  HTTP  HTTP ӦʱĻصӿڣ HTTP Ӧ
	 * Ƚϴʱûصᱻεãֱ( on_error)ݶ
	 * ʱûص 0 data  dlen Ϊ 0 ʱ HTTP
	 * Ӧ
	 * @param data {const char*} ĳζʱ HTTP Ӧ
	 * @param dlen {size_t} ĳζʱ HTTP Ӧݳ
	 * ע HTTP Ӧֻͷݶû壬Ҳøú֪ͨû
	 *     HTTP Ự
	 */
	virtual void on_body(const char* data, size_t dlen) = 0;

	/**
	 *  HTTP Ӧô˽ӿڣ֪ͨ
	 * ڵô˽ӿں
	 * @param errnum {http_status_t} 
	 */
	virtual void on_error(http_status_t errnum) = 0;
protected:
	virtual ~http_service_request(void);
private:
	char* domain_;
	unsigned short port_;
};

class aio_socket_stream;

class ACL_CPP_API http_service : public ipc_service
{
public:
	/**
	 * 캯
	 * @param nthread {int} ֵ > 1 ڲԶ̳߳أ
	 *  һһ߳
	 * @param nwait {int} 첽 ENGINE_WINMSG ʱΪ˱
	 *  ̷߳͵Ϣ̵߳ WIN32 Ϣѭ
	 *  ̷߳ϢʱԶߵĺ첽棬
	 *  ֵҲٹ
	 * @param win32_gui {bool} ǷǴϢǣڲ
	 *  ͨѶģʽԶΪ WIN32 ϢȻͨõ׽
	 *  ͨѶʽ
	 */
	http_service(int nthread = 1, int nwait = 1, bool win32_gui = false);
	~http_service(void);

	/**
	 * Ӧõô˺ʼ HTTP Ự̣ http_service 
	 * 첽 HTTP ͬʱ첽ȡ HTTP Ӧ
	 * @param req {http_service_request*} HTTP 
	 */
	void do_request(http_service_request* req);
protected:
#ifdef WIN32
	/**
	 * 麯յ̵߳ win32 ϢʱĻص
	 * @param hWnd {HWND} ھ
	 * @param msg {UINT} ûԶϢ
	 * @param wParam {WPARAM} 
	 * @param lParam {LPARAM} 
	 */
	virtual void win32_proc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
#endif
	/**
	 * 麯ӵʱص˺
	 * @param client {aio_socket_stream*} յµĿͻ
	 */
	virtual void on_accept(aio_socket_stream* client);

	/**
	 * 麯ɹ򿪺Ļص
	 * @param addr {const char*} ʵʵļַʽIP:PORT
	 */
	virtual void on_open(const char*addr);

	/**
	 * 麯رʱĻص
	 */
	virtual void on_close(void);
private:
	char* addr_;
	int   nwait_;
	aio_handle_type handle_type_;
};

}  // namespace acl
