#ifndef ACL_DBSQL_INCLUDE_H
#define ACL_DBSQL_INCLUDE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdlib/acl_define.h"
#include "acl_dbpool.h"

#ifndef	ACL_DB_ATOU
#define ACL_DB_ATOU(_str_) (_str_ ? strtoul(_str_, (char **) NULL, 10) : 0)
#endif

/**
 * ݿѯ䣬û select SQL ݿѯ
 * @param handle {ACL_DB_HANDLE*} ݿӾΪ
 * @param sql {const char*} select ѯ䣬Ϊ
 * @param error {int*} ֵ NULL Ҹñǿָָĵַ
 *  ĴţŲμ acl_dberr.h
 * @return {ACL_SQL_RES*} ѯѯʧܻѯΪգ򷵻
 *  NULL򷵻 ACL_SQL_RES (ýҪ acl_dbsql_free_result
 *  ͷ)ʾ
 *
 *  ACL_DB_HANDLE* handle = ...;
 *  ACL_SQL_RES* res = acl_dbsql_select(...);
 *  ACL_ITER iter;
 *  if (res)
 *  {
 *    acl_foreach(iter, res)
 *    {
 *      const char **my_row = (const char**) iter.data;
 *      printf("first item: %s\n", my_row[0]);
 *      ...
 *    }
 *    acl_dbsql_free_result(handle, res);
 *  }
 *
 */
ACL_API ACL_SQL_RES *acl_dbsql_select(ACL_DB_HANDLE *handle,
	const char *sql, int *error);

/**
 * ͷ acl_dbsql_select صĽ
 * @param handle {ACL_DB_HANDLE*} ݿӾΪ
 * @param res {ACL_SQL_RES*} acl_dbsql_select صĽ󣬲Ϊ
 */
ACL_API void acl_dbsql_free_result(ACL_DB_HANDLE *handle, ACL_SQL_RES *res);

/**
 * ԻصķʽѯݿзĽѯͨû
 * Ļصظû
 * @param handle {ACL_DB_HANDLE*} ݿӾΪ
 * @param sql {const char*} select ѯ䣬Ϊ
 * @param error {int*} ֵ -1 Ҹñǿָָĵַ
 *  ĴţŲμ acl_dberr.h
 * @param walk_fn {int (*)(const void**, void*)}ûõĲѯص
 *  ǿգÿһĽصøûصѯΪ
 *  Զصθûصе result_row һָ룬ûԼ
 *  Ļص result_row[i] ȡԼҪ( select 
 *  еƥ)
 * @param arg {void*} ûԶĲòԶݸ walk_fn ص
 *  Ϊ walk_fn һ
 * @return {int} ѯ -1 ʾѯʧܣ0 ʾûз
 *  ѯĽ> 0 ʾѯĽ
 */
ACL_API int acl_dbsql_results(ACL_DB_HANDLE *handle, const char *sql, int *error,
	int (*walk_fn)(const void** result_row, void *arg), void *arg);

/**
 * Իصķʽݿвѯһ¼ѯͨûõĻصظû
 * @param handle {ACL_DB_HANDLE*} ݿӾΪ
 * @param sql {const char*} select ѯ䣬Ϊ
 * @param error {int*} ֵ -1 Ҹñǿָָĵַ
 *  ĴţŲμ acl_dberr.h
 * @param walk_fn {int (*)(const void**, void*)}ûõĲѯص
 *  ǿգ鵽һĽʱصøûص acl_dbsql_results 
 *  ͬûصֻᱻһΣе result_row һָ룬û
 *  ԼĻص result_row[i] ȡԼҪ( select
 *  еƥ)
 * @param arg {void*} ûԶĲòԶݸ walk_fn ص
 *  Ϊ walk_fn һ
 * @return {int} ֵֻ״̬-1 ʾѯʧܣ0 ʾѯΪգ
 *  1 ʾ鵽һ -1  *error ¼ʧԭ򣬲μ acl_dberr.h
 */
ACL_API int acl_dbsql_result(ACL_DB_HANDLE *handle, const char *sql, int *error,
	int (*walk_fn)(const void** result_row, void *arg), void *arg);

/**
 * ݿݣupdate, insert, delete ޸ݿĲʹøú
 * @param handle {ACL_DB_HANDLE*} ݿӾΪ
 * @param sql {const char*} ݿ޸䣬Ϊ
 * @param error {int*} ֵ -1 Ҹñǿָָĵַ
 *  ĴţŲμ acl_dberr.h
 * @return {int} ֵֻ״̬-1 ʾʧ( error ָǿм¼
 *  ԭ򣬴Ųμ: acl_dberr.h)0 ʾ³ɹδӰݿԭʼϢ
 *  (ԭǱϢݿԭϢͬ)> 0 ʾݿݴ洢
 */
ACL_API int acl_dbsql_update(ACL_DB_HANDLE *handle, const char *sql, int *error);

#ifdef __cplusplus
}
#endif

#endif

