#pragma once

namespace acl
{

/**
 * 麯߳࣬ʵ run ߳бִе
 */
class ACL_CPP_API thread_job
{
public:
	thread_job() {}
	virtual ~thread_job() {}

	/**
	 * 麯ʵִ˺úִ߳
	 * @return {void*} ߳˳ǰصĲ
	 */
	virtual void* run() = 0;
};

/**
 * ̴߳࣬Ľӿڶ Java Ľӿڶ壬Ҫʵ
 * Ĵ麯ʹͨ thread::start() ̹߳
 */
class ACL_CPP_API thread : public thread_job
{
public:
	thread();
	virtual ~thread();

	/**
	 * ʼ̹̣߳һúãһµ
	 * ִ̣߳߳л thread_job::run 
	 * @return {bool} Ƿɹ߳
	 */
	bool start();

	/**
	 * ߳ʱΪ detachable ״̬ô˺ȴ߳̽
	 * ߳ʱΪ detachable ״̬ʱֹñ
	 * @param out {void**} òǿָʱò
	 *  ߳˳ǰصĲ
	 * @return {bool} Ƿɹ
	 */
	bool wait(void** out = NULL);

	/**
	 * ڵ start ǰô˺߳ǷΪ
	 *  (detachable) ״̬δô˺
	 * ߳ĬΪ״̬
	 * @param yes {bool} ǷΪ״̬
	 * @return {thread&}
	 */
	thread& set_detachable(bool yes);

	/**
	 * ڵ start ǰô˺̵߳ĶջС
	 * @param size {size_t} ̶߳ջСֵΪ 0 δ
	 *  ô˺̶߳ջСΪϵͳĬֵ
	 * @return {thread&}
	 */
	thread& set_stacksize(size_t size);

	/**
	 * ڵ start ô˺Ի̵߳ id 
	 * @return {unsigned long}
	 */
	unsigned long thread_id() const;

	/**
	 * ǰ̵߳߳ id 
	 * @return {unsigned long}
	 */
	static unsigned long thread_self();

private:
	bool detachable_;
	size_t stack_size_;
#ifdef WIN32
	void* thread_;
	unsigned long thread_id_;
#else
	pthread_t thread_;
	unsigned long thread_id_;
#endif
	void* return_arg_;
	static void* thread_run(void* arg);
};

} // namespace acl
