#pragma once

#include "acl_cpp/acl_cpp_define.hpp"
#include "acl_cpp/stream/stream_hook.hpp"

struct ACL_VSTREAM;

namespace acl {

class polarssl_conf;

/**
 * stream/aio_stream ײ IO ̵Ĵ࣬еĶдĹ̽
 * stream/aio_stream  Ĭϵĵײ IO ̣Ƕ̬(ΪѶ)
 * stream/aio_stream ͨñ destroy()ͷű
 */
class ACL_CPP_API polarssl_io : public stream_hook
{
public:
	/**
	 * 캯
	 * @param conf {polarssl_conf&} ÿһ SSL ӽõ
	 * @param server_side {bool} ǷΪģʽΪͻģʽ
	 *  ģʽַͬͨ˲
	 * @param aio_mode {bool} ǷΪģʽ
	 */
	polarssl_io(polarssl_conf& conf, bool server_side,
		bool non_block = false);

	virtual void destroy();

	/**
	 * ô˷ SSL ֣ڷ IO ģʽ¸úҪ handshake_ok()
	 * ʹж SSL Ƿɹ
	 * @return {bool}
	 *  1 false ʾʧܣҪرӣ
	 *  2 true ʱ
	 *  2.1Ϊ IO ģʽʾ SSL ֳɹ
	 *  2.2ڷ IO ģʽ½ֹ IO ǳɹģҪ
	 *       handshake_ok() ж SSL Ƿɹ
	 */
	bool handshake(void);

	/**
	 * ж SSL Ƿɹ
	 * @return {bool}
	 */
	bool handshake_ok(void)
	{
		return handshake_ok_;
	}

	/**
	 * ׽Ϊģʽ/ģʽ
	 * @param yes {bool} Ϊ false ʱΪģʽΪģʽ
	 * @return {polarssl_io&}
	 */
	polarssl_io& set_non_blocking(bool yes);

	/**
	 * жϵǰõ SSL IO ǷģʽǷģʽ
	 * @return {bool}  true ʾΪģʽΪģʽ
	 */
	bool is_non_blocking(void) const
	{
		return non_block_;
	}


	/**
	 * Է֤ǷЧһ㲻صô˺
	 * @return {bool}
	 */
	bool check_peer(void);

private:
	~polarssl_io();

	virtual bool open(ACL_VSTREAM* s);
	virtual bool on_close(bool alive);
	virtual int read(void* buf, size_t len);
	virtual int send(const void* buf, size_t len);

private:
	polarssl_conf& conf_;
	bool  server_side_;
	bool  non_block_;
	bool  handshake_ok_;
	void* ssl_;
	void* ssn_;
	void* rnd_;
	ACL_VSTREAM* stream_;

	static int sock_read(void *ctx, unsigned char *buf, size_t len);
	static int sock_send(void *ctx, const unsigned char *buf, size_t len);
};

} // namespace acl
